/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.se;

import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Vector2D_F64;
import georegression.struct.se.SpecialEuclidean;
import org.jetbrains.annotations.Nullable;

public class Se2_F64
implements SpecialEuclidean<Se2_F64> {
    public Vector2D_F64 T = new Vector2D_F64();
    public double c;
    public double s;

    public Se2_F64(GeoTuple2D_F64 T, double yaw) {
        this(T.getX(), T.getY(), yaw);
    }

    public Se2_F64(double x, double y, double yaw) {
        this.setTo(x, y, yaw);
    }

    public Se2_F64(double x, double y, double cosYaw, double sinYaw) {
        this.setTo(x, y, cosYaw, sinYaw);
    }

    public Se2_F64() {
        this.c = 1.0;
    }

    public Se2_F64 setTo(double x, double y, double yaw) {
        this.T.setTo(x, y);
        this.c = Math.cos(yaw);
        this.s = Math.sin(yaw);
        return this;
    }

    public Se2_F64 setTo(double x, double y, double cosYaw, double sinYaw) {
        this.T.setTo(x, y);
        this.c = cosYaw;
        this.s = sinYaw;
        return this;
    }

    public void zero() {
        this.setTo(0.0, 0.0, 1.0, 0.0);
    }

    @Override
    public Se2_F64 setTo(Se2_F64 target) {
        this.T.setTo(target.T);
        this.c = target.c;
        this.s = target.s;
        return this;
    }

    public double getX() {
        return this.T.getX();
    }

    public void setX(double x) {
        this.T.setX(x);
    }

    public double getY() {
        return this.T.getY();
    }

    public void setY(double y) {
        this.T.setY(y);
    }

    public Vector2D_F64 getTranslation() {
        return this.T;
    }

    public void setTranslation(Vector2D_F64 tran) {
        this.T = tran;
    }

    public void setTranslation(double x, double y) {
        this.T.setTo(x, y);
    }

    public double getYaw() {
        return Math.atan2(this.s, this.c);
    }

    public void setYaw(double yaw) {
        this.c = Math.cos(yaw);
        this.s = Math.sin(yaw);
    }

    public double getCosineYaw() {
        return this.c;
    }

    public double getSineYaw() {
        return this.s;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Se2_F64 createInstance() {
        return new Se2_F64();
    }

    @Override
    public Se2_F64 concat(Se2_F64 second, @Nullable Se2_F64 result) {
        if (result == null) {
            result = new Se2_F64();
        }
        result.setYaw(this.getYaw() + second.getYaw());
        result.T.x = second.T.x + second.c * this.T.x - second.s * this.T.y;
        result.T.y = second.T.y + second.s * this.T.x + second.c * this.T.y;
        return result;
    }

    @Override
    public Se2_F64 invert(@Nullable Se2_F64 inverse) {
        if (inverse == null) {
            inverse = new Se2_F64();
        }
        double x = -this.T.x;
        double y = -this.T.y;
        inverse.s = -this.s;
        inverse.c = this.c;
        inverse.T.x = this.c * x + this.s * y;
        inverse.T.y = -this.s * x + this.c * y;
        return inverse;
    }

    @Override
    public void reset() {
        this.c = 1.0;
        this.s = 0.0;
        this.T.setTo(0.0, 0.0);
    }

    public Se2_F64 copy() {
        return new Se2_F64(this.T.x, this.T.y, this.c, this.s);
    }

    public String toString() {
        return "Se2( x = " + this.T.x + " y = " + this.T.y + " yaw = " + this.getYaw() + " )";
    }

    public void print() {
        System.out.println(this);
    }
}

