/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.point;

import georegression.struct.GeoTuple4D_F64;
import georegression.struct.point.Point4D_F64;

public class Vector4D_F64
extends GeoTuple4D_F64<Vector4D_F64> {
    public Vector4D_F64(double x, double y, double z, double w) {
        super(x, y, z, w);
    }

    public Vector4D_F64() {
    }

    public Vector4D_F64(Point4D_F64 a, Point4D_F64 b) {
        this.x = b.getX() - a.getX();
        this.y = b.getY() - a.getY();
        this.z = b.getZ() - a.getZ();
        this.w = b.getW() - a.getW();
    }

    @Override
    public Vector4D_F64 times(double scalar) {
        return new Vector4D_F64(this.x * scalar, this.y * scalar, this.z * scalar, this.w * scalar);
    }

    @Override
    public Vector4D_F64 createNewInstance() {
        return new Vector4D_F64();
    }

    public String toString() {
        return this.toString("V");
    }

    @Override
    public void normalize() {
        double r = this.norm();
        this.x /= r;
        this.y /= r;
        this.z /= r;
        this.w /= r;
    }

    public double dot(Vector4D_F64 a) {
        return this.x * a.x + this.y * a.y + this.z * a.z + this.w * a.w;
    }
}

