/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.point;

import georegression.geometry.GeometryMath_F32;
import georegression.geometry.UtilVector3D_F32;
import georegression.struct.GeoTuple3D_F32;
import georegression.struct.point.Point3D_F32;

public class Vector3D_F32
extends GeoTuple3D_F32<Vector3D_F32> {
    public Vector3D_F32(GeoTuple3D_F32 orig) {
        this(orig.x, orig.y, orig.z);
    }

    public Vector3D_F32(float x, float y, float z) {
        super(x, y, z);
    }

    public Vector3D_F32() {
    }

    public Vector3D_F32(Point3D_F32 a, Point3D_F32 b) {
        this.x = b.getX() - a.getX();
        this.y = b.getY() - a.getY();
        this.z = b.getZ() - a.getZ();
    }

    public void minus(Point3D_F32 a, Point3D_F32 b) {
        this.x = a.x - b.x;
        this.y = a.y - b.y;
        this.z = a.z - b.z;
    }

    public void divide(float value) {
        this.x /= value;
        this.y /= value;
        this.z /= value;
    }

    public void crossSetTo(Vector3D_F32 a, Vector3D_F32 b) {
        GeometryMath_F32.cross(a, (GeoTuple3D_F32)b, (GeoTuple3D_F32)this);
    }

    public Vector3D_F32 crossWith(Vector3D_F32 b) {
        Vector3D_F32 c = new Vector3D_F32();
        GeometryMath_F32.cross(this, (GeoTuple3D_F32)b, (GeoTuple3D_F32)c);
        return c;
    }

    @Override
    public Vector3D_F32 createNewInstance() {
        return new Vector3D_F32();
    }

    public String toString() {
        return this.toString("V");
    }

    public void normalize() {
        float m = Math.max(Math.max(Math.abs(this.x), Math.abs(this.y)), Math.abs(this.z));
        float x_n = this.x / m;
        float y_n = this.y / m;
        float z_n = this.z / m;
        float v = (float)Math.sqrt(x_n * x_n + y_n * y_n + z_n * z_n);
        this.x = x_n / v;
        this.y = y_n / v;
        this.z = z_n / v;
    }

    public float dot(Vector3D_F32 a) {
        return this.x * a.x + this.y * a.y + this.z * a.z;
    }

    public float dot(float x, float y, float z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public float acute(Vector3D_F32 a) {
        return UtilVector3D_F32.acute(this, a);
    }
}

