/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.point;

import georegression.struct.GeoTuple_I32;
import java.util.Objects;

public class Point2D_I16
extends GeoTuple_I32<Point2D_I16> {
    public short x;
    public short y;

    public Point2D_I16(short x, short y) {
        this.x = x;
        this.y = y;
    }

    public Point2D_I16(Point2D_I16 orig) {
        this.x = orig.x;
        this.y = orig.y;
    }

    public Point2D_I16() {
    }

    public Point2D_I16 setTo(int x, int y) {
        this.x = (short)x;
        this.y = (short)y;
        return this;
    }

    @Override
    public void zero() {
        this.setTo(0, 0);
    }

    public double distance(Point2D_I16 a) {
        return Math.sqrt(this.distance2(a));
    }

    public double distance(int x, int y) {
        return Math.sqrt(this.distance2(x, y));
    }

    public int distance2(Point2D_I16 a) {
        int dx = this.x - a.x;
        int dy = this.y - a.y;
        return dx * dx + dy * dy;
    }

    public int distance2(int x, int y) {
        int dx = this.x - x;
        int dy = this.y - y;
        return dx * dx + dy * dy;
    }

    public void setX(int x) {
        this.x = (short)x;
    }

    public void setY(int y) {
        this.y = (short)y;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public boolean isIdentical(int x, int y) {
        return this.x == x && this.y == y;
    }

    @Override
    public Point2D_I16 setTo(Point2D_I16 src) {
        this.x = src.x;
        this.y = src.y;
        return this;
    }

    @Override
    public int getIdx(int index) {
        if (index == 0) {
            return this.x;
        }
        if (index == 1) {
            return this.y;
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public void setIdx(int index, int value) {
        if (index == 0) {
            this.x = (short)value;
        } else if (index == 1) {
            this.y = (short)value;
        } else {
            throw new RuntimeException("Invalid index " + index);
        }
    }

    public void print() {
        System.out.println(this);
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Point2D_I16 createNewInstance() {
        return new Point2D_I16();
    }

    @Override
    public Point2D_I16 copy() {
        return new Point2D_I16(this.x, this.y);
    }

    public String toString() {
        return "Point2D_I16{ x= " + this.x + ", y= " + this.y + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Point2D_I16)) {
            return false;
        }
        Point2D_I16 o = (Point2D_I16)obj;
        return this.x == o.x && this.y == o.y;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }
}

