/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.line;

import georegression.struct.point.Point2D_I32;
import java.io.Serializable;

public class LineSegment2D_I32
implements Serializable {
    public Point2D_I32 a = new Point2D_I32();
    public Point2D_I32 b = new Point2D_I32();

    public LineSegment2D_I32() {
    }

    public LineSegment2D_I32(Point2D_I32 a, Point2D_I32 b) {
        this.setTo(a, b);
    }

    public LineSegment2D_I32(int x0, int y0, int x1, int y1) {
        this.setTo(x0, y0, x1, y1);
    }

    public static LineSegment2D_I32 wrap(Point2D_I32 a, Point2D_I32 b) {
        LineSegment2D_I32 ret = new LineSegment2D_I32();
        ret.a = a;
        ret.b = b;
        return ret;
    }

    public LineSegment2D_I32 setTo(LineSegment2D_I32 l) {
        this.a.setTo(l.a);
        this.b.setTo(l.b);
        return this;
    }

    public LineSegment2D_I32 setTo(Point2D_I32 a, Point2D_I32 b) {
        this.a.setTo(a);
        this.b.setTo(b);
        return this;
    }

    public LineSegment2D_I32 setTo(int x0, int y0, int x1, int y1) {
        this.a.setTo(x0, y0);
        this.b.setTo(x1, y1);
        return this;
    }

    public void zero() {
        this.a.zero();
        this.b.zero();
    }

    public int slopeX() {
        return this.b.x - this.a.x;
    }

    public int slopeY() {
        return this.b.y - this.a.y;
    }

    public double getLength() {
        return this.a.distance(this.b);
    }

    public int getLength2() {
        return this.a.distance2(this.b);
    }

    public LineSegment2D_I32 copy() {
        return new LineSegment2D_I32(this.a, this.b);
    }

    public String toString() {
        return "LineSegment2D_I32{a=" + this.a + ", b=" + this.b + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LineSegment2D_I32)) {
            return false;
        }
        LineSegment2D_I32 o = (LineSegment2D_I32)obj;
        return this.a.equals(o.a) && this.b.equals(o.b);
    }

    public int hashCode() {
        return this.a.hashCode() + this.b.hashCode();
    }

    public Point2D_I32 getA() {
        return this.a;
    }

    public Point2D_I32 getB() {
        return this.b;
    }

    public void setA(Point2D_I32 a) {
        this.a = a;
    }

    public void setB(Point2D_I32 b) {
        this.b = b;
    }
}

