/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.line;

import java.io.Serializable;
import org.ejml.FancyPrint;

public class LineGeneral2D_F64
implements Serializable {
    public double A;
    public double B;
    public double C;

    public LineGeneral2D_F64(double a, double b, double c) {
        this.setTo(a, b, c);
    }

    public LineGeneral2D_F64(LineGeneral2D_F64 line) {
        this.setTo(line);
    }

    public LineGeneral2D_F64() {
    }

    public LineGeneral2D_F64 setTo(LineGeneral2D_F64 original) {
        this.A = original.A;
        this.B = original.B;
        this.C = original.C;
        return this;
    }

    public LineGeneral2D_F64 setTo(double a, double b, double c) {
        this.A = a;
        this.B = b;
        this.C = c;
        return this;
    }

    public void zero() {
        this.setTo(0.0, 0.0, 0.0);
    }

    public void normalize() {
        double d = Math.sqrt(this.A * this.A + this.B * this.B);
        this.A /= d;
        this.B /= d;
        this.C /= d;
    }

    public double evaluate(double x, double y) {
        return this.A * x + this.B * y + this.C;
    }

    public double evaluate(double x, double y, double z) {
        return this.A * x + this.B * y + this.C * z;
    }

    public LineGeneral2D_F64 copy() {
        return new LineGeneral2D_F64(this);
    }

    public String toString() {
        FancyPrint f = new FancyPrint();
        return this.getClass().getSimpleName() + "{ A=" + f.s(this.A) + " B=" + f.s(this.B) + " C=" + f.s(this.C) + " }";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LineGeneral2D_F64)) {
            return false;
        }
        LineGeneral2D_F64 o = (LineGeneral2D_F64)obj;
        return this.A == o.A && this.B == o.B && this.C == o.C;
    }

    public int hashCode() {
        return Double.hashCode(this.A + this.B + this.C);
    }

    public double getA() {
        return this.A;
    }

    public double getB() {
        return this.B;
    }

    public double getC() {
        return this.C;
    }

    public void setA(double A2) {
        this.A = A2;
    }

    public void setB(double B) {
        this.B = B;
    }

    public void setC(double C) {
        this.C = C;
    }
}

