/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.curve;

import georegression.struct.curve.PolynomialCurve_F32;
import org.ejml.FancyPrint;

public class PolynomialQuadratic1D_F32
implements PolynomialCurve_F32 {
    public float a;
    public float b;
    public float c;

    public PolynomialQuadratic1D_F32() {
    }

    public PolynomialQuadratic1D_F32(float a, float b, float c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public float evaluate(float t) {
        return this.a + this.b * t + this.c * t * t;
    }

    public PolynomialQuadratic1D_F32 setTo(float a, float b, float c) {
        this.a = a;
        this.b = b;
        this.c = c;
        return this;
    }

    public PolynomialQuadratic1D_F32 setTo(PolynomialQuadratic1D_F32 src) {
        this.a = src.a;
        this.b = src.b;
        this.c = src.c;
        return this;
    }

    public String toString() {
        FancyPrint fp = new FancyPrint();
        return "PolynomialQuadratic1D_F32{a=" + fp.p(this.a) + ", b=" + fp.p(this.b) + ", c=" + fp.p(this.c) + "}";
    }

    @Override
    public float get(int coefficient) {
        switch (coefficient) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
            case 2: {
                return this.c;
            }
        }
        throw new IllegalArgumentException("Coefficient out of range. " + coefficient);
    }

    @Override
    public void set(int coefficient, float value) {
        switch (coefficient) {
            case 0: {
                this.a = value;
                break;
            }
            case 1: {
                this.b = value;
                break;
            }
            case 2: {
                this.c = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Coefficient out of range. " + coefficient);
            }
        }
    }

    @Override
    public int size() {
        return 3;
    }

    @Override
    public int degree() {
        return 2;
    }

    @Override
    public void zero() {
        this.setTo(0.0f, 0.0f, 0.0f);
    }
}

