/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct;

import georegression.struct.GeoTuple;

public abstract class GeoTuple_F64<T extends GeoTuple_F64>
extends GeoTuple<T> {
    public boolean isIdentical(T t, double tol) {
        if (((GeoTuple)t).getDimension() != this.getDimension()) {
            return false;
        }
        int N = this.getDimension();
        for (int i = 0; i < N; ++i) {
            double diff = Math.abs(this.getIdx(i) - ((GeoTuple_F64)t).getIdx(i));
            if (!(diff > tol)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T copy() {
        return (T)((GeoTuple_F64)this.createNewInstance()).setTo(this);
    }

    public double norm() {
        return (float)Math.sqrt(this.normSq());
    }

    public double normSq() {
        double total = 0.0;
        int N = this.getDimension();
        for (int i = 0; i < N; ++i) {
            double a = this.getIdx(i);
            total += a * a;
        }
        return total;
    }

    public double distance(T t) {
        return Math.sqrt(this.distance2(t));
    }

    public double distance2(T t) {
        if (((GeoTuple)t).getDimension() != this.getDimension()) {
            throw new IllegalArgumentException("Dimension of input tuple does not match");
        }
        double total = 0.0;
        int N = this.getDimension();
        for (int i = 0; i < N; ++i) {
            double diff = Math.abs(this.getIdx(i) - ((GeoTuple_F64)t).getIdx(i));
            total += diff * diff;
        }
        return total;
    }

    public abstract double getIdx(int var1);

    public abstract void setIdx(int var1, double var2);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GeoTuple_F64)) {
            return false;
        }
        GeoTuple_F64 o = (GeoTuple_F64)obj;
        int N = this.getDimension();
        if (N != o.getDimension()) {
            return false;
        }
        for (int i = 0; i < N; ++i) {
            if (this.getIdx(i) == o.getIdx(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int N = this.getDimension();
        int hash = 0;
        for (int i = 0; i < N; ++i) {
            hash += Double.hashCode(this.getIdx(i));
        }
        return hash;
    }
}

