/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct;

import georegression.struct.GeoTuple_F32;
import java.text.DecimalFormat;
import java.util.Objects;
import org.ejml.UtilEjml;

public abstract class GeoTuple3D_F32<T extends GeoTuple3D_F32>
extends GeoTuple_F32<T> {
    public float x;
    public float y;
    public float z;

    protected GeoTuple3D_F32(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    protected GeoTuple3D_F32() {
    }

    @Override
    public int getDimension() {
        return 3;
    }

    protected void _setTo(GeoTuple3D_F32 a) {
        this.x = a.x;
        this.y = a.y;
        this.z = a.z;
    }

    public T setTo(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return (T)this;
    }

    @Override
    public void zero() {
        this.setTo(0.0f, 0.0f, 0.0f);
    }

    public boolean isIdentical(float x, float y, float z) {
        return this.x == x && this.y == y && this.z == z;
    }

    public boolean isIdentical(float x, float y, float z, float tol) {
        return Math.abs(this.x - x) <= tol && Math.abs(this.y - y) <= tol && Math.abs(this.z - z) <= tol;
    }

    @Override
    public boolean isIdentical(GeoTuple3D_F32 t, float tol) {
        return Math.abs(this.x - t.x) <= tol && Math.abs(this.y - t.y) <= tol && Math.abs(this.z - t.z) <= tol;
    }

    @Override
    public float getIdx(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException("Invalid index");
    }

    @Override
    public void setIdx(int index, float value) {
        switch (index) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid index");
            }
        }
    }

    public void plusIP(GeoTuple3D_F32 a) {
        this.x += a.x;
        this.y += a.y;
        this.z += a.z;
    }

    public T plus(GeoTuple3D_F32 a) {
        GeoTuple3D_F32 ret = (GeoTuple3D_F32)this.createNewInstance();
        ret.x = this.x + a.x;
        ret.y = this.y + a.y;
        ret.z = this.z + a.z;
        return (T)ret;
    }

    public void timesIP(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
    }

    public void scale(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
    }

    public void divideIP(float scalar) {
        this.x /= scalar;
        this.y /= scalar;
        this.z /= scalar;
    }

    public T times(float scalar) {
        GeoTuple3D_F32 ret = (GeoTuple3D_F32)this.createNewInstance();
        ret.x = this.x * scalar;
        ret.y = this.y * scalar;
        ret.z = this.z * scalar;
        return (T)ret;
    }

    @Override
    public float norm() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    @Override
    public float normSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float distance(float x, float y, float z) {
        float dx = x - this.x;
        float dy = y - this.y;
        float dz = z - this.z;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Override
    public T setTo(T src) {
        this.x = ((GeoTuple3D_F32)src).x;
        this.y = ((GeoTuple3D_F32)src).y;
        this.z = ((GeoTuple3D_F32)src).z;
        return (T)this;
    }

    @Override
    public float distance(GeoTuple3D_F32 t) {
        float dx = t.x - this.x;
        float dy = t.y - this.y;
        float dz = t.z - this.z;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Override
    public float distance2(GeoTuple3D_F32 t) {
        float dx = t.x - this.x;
        float dy = t.y - this.y;
        float dz = t.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public float distance2(float x, float y, float z) {
        float dx = x - this.x;
        float dy = y - this.y;
        float dz = z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public void print() {
        System.out.println(this);
    }

    public boolean isNaN() {
        return Float.isNaN(this.x) || Float.isNaN(this.y) || Float.isNaN(this.z);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoTuple3D_F32 o = (GeoTuple3D_F32)obj;
        return Float.compare(this.x, o.x) == 0 && Float.compare(this.y, o.y) == 0 && Float.compare(this.z, o.z) == 0;
    }

    public String toString(String name) {
        DecimalFormat format = new DecimalFormat("#");
        String sx = UtilEjml.fancyString(this.x, format, 11, 4);
        String sy = UtilEjml.fancyString(this.y, format, 11, 4);
        String sz = UtilEjml.fancyString(this.z, format, 11, 4);
        return name + "( " + sx + " , " + sy + " , " + sz + " )";
    }

    @Override
    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }
}

