/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct;

import georegression.struct.GeoTuple_F64;
import java.text.DecimalFormat;
import java.util.Objects;
import org.ejml.UtilEjml;

public abstract class GeoTuple2D_F64<T extends GeoTuple2D_F64>
extends GeoTuple_F64<T> {
    public double x;
    public double y;

    protected GeoTuple2D_F64(double x, double y) {
        this.x = x;
        this.y = y;
    }

    protected GeoTuple2D_F64() {
    }

    protected void _setTo(GeoTuple2D_F64 a) {
        this.x = a.x;
        this.y = a.y;
    }

    public T setTo(double x, double y) {
        this.x = x;
        this.y = y;
        return (T)this;
    }

    @Override
    public void zero() {
        this.setTo(0.0, 0.0);
    }

    @Override
    public boolean isIdentical(double x, double y) {
        return this.x == x && this.y == y;
    }

    public boolean isIdentical(double x, double y, double tol) {
        return Math.abs(this.x - x) <= tol && Math.abs(this.y - y) <= tol;
    }

    @Override
    public boolean isIdentical(T t, double tol) {
        return Math.abs(this.x - ((GeoTuple2D_F64)t).x) <= tol && Math.abs(this.y - ((GeoTuple2D_F64)t).y) <= tol;
    }

    public void plusIP(GeoTuple2D_F64 a) {
        this.x += a.x;
        this.y += a.y;
    }

    public T plus(GeoTuple2D_F64 a) {
        GeoTuple2D_F64 ret = (GeoTuple2D_F64)this.createNewInstance();
        ret.x = this.x + a.x;
        ret.y = this.y + a.y;
        return (T)ret;
    }

    public void timesIP(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
    }

    public void scale(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
    }

    public T times(double scalar) {
        GeoTuple2D_F64 ret = (GeoTuple2D_F64)this.createNewInstance();
        ret.x = this.x * scalar;
        ret.y = this.y * scalar;
        return (T)ret;
    }

    public double distance(double x, double y) {
        double dx = x - this.x;
        double dy = y - this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance2(double x, double y) {
        double dx = x - this.x;
        double dy = y - this.y;
        return dx * dx + dy * dy;
    }

    @Override
    public T setTo(T src) {
        this.x = ((GeoTuple2D_F64)src).x;
        this.y = ((GeoTuple2D_F64)src).y;
        return (T)this;
    }

    @Override
    public double distance(T t) {
        double dx = ((GeoTuple2D_F64)t).x - this.x;
        double dy = ((GeoTuple2D_F64)t).y - this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public double distance2(T t) {
        double dx = ((GeoTuple2D_F64)t).x - this.x;
        double dy = ((GeoTuple2D_F64)t).y - this.y;
        return dx * dx + dy * dy;
    }

    @Override
    public double getIdx(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IllegalArgumentException("Invalid index");
    }

    @Override
    public void setIdx(int index, double value) {
        switch (index) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid index");
            }
        }
    }

    @Override
    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    @Override
    public double normSq() {
        return this.x * this.x + this.y * this.y;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    public void print() {
        System.out.println(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoTuple2D_F64 o = (GeoTuple2D_F64)obj;
        return Double.compare(this.x, o.x) == 0 && Double.compare(this.y, o.y) == 0;
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y);
    }

    protected String toString(String name) {
        DecimalFormat format = new DecimalFormat("#");
        String sx = UtilEjml.fancyString(this.x, format, 11, 4);
        String sy = UtilEjml.fancyString(this.y, format, 11, 4);
        return name + "( " + sx + " " + sy + " )";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }
}

