/*
 * Decompiled with CFR 0.152.
 */
package georegression.misc.test;

import georegression.geometry.UtilPoint2D_F64;
import georegression.struct.GeoTuple2D_F32;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple3D_F32;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.GeoTuple_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.se.Se2_F32;
import georegression.struct.se.Se2_F64;
import georegression.struct.se.Se3_F32;
import georegression.struct.se.Se3_F64;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.MatrixFeatures_FDRM;

public class GeometryUnitTest {
    public static void assertEquals(Se3_F64 expected, Se3_F64 found, double tolTran, double tolRotation) {
        GeometryUnitTest.assertEquals(expected.getTranslation(), found.getTranslation(), tolTran);
        GeometryUnitTest.assertTrue(MatrixFeatures_DDRM.isIdentical(expected.R, found.R, tolRotation), "rotation");
    }

    public static void assertEquals(Se3_F32 expected, Se3_F32 found, float tolTran, float tolRotation) {
        GeometryUnitTest.assertEquals(expected.getTranslation(), found.getTranslation(), tolTran);
        GeometryUnitTest.assertTrue(MatrixFeatures_FDRM.isIdentical(expected.R, found.R, tolRotation), "rotation");
    }

    public static void assertEquals(Se2_F64 expected, Se2_F64 found, double tolTran, double tolyaw) {
        GeometryUnitTest.assertEquals(expected.getTranslation(), found.getTranslation(), tolTran);
        GeometryUnitTest.assertEquals(expected.getYaw(), found.getYaw(), tolyaw, "yaw");
    }

    public static void assertEquals(Se2_F32 expected, Se2_F32 found, float tolTran, float tolyaw) {
        GeometryUnitTest.assertEquals(expected.getTranslation(), found.getTranslation(), tolTran);
        GeometryUnitTest.assertEquals((double)expected.getYaw(), (double)found.getYaw(), (double)tolyaw, "yaw");
    }

    public static void assertNotEquals(Se2_F64 expected, Se2_F64 found, double tolTran, double tolYaw) {
        if (!UtilPoint2D_F64.isEquals(expected.getTranslation(), found.getTranslation(), tolTran)) {
            return;
        }
        GeometryUnitTest.assertNotEquals(expected.getYaw(), found.getYaw(), tolYaw, "yaw");
    }

    public static void assertEquals(GeoTuple3D_F64 expected, GeoTuple3D_F64 found, double tol) {
        GeometryUnitTest.assertEquals(expected.getX(), found.getX(), tol, "x-axis is not equals.");
        GeometryUnitTest.assertEquals(expected.getY(), found.getY(), tol, "y-axis is not equals.");
        GeometryUnitTest.assertEquals(expected.getZ(), found.getZ(), tol, "z-axis is not equals.");
    }

    public static void assertEquals(GeoTuple3D_F32 expected, GeoTuple3D_F32 found, float tol) {
        GeometryUnitTest.assertEquals((double)expected.getX(), (double)found.getX(), (double)tol, "x-axis is not equals.");
        GeometryUnitTest.assertEquals((double)expected.getY(), (double)found.getY(), (double)tol, "y-axis is not equals.");
        GeometryUnitTest.assertEquals((double)expected.getZ(), (double)found.getZ(), (double)tol, "z-axis is not equals.");
    }

    public static void assertEquals(GeoTuple2D_F64 expected, GeoTuple2D_F64 found, double tol) {
        GeometryUnitTest.assertEquals(expected.getX(), found.getX(), tol, "x-axis is not equals.");
        GeometryUnitTest.assertEquals(expected.getY(), found.getY(), tol, "y-axis is not equals.");
    }

    public static void assertEquals(GeoTuple2D_F32 expected, GeoTuple2D_F32 found, float tol) {
        GeometryUnitTest.assertEquals((double)expected.getX(), (double)found.getX(), (double)tol, "x-axis is not equals.");
        GeometryUnitTest.assertEquals((double)expected.getY(), (double)found.getY(), (double)tol, "y-axis is not equals.");
    }

    public static void assertEquals(Point2D_I32 expected, Point2D_I32 found) {
        GeometryUnitTest.assertEquals(expected.getX(), found.getX(), "x-axis is not equal.");
        GeometryUnitTest.assertEquals(expected.getY(), found.getY(), "y-axis is not equal.");
    }

    public static void assertEquals(int x, int y, Point2D_I32 found) {
        GeometryUnitTest.assertEquals(x, found.getX(), "x-axis is not equal.");
        GeometryUnitTest.assertEquals(y, found.getY(), "y-axis is not equal.");
    }

    public static void assertEquals(float x, float y, Point2D_F32 found, float tol) {
        GeometryUnitTest.assertEquals((double)x, (double)found.getX(), (double)tol, "x-axis is not equal.");
        GeometryUnitTest.assertEquals((double)y, (double)found.getY(), (double)tol, "y-axis is not equal.");
    }

    public static void assertEquals(double x, double y, Point2D_F64 found, double tol) {
        GeometryUnitTest.assertEquals(x, found.getX(), tol, "x-axis is not equal.");
        GeometryUnitTest.assertEquals(y, found.getY(), tol, "y-axis is not equal.");
    }

    public static void assertNotEquals(GeoTuple2D_F64 expected, GeoTuple2D_F64 found, double tol) {
        GeometryUnitTest.assertNotEquals(expected.getX(), found.getX(), tol, "x-axis is equal.");
        GeometryUnitTest.assertNotEquals(expected.getY(), found.getY(), tol, "y-axis is equal.");
    }

    public static void assertEquals(GeoTuple3D_F64 a, double x, double y, double z, double tol) {
        GeometryUnitTest.assertEquals(a.getX(), x, tol, "x-axis is not equals.");
        GeometryUnitTest.assertEquals(a.getY(), y, tol, "y-axis is not equals.");
        GeometryUnitTest.assertEquals(a.getZ(), z, tol, "z-axis is not equals.");
    }

    public static void assertEquals(GeoTuple3D_F32 a, float x, float y, float z, float tol) {
        GeometryUnitTest.assertEquals((double)a.getX(), (double)x, (double)tol, "x-axis is not equals.");
        GeometryUnitTest.assertEquals((double)a.getY(), (double)y, (double)tol, "y-axis is not equals.");
        GeometryUnitTest.assertEquals((double)a.getZ(), (double)z, (double)tol, "z-axis is not equals.");
    }

    public static void assertNotEquals(GeoTuple3D_F32 expected, GeoTuple3D_F32 found, float tol) {
        if (Math.abs(expected.getX() - found.getX()) <= tol && Math.abs(expected.getY() - found.getY()) <= tol && Math.abs(expected.getZ() - found.getZ()) <= tol) {
            throw new RuntimeException("Points are equal to each other!");
        }
    }

    public static void assertNotEquals(GeoTuple3D_F64 expected, GeoTuple3D_F64 found, double tol) {
        if (Math.abs(expected.getX() - found.getX()) <= tol && Math.abs(expected.getY() - found.getY()) <= tol && Math.abs(expected.getZ() - found.getZ()) <= tol) {
            throw new RuntimeException("Points are equal to each other!");
        }
    }

    public static void assertEquals(GeoTuple_F64 a, GeoTuple_F64 b, double tol) {
        GeometryUnitTest.assertTrue(a.getClass() == b.getClass(), "a and b are not the same type.");
        int N = a.getDimension();
        for (int i = 0; i < N; ++i) {
            GeometryUnitTest.assertEquals(a.getIdx(i), b.getIdx(i), tol, "Index " + i + " is not the same.");
        }
    }

    public static void assertEquals(int valueA, int valueB, String message) {
        if (valueA != valueB) {
            throw new RuntimeException(message + " " + valueA + "  " + valueB);
        }
    }

    public static void assertEquals(double valueA, double valueB, double tol, String message) {
        if (Math.abs(valueA - valueB) > tol) {
            throw new RuntimeException(message + " " + valueA + "  " + valueB);
        }
    }

    public static void assertNotEquals(double valueA, double valueB, double tol, String message) {
        if (Math.abs(valueA - valueB) <= tol) {
            throw new RuntimeException(message + " " + valueA + "  " + valueB);
        }
    }

    public static void assertTrue(boolean value, String message) {
        if (!value) {
            throw new RuntimeException(message);
        }
    }
}

