/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry.curves;

import georegression.geometry.UtilEllipse_F32;
import georegression.geometry.UtilLine2D_F32;
import georegression.metric.Intersection2D_F32;
import georegression.struct.curve.EllipseRotated_F32;
import georegression.struct.line.LineGeneral2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import georegression.struct.point.Point2D_F32;

public class TangentLinesTwoEllipses_F32 {
    private float convergenceTol;
    private int maxIterations = 10;
    private Point2D_F32 temp0 = new Point2D_F32();
    private Point2D_F32 temp1 = new Point2D_F32();
    float sumDifference;
    private boolean converged;
    LineSegment2D_F32 centerLine = new LineSegment2D_F32();
    LineSegment2D_F32 tempLine = new LineSegment2D_F32();
    LineGeneral2D_F32 lineGeneral = new LineGeneral2D_F32();
    Point2D_F32 junk = new Point2D_F32();

    public TangentLinesTwoEllipses_F32(float convergenceTol, int maxIterations) {
        this.convergenceTol = convergenceTol;
        this.maxIterations = maxIterations;
    }

    public boolean process(EllipseRotated_F32 ellipseA, EllipseRotated_F32 ellipseB, Point2D_F32 tangentA0, Point2D_F32 tangentA1, Point2D_F32 tangentA2, Point2D_F32 tangentA3, Point2D_F32 tangentB0, Point2D_F32 tangentB1, Point2D_F32 tangentB2, Point2D_F32 tangentB3) {
        int iteration;
        this.converged = false;
        if (!this.initialize(ellipseA, ellipseB, tangentA0, tangentA1, tangentA2, tangentA3, tangentB0, tangentB1, tangentB2, tangentB3)) {
            return false;
        }
        for (iteration = 0; iteration < this.maxIterations; ++iteration) {
            boolean allGood = false;
            this.sumDifference = 0.0f;
            if (!this.selectTangent(tangentA0, tangentB0, ellipseB, tangentB0, false)) {
                return false;
            }
            if (!this.selectTangent(tangentA1, tangentB1, ellipseB, tangentB1, true)) {
                return false;
            }
            if (!this.selectTangent(tangentA2, tangentB2, ellipseB, tangentB2, true)) {
                return false;
            }
            if (!this.selectTangent(tangentA3, tangentB3, ellipseB, tangentB3, false)) {
                return false;
            }
            if ((float)Math.sqrt(this.sumDifference) / 4.0f <= this.convergenceTol) {
                allGood = true;
            }
            this.sumDifference = 0.0f;
            if (!this.selectTangent(tangentB0, tangentA0, ellipseA, tangentA0, false)) {
                return false;
            }
            if (!this.selectTangent(tangentB1, tangentA1, ellipseA, tangentA1, true)) {
                return false;
            }
            if (!this.selectTangent(tangentB2, tangentA2, ellipseA, tangentA2, true)) {
                return false;
            }
            if (!this.selectTangent(tangentB3, tangentA3, ellipseA, tangentA3, false)) {
                return false;
            }
            if (allGood && (float)Math.sqrt(this.sumDifference) / 4.0f <= this.convergenceTol) break;
        }
        this.converged = iteration < this.maxIterations;
        return true;
    }

    boolean initialize(EllipseRotated_F32 ellipseA, EllipseRotated_F32 ellipseB, Point2D_F32 tangentA0, Point2D_F32 tangentA1, Point2D_F32 tangentA2, Point2D_F32 tangentA3, Point2D_F32 tangentB0, Point2D_F32 tangentB1, Point2D_F32 tangentB2, Point2D_F32 tangentB3) {
        this.centerLine.setTo(ellipseA.center, ellipseB.center);
        UtilLine2D_F32.convert(this.centerLine, this.lineGeneral);
        Intersection2D_F32.intersection(this.lineGeneral, ellipseA, this.temp0, this.temp1, -1.0f);
        if (this.temp0.distance2(ellipseB.center) < this.temp1.distance2(ellipseB.center)) {
            tangentA0.setTo(this.temp0);
        } else {
            tangentA0.setTo(this.temp1);
        }
        if (!UtilEllipse_F32.tangentLines(tangentA0, ellipseB, tangentB0, tangentB1)) {
            return false;
        }
        if (!this.selectTangent(tangentB0, tangentA0, ellipseA, tangentA0, false)) {
            return false;
        }
        if (!this.selectTangent(tangentB0, tangentA0, ellipseA, tangentA1, true)) {
            return false;
        }
        if (!this.selectTangent(tangentB1, tangentA0, ellipseA, tangentA2, true)) {
            return false;
        }
        return this.selectTangent(tangentB1, tangentA0, ellipseA, tangentA3, false);
    }

    boolean selectTangent(Point2D_F32 a, Point2D_F32 previousTangent, EllipseRotated_F32 ellipse, Point2D_F32 tangent, boolean cross) {
        boolean crossed1;
        if (!UtilEllipse_F32.tangentLines(a, ellipse, this.temp0, this.temp1)) {
            return false;
        }
        this.tempLine.a = a;
        this.tempLine.b = this.temp0;
        boolean crossed0 = Intersection2D_F32.intersection(this.centerLine, this.tempLine, this.junk) != null;
        this.tempLine.b = this.temp1;
        boolean bl = crossed1 = Intersection2D_F32.intersection(this.centerLine, this.tempLine, this.junk) != null;
        if (crossed0 == crossed1) {
            throw new RuntimeException("Well this didn't work");
        }
        if (cross == crossed0) {
            this.sumDifference += previousTangent.distance2(this.temp0);
            tangent.setTo(this.temp0);
        } else {
            this.sumDifference += previousTangent.distance2(this.temp1);
            tangent.setTo(this.temp1);
        }
        return true;
    }

    public boolean isConverged() {
        return this.converged;
    }

    public float getConvergenceTol() {
        return this.convergenceTol;
    }

    public void setConvergenceTol(float convergenceTol) {
        this.convergenceTol = convergenceTol;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }
}

