/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.geometry.PolygonInfo;
import georegression.geometry.UtilVector2D_F64;
import georegression.geometry.polygon.ThreeIndexes;
import georegression.geometry.polygon.TriangulateSimpleRemoveEars_F64;
import georegression.metric.Distance2D_F64;
import georegression.metric.Intersection2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.struct.shapes.Quadrilateral_F64;
import georegression.struct.shapes.Rectangle2D_F64;
import georegression.struct.shapes.RectangleLength2D_I32;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.jetbrains.annotations.Nullable;

public class UtilPolygons2D_F64 {
    public static boolean isConvex(Polygon2D_F64 poly) {
        int N = poly.size();
        int numPositive = 0;
        for (int i = 0; i < N; ++i) {
            int j = (i + 1) % N;
            int k = (i + 2) % N;
            Point2D_F64 a = ((Point2D_F64[])poly.vertexes.data)[i];
            Point2D_F64 b = ((Point2D_F64[])poly.vertexes.data)[j];
            Point2D_F64 c = ((Point2D_F64[])poly.vertexes.data)[k];
            double dx0 = a.x - b.x;
            double dy1 = c.y - b.y;
            double dy0 = a.y - b.y;
            double dx1 = c.x - b.x;
            double z = dx0 * dy1 - dy0 * dx1;
            if (!(z > 0.0)) continue;
            ++numPositive;
        }
        return numPositive == 0 || numPositive == N;
    }

    public static PolygonInfo isSimple(Polygon2D_F64 p, @Nullable PolygonInfo result, double tol) {
        if (result == null) {
            result = new PolygonInfo();
        }
        result.reset();
        if (p.size() < 3) {
            result.type = PolygonInfo.Type.COMPLEX;
            return result;
        }
        int N = p.size();
        int wind = 0;
        boolean concave = false;
        double crsp = 0.0;
        double p0 = p.get((int)(N - 1)).x - p.get((int)(N - 2)).x;
        double p1 = p.get((int)(N - 1)).y - p.get((int)(N - 2)).y;
        int i = 0;
        int ii = N - 1;
        while (i < N) {
            Point2D_F64 pa = p.get(ii);
            Point2D_F64 pb = p.get(i);
            double d1 = pb.y - pa.y;
            double d0 = pb.x - pa.x;
            double crs = p0 * d1 - p1 * d0;
            if (crs * crsp < 0.0) {
                concave = true;
            }
            if (p1 <= 0.0) {
                if (d1 > 0.0 && crs > 0.0) {
                    ++wind;
                }
            } else if (d1 <= 0.0 && crs < 0.0) {
                --wind;
            }
            p0 = d0;
            p1 = d1;
            if (crs != 0.0) {
                crsp = crs;
            }
            ii = i++;
        }
        if (Math.abs(wind) != 1) {
            result.type = PolygonInfo.Type.COMPLEX;
        } else if (!concave) {
            result.type = PolygonInfo.Type.CONVEX;
            result.ccw = wind > 0;
        } else if (UtilPolygons2D_F64.isSelfIntersectingBrute(p, tol)) {
            result.type = PolygonInfo.Type.COMPLEX;
        } else {
            result.ccw = wind > 0;
            result.type = PolygonInfo.Type.SIMPLE_CONCAVE;
        }
        return result;
    }

    public static boolean isSelfIntersectingBrute(Polygon2D_F64 p, double tol) {
        int N = p.size();
        int i = 0;
        int j = N - 1;
        while (i < N) {
            Point2D_F64 a = p.get(j);
            Point2D_F64 b = p.get(i);
            int ii = i + 1;
            int jj = i;
            while (ii < N) {
                Point2D_F64 bb;
                Point2D_F64 aa = p.get(jj);
                if (Intersection2D_F64.intersects2(a, b, aa, bb = p.get(ii), tol)) {
                    return true;
                }
                jj = ii++;
            }
            j = i++;
        }
        return false;
    }

    public static void triangulate(Polygon2D_F64 p, DogArray<ThreeIndexes> triangles) {
        TriangulateSimpleRemoveEars_F64 alg = new TriangulateSimpleRemoveEars_F64();
        alg.process(p, triangles);
    }

    public static void convert(Rectangle2D_F64 input, Quadrilateral_F64 output) {
        output.a.x = input.p0.x;
        output.a.y = input.p0.y;
        output.b.x = input.p1.x;
        output.b.y = input.p0.y;
        output.c.x = input.p1.x;
        output.c.y = input.p1.y;
        output.d.x = input.p0.x;
        output.d.y = input.p1.y;
    }

    public static void convert(Rectangle2D_F64 input, Polygon2D_F64 output) {
        if (output.size() != 4) {
            throw new IllegalArgumentException("polygon of order 4 expected");
        }
        output.get(0).setTo(input.p0.x, input.p0.y);
        output.get(1).setTo(input.p1.x, input.p0.y);
        output.get(2).setTo(input.p1.x, input.p1.y);
        output.get(3).setTo(input.p0.x, input.p1.y);
    }

    public static void convert(Quadrilateral_F64 input, Polygon2D_F64 output) {
        if (output.size() != 4) {
            throw new IllegalArgumentException("polygon of order 4 expected");
        }
        output.get(0).setTo(input.a);
        output.get(1).setTo(input.b);
        output.get(2).setTo(input.c);
        output.get(3).setTo(input.d);
    }

    public static void convert(Polygon2D_F64 input, Quadrilateral_F64 output) {
        if (input.size() != 4) {
            throw new IllegalArgumentException("Expected 4-sided polygon as input");
        }
        output.a.setTo(input.get(0));
        output.b.setTo(input.get(1));
        output.c.setTo(input.get(2));
        output.d.setTo(input.get(3));
    }

    public static void convert(RectangleLength2D_I32 input, Quadrilateral_F64 output) {
        output.a.x = input.x0;
        output.a.y = input.y0;
        output.b.x = input.x0 + input.width - 1;
        output.b.y = input.y0;
        output.c.x = input.x0 + input.width - 1;
        output.c.y = input.y0 + input.height - 1;
        output.d.x = input.x0;
        output.d.y = input.y0 + input.height - 1;
    }

    public static void bounding(Quadrilateral_F64 quad, Rectangle2D_F64 rectangle) {
        rectangle.p0.x = Math.min(quad.a.x, quad.b.x);
        rectangle.p0.x = Math.min(rectangle.p0.x, quad.c.x);
        rectangle.p0.x = Math.min(rectangle.p0.x, quad.d.x);
        rectangle.p0.y = Math.min(quad.a.y, quad.b.y);
        rectangle.p0.y = Math.min(rectangle.p0.y, quad.c.y);
        rectangle.p0.y = Math.min(rectangle.p0.y, quad.d.y);
        rectangle.p1.x = Math.max(quad.a.x, quad.b.x);
        rectangle.p1.x = Math.max(rectangle.p1.x, quad.c.x);
        rectangle.p1.x = Math.max(rectangle.p1.x, quad.d.x);
        rectangle.p1.y = Math.max(quad.a.y, quad.b.y);
        rectangle.p1.y = Math.max(rectangle.p1.y, quad.c.y);
        rectangle.p1.y = Math.max(rectangle.p1.y, quad.d.y);
    }

    public static void bounding(Polygon2D_F64 polygon, Rectangle2D_F64 rectangle) {
        rectangle.p0.setTo(polygon.get(0));
        rectangle.p1.setTo(polygon.get(0));
        for (int i = 0; i < polygon.size(); ++i) {
            Point2D_F64 p = polygon.get(i);
            if (p.x < rectangle.p0.x) {
                rectangle.p0.x = p.x;
            } else if (p.x > rectangle.p1.x) {
                rectangle.p1.x = p.x;
            }
            if (p.y < rectangle.p0.y) {
                rectangle.p0.y = p.y;
                continue;
            }
            if (!(p.y > rectangle.p1.y)) continue;
            rectangle.p1.y = p.y;
        }
    }

    public static Point2D_F64 center(Quadrilateral_F64 quad, @Nullable Point2D_F64 center) {
        if (center == null) {
            center = new Point2D_F64();
        }
        center.x = quad.a.x + quad.b.x + quad.c.x + quad.d.x;
        center.y = quad.a.y + quad.b.y + quad.c.y + quad.d.y;
        center.x /= 4.0;
        center.y /= 4.0;
        return center;
    }

    public static boolean isCCW(List<Point2D_F64> polygon) {
        int N = polygon.size();
        int sign = 0;
        for (int i = 0; i < N; ++i) {
            int j = (i + 1) % N;
            int k = (i + 2) % N;
            Point2D_F64 a = polygon.get(i);
            Point2D_F64 b = polygon.get(j);
            Point2D_F64 c = polygon.get(k);
            double dx0 = a.x - b.x;
            double dy1 = c.y - b.y;
            double dy0 = a.y - b.y;
            double dx1 = c.x - b.x;
            double z = dx0 * dy1 - dy0 * dx1;
            if (z > 0.0) {
                ++sign;
                continue;
            }
            --sign;
        }
        return sign < 0;
    }

    public static boolean isCCW(Polygon2D_F64 polygon) {
        return UtilPolygons2D_F64.isCCW(polygon.vertexes.toList());
    }

    public static void vertexAverage(Polygon2D_F64 input, Point2D_F64 average) {
        average.zero();
        for (int i = 0; i < input.size(); ++i) {
            Point2D_F64 v = ((Point2D_F64[])input.vertexes.data)[i];
            average.x += v.x;
            average.y += v.y;
        }
        average.x /= (double)input.size();
        average.y /= (double)input.size();
    }

    public static boolean isIdentical(Polygon2D_F64 a, Polygon2D_F64 b, double tol) {
        if (a.size() != b.size()) {
            return false;
        }
        double tol2 = tol * tol;
        for (int i = 0; i < a.size(); ++i) {
            if (!(a.get(i).distance2(b.get(i)) > tol2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEquivalent(Polygon2D_F64 a, Polygon2D_F64 b, double tol) {
        int i;
        if (a.size() != b.size()) {
            return false;
        }
        double tol2 = tol * tol;
        Point2D_F64 a0 = a.get(0);
        int match = -1;
        for (i = 0; i < b.size(); ++i) {
            if (!(a0.distance2(b.get(i)) <= tol2)) continue;
            match = i;
            break;
        }
        if (match < 0) {
            return false;
        }
        for (i = 1; i < b.size(); ++i) {
            Point2D_F64 bi;
            Point2D_F64 ai = a.get(i);
            if (!(ai.distance2(bi = b.get((match + i) % b.size())) > tol2)) continue;
            return false;
        }
        return true;
    }

    public static void flip(Polygon2D_F64 a) {
        int N = a.size();
        int H = N / 2;
        for (int i = 1; i <= H; ++i) {
            int j = N - i;
            Point2D_F64 tmp = ((Point2D_F64[])a.vertexes.data)[i];
            ((Point2D_F64[])a.vertexes.data)[i] = ((Point2D_F64[])a.vertexes.data)[j];
            ((Point2D_F64[])a.vertexes.data)[j] = tmp;
        }
    }

    public static void shiftUp(Polygon2D_F64 a) {
        int N = a.size();
        Point2D_F64 first = a.get(0);
        for (int i = 0; i < N - 1; ++i) {
            ((Point2D_F64[])a.vertexes.data)[i] = ((Point2D_F64[])a.vertexes.data)[i + 1];
        }
        ((Point2D_F64[])a.vertexes.data)[N - 1] = first;
    }

    public static void shiftDown(Polygon2D_F64 a) {
        int N = a.size();
        Point2D_F64 last = a.get(N - 1);
        for (int i = N - 1; i > 0; --i) {
            ((Point2D_F64[])a.vertexes.data)[i] = ((Point2D_F64[])a.vertexes.data)[i - 1];
        }
        ((Point2D_F64[])a.vertexes.data)[0] = last;
    }

    public static void removeAlmostParallel(Polygon2D_F64 polygon, double tol) {
        int i = 0;
        while (i < polygon.vertexes.size()) {
            int j = (i + 1) % polygon.vertexes.size();
            int k = (i + 2) % polygon.vertexes.size();
            Point2D_F64 p0 = (Point2D_F64)polygon.vertexes.get(i);
            Point2D_F64 p1 = (Point2D_F64)polygon.vertexes.get(j);
            Point2D_F64 p2 = (Point2D_F64)polygon.vertexes.get(k);
            double angle = UtilVector2D_F64.acute(p1.x - p0.x, p1.y - p0.y, p2.x - p1.x, p2.y - p1.y);
            if (angle <= tol) {
                polygon.vertexes.remove(j);
                if (j >= i) continue;
                i = polygon.vertexes.size() - 1;
                continue;
            }
            ++i;
        }
    }

    public static void removeAdjacentDuplicates(Polygon2D_F64 polygon, double tol) {
        int i = polygon.vertexes.size() - 1;
        int j = 0;
        while (i >= 0 && polygon.size() > 1) {
            if (polygon.get(i).isIdentical(polygon.get(j), tol)) {
                polygon.vertexes.remove(i);
            }
            j = i--;
        }
    }

    public static boolean hasAdjacentDuplicates(Polygon2D_F64 polygon, double tol) {
        int i = polygon.vertexes.size() - 1;
        int j = 0;
        while (i >= 0 && polygon.size() > 1) {
            if (polygon.get(i).isIdentical(polygon.get(j), tol)) {
                return true;
            }
            j = i--;
        }
        return false;
    }

    public static double averageOfClosestPointError(Polygon2D_F64 model, Polygon2D_F64 target, int numberOfSamples) {
        LineSegment2D_F64 line = new LineSegment2D_F64();
        double[] cornerLocationsB = new double[target.size() + 1];
        double totalLength = 0.0;
        for (int i = 0; i < target.size(); ++i) {
            Point2D_F64 b0 = target.get(i % target.size());
            Point2D_F64 b1 = target.get((i + 1) % target.size());
            cornerLocationsB[i] = totalLength;
            totalLength += b0.distance(b1);
        }
        cornerLocationsB[target.size()] = totalLength;
        Point2D_F64 pointOnB = new Point2D_F64();
        double error = 0.0;
        int cornerB = 0;
        for (int k = 0; k < numberOfSamples; ++k) {
            double location = totalLength * (double)k / (double)numberOfSamples;
            while (location > cornerLocationsB[cornerB + 1]) {
                ++cornerB;
            }
            Point2D_F64 b0 = target.get(cornerB);
            Point2D_F64 b1 = target.get((cornerB + 1) % target.size());
            double locationCornerB = cornerLocationsB[cornerB];
            double fraction = (location - locationCornerB) / (cornerLocationsB[cornerB + 1] - locationCornerB);
            pointOnB.x = (b1.x - b0.x) * fraction + b0.x;
            pointOnB.y = (b1.y - b0.y) * fraction + b0.y;
            double best = Double.MAX_VALUE;
            for (int i = 0; i < model.size() + 1; ++i) {
                line.a = model.get(i % model.size());
                line.b = model.get((i + 1) % model.size());
                double d = Distance2D_F64.distance(line, pointOnB);
                if (!(d < best)) continue;
                best = d;
            }
            error += best;
        }
        return error / (double)numberOfSamples;
    }
}

