/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.GeoTuple2D_F32;
import georegression.struct.GeoTuple3D_F32;
import georegression.struct.GeoTuple4D_F32;
import org.ejml.data.FMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class GeometryMath_F32 {
    public static FMatrixRMaj crossMatrix(float x0, float x1, float x2, @Nullable FMatrixRMaj ret) {
        if (ret == null) {
            ret = new FMatrixRMaj(3, 3);
        } else {
            ret.zero();
        }
        ret.set(0, 1, -x2);
        ret.set(0, 2, x1);
        ret.set(1, 0, x2);
        ret.set(1, 2, -x0);
        ret.set(2, 0, -x1);
        ret.set(2, 1, x0);
        return ret;
    }

    public static FMatrixRMaj crossMatrix(GeoTuple3D_F32 v, @Nullable FMatrixRMaj ret) {
        if (ret == null) {
            ret = new FMatrixRMaj(3, 3);
        } else {
            ret.zero();
        }
        float x = v.getX();
        float y = v.getY();
        float z = v.getZ();
        ret.set(0, 1, -z);
        ret.set(0, 2, y);
        ret.set(1, 0, z);
        ret.set(1, 2, -x);
        ret.set(2, 0, -y);
        ret.set(2, 1, x);
        return ret;
    }

    public static void cross(GeoTuple3D_F32 a, GeoTuple3D_F32 b, GeoTuple3D_F32 c) {
        c.x = a.y * b.z - a.z * b.y;
        c.y = a.z * b.x - a.x * b.z;
        c.z = a.x * b.y - a.y * b.x;
    }

    public static void cross(float a_x, float a_y, float a_z, float b_x, float b_y, float b_z, GeoTuple3D_F32 c) {
        c.x = a_y * b_z - a_z * b_y;
        c.y = a_z * b_x - a_x * b_z;
        c.z = a_x * b_y - a_y * b_x;
    }

    public static void cross(GeoTuple2D_F32 a, GeoTuple3D_F32 b, GeoTuple3D_F32 c) {
        c.x = a.y * b.z - b.y;
        c.y = b.x - a.x * b.z;
        c.z = a.x * b.y - a.y * b.x;
    }

    public static void cross(GeoTuple2D_F32 a, GeoTuple2D_F32 b, GeoTuple3D_F32 c) {
        c.x = a.y * 1.0f - b.y;
        c.y = b.x - a.x;
        c.z = a.x * b.y - a.y * b.x;
    }

    public static void add(GeoTuple3D_F32 a, GeoTuple3D_F32 b, GeoTuple3D_F32 c) {
        c.x = a.x + b.x;
        c.y = a.y + b.y;
        c.z = a.z + b.z;
    }

    public static void add(float a0, GeoTuple3D_F32 pt0, float a1, GeoTuple3D_F32 pt1, GeoTuple3D_F32 pt2) {
        pt2.x = a0 * pt0.x + a1 * pt1.x;
        pt2.y = a0 * pt0.y + a1 * pt1.y;
        pt2.z = a0 * pt0.z + a1 * pt1.z;
    }

    public static <T extends GeoTuple3D_F32> T addMult(T p0, FMatrixRMaj M, T p1, @Nullable T result) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        if (result == null) {
            result = (GeoTuple3D_F32)p0.createNewInstance();
        }
        float x = p1.x;
        float y = p1.y;
        float z = p1.z;
        result.x = p0.x + (M.data[0] * x + M.data[1] * y + M.data[2] * z);
        result.y = p0.y + (M.data[3] * x + M.data[4] * y + M.data[5] * z);
        result.z = p0.z + (M.data[6] * x + M.data[7] * y + M.data[8] * z);
        return result;
    }

    public static <T extends GeoTuple3D_F32> T addMultTrans(T p0, FMatrixRMaj M, T p1, @Nullable T result) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        if (result == null) {
            result = (GeoTuple3D_F32)p0.createNewInstance();
        }
        float x = p1.x;
        float y = p1.y;
        float z = p1.z;
        result.x = p0.x + (M.data[0] * x + M.data[3] * y + M.data[6] * z);
        result.y = p0.y + (M.data[1] * x + M.data[4] * y + M.data[7] * z);
        result.z = p0.z + (M.data[2] * x + M.data[5] * y + M.data[8] * z);
        return result;
    }

    public static void sub(GeoTuple3D_F32 a, GeoTuple3D_F32 b, GeoTuple3D_F32 c) {
        c.x = a.x - b.x;
        c.y = a.y - b.y;
        c.z = a.z - b.z;
    }

    public static void rotate(float theta, GeoTuple2D_F32 pt, GeoTuple2D_F32 solution) {
        float c = (float)Math.cos(theta);
        float s = (float)Math.sin(theta);
        float x = pt.x;
        float y = pt.y;
        solution.x = c * x - s * y;
        solution.y = s * x + c * y;
    }

    public static void rotate(float c, float s, GeoTuple2D_F32 pt, GeoTuple2D_F32 solution) {
        float x = pt.x;
        float y = pt.y;
        solution.x = c * x - s * y;
        solution.y = s * x + c * y;
    }

    public static <T extends GeoTuple3D_F32> T mult(FMatrixRMaj M, T pt, @Nullable T result) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        if (result == null) {
            result = (GeoTuple3D_F32)pt.createNewInstance();
        }
        float x = pt.x;
        float y = pt.y;
        float z = pt.z;
        result.x = M.data[0] * x + M.data[1] * y + M.data[2] * z;
        result.y = M.data[3] * x + M.data[4] * y + M.data[5] * z;
        result.z = M.data[6] * x + M.data[7] * y + M.data[8] * z;
        return result;
    }

    public static <T extends GeoTuple3D_F32> T mult4(FMatrixRMaj M, T pt, @Nullable T result) {
        if (M.numRows != 4 || M.numCols != 4) {
            throw new IllegalArgumentException("Input matrix must be 4 by 4, not " + M.numRows + " " + M.numCols);
        }
        if (result == null) {
            result = (GeoTuple3D_F32)pt.createNewInstance();
        }
        float x = pt.x;
        float y = pt.y;
        float z = pt.z;
        result.x = M.data[0] * x + M.data[1] * y + M.data[2] * z + M.data[3];
        result.y = M.data[4] * x + M.data[5] * y + M.data[6] * z + M.data[7];
        result.z = M.data[8] * x + M.data[9] * y + M.data[10] * z + M.data[11];
        float w = M.data[12] * x + M.data[13] * y + M.data[14] * z + M.data[15];
        result.x /= w;
        result.y /= w;
        result.z /= w;
        return result;
    }

    public static <T extends GeoTuple2D_F32> T mult(FMatrixRMaj M, GeoTuple3D_F32 pt, T mod) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        float x = pt.x;
        float y = pt.y;
        float z = pt.z;
        mod.x = M.unsafe_get(0, 0) * x + M.unsafe_get(0, 1) * y + M.unsafe_get(0, 2) * z;
        mod.y = M.unsafe_get(1, 0) * x + M.unsafe_get(1, 1) * y + M.unsafe_get(1, 2) * z;
        z = M.unsafe_get(2, 0) * x + M.unsafe_get(2, 1) * y + M.unsafe_get(2, 2) * z;
        mod.x /= z;
        mod.y /= z;
        return mod;
    }

    public static void mult(FMatrixRMaj M, GeoTuple2D_F32 pt, GeoTuple3D_F32 mod) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        float x = pt.x;
        float y = pt.y;
        mod.x = M.unsafe_get(0, 0) * x + M.unsafe_get(0, 1) * y + M.unsafe_get(0, 2);
        mod.y = M.unsafe_get(1, 0) * x + M.unsafe_get(1, 1) * y + M.unsafe_get(1, 2);
        mod.z = M.unsafe_get(2, 0) * x + M.unsafe_get(2, 1) * y + M.unsafe_get(2, 2);
    }

    public static <T extends GeoTuple2D_F32> T mult(FMatrixRMaj M, T pt, @Nullable T mod) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        if (mod == null) {
            throw new IllegalArgumentException("Must provide an instance in mod");
        }
        float x = pt.x;
        float y = pt.y;
        float modz = M.unsafe_get(2, 0) * x + M.unsafe_get(2, 1) * y + M.unsafe_get(2, 2);
        mod.x = (M.unsafe_get(0, 0) * x + M.unsafe_get(0, 1) * y + M.unsafe_get(0, 2)) / modz;
        mod.y = (M.unsafe_get(1, 0) * x + M.unsafe_get(1, 1) * y + M.unsafe_get(1, 2)) / modz;
        return mod;
    }

    public static void mult(FMatrixRMaj P, GeoTuple4D_F32 X2, GeoTuple3D_F32 mod) {
        if (P.numCols != 4) {
            throw new IllegalArgumentException("Input matrix must have 4 columns not " + P.numCols);
        }
        mod.x = P.data[0] * X2.x + P.data[1] * X2.y + P.data[2] * X2.z + P.data[3] * X2.w;
        mod.y = P.data[4] * X2.x + P.data[5] * X2.y + P.data[6] * X2.z + P.data[7] * X2.w;
        mod.z = P.data[8] * X2.x + P.data[9] * X2.y + P.data[10] * X2.z + P.data[11] * X2.w;
        if (P.numRows == 4) {
            float w = P.data[12] * X2.x + P.data[13] * X2.y + P.data[14] * X2.z + P.data[15] * X2.w;
            mod.x /= w;
            mod.y /= w;
            mod.z /= w;
        } else if (P.numRows != 3) {
            throw new IllegalArgumentException("rows must be 3 or 4 and not " + P.numRows);
        }
    }

    public static void mult(FMatrixRMaj P, GeoTuple4D_F32 X2, GeoTuple4D_F32 mod) {
        if (P.numRows != 4 || P.numCols != 4) {
            throw new IllegalArgumentException("Input matrix must be 3 by 4 not " + P.numRows + " " + P.numCols);
        }
        mod.x = P.data[0] * X2.x + P.data[1] * X2.y + P.data[2] * X2.z + P.data[3] * X2.w;
        mod.y = P.data[4] * X2.x + P.data[5] * X2.y + P.data[6] * X2.z + P.data[7] * X2.w;
        mod.z = P.data[8] * X2.x + P.data[9] * X2.y + P.data[10] * X2.z + P.data[11] * X2.w;
        mod.w = P.data[12] * X2.x + P.data[13] * X2.y + P.data[14] * X2.z + P.data[15] * X2.w;
    }

    public static void mult(FMatrixRMaj P, GeoTuple4D_F32 X2, GeoTuple2D_F32 mod) {
        if (P.numRows != 3 || P.numCols != 4) {
            throw new IllegalArgumentException("Input matrix must be 3 by 4 not " + P.numRows + " " + P.numCols);
        }
        float x = P.data[0] * X2.x + P.data[1] * X2.y + P.data[2] * X2.z + P.data[3] * X2.w;
        float y = P.data[4] * X2.x + P.data[5] * X2.y + P.data[6] * X2.z + P.data[7] * X2.w;
        float z = P.data[8] * X2.x + P.data[9] * X2.y + P.data[10] * X2.z + P.data[11] * X2.w;
        mod.x = x / z;
        mod.y = y / z;
    }

    public static FMatrixRMaj multCrossA(GeoTuple2D_F32 A2, FMatrixRMaj M, @Nullable FMatrixRMaj result) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        if (result == null) {
            result = new FMatrixRMaj(3, 3);
        }
        float x = A2.x;
        float y = A2.y;
        float a11 = M.data[0];
        float a12 = M.data[1];
        float a13 = M.data[2];
        float a21 = M.data[3];
        float a22 = M.data[4];
        float a23 = M.data[5];
        float a31 = M.data[6];
        float a32 = M.data[7];
        float a33 = M.data[8];
        result.data[0] = -a21 + a31 * y;
        result.data[1] = -a22 + a32 * y;
        result.data[2] = -a23 + a33 * y;
        result.data[3] = a11 - a31 * x;
        result.data[4] = a12 - a32 * x;
        result.data[5] = a13 - a33 * x;
        result.data[6] = -a11 * y + a21 * x;
        result.data[7] = -a12 * y + a22 * x;
        result.data[8] = -a13 * y + a23 * x;
        return result;
    }

    public static FMatrixRMaj multCrossATransA(GeoTuple2D_F32 A2, FMatrixRMaj M, @Nullable FMatrixRMaj result) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        if (result == null) {
            result = new FMatrixRMaj(3, 3);
        }
        float x = A2.x;
        float y = A2.y;
        float a11 = M.data[0];
        float a12 = M.data[1];
        float a13 = M.data[2];
        float a21 = M.data[3];
        float a22 = M.data[4];
        float a23 = M.data[5];
        float a31 = M.data[6];
        float a32 = M.data[7];
        float a33 = M.data[8];
        result.data[0] = a21 - a31 * y;
        result.data[1] = a22 - a32 * y;
        result.data[2] = a23 - a33 * y;
        result.data[3] = -a11 + a31 * x;
        result.data[4] = -a12 + a32 * x;
        result.data[5] = -a13 + a33 * x;
        result.data[6] = a11 * y - a21 * x;
        result.data[7] = a12 * y - a22 * x;
        result.data[8] = a13 * y - a23 * x;
        return result;
    }

    public static FMatrixRMaj multCrossA(GeoTuple3D_F32 A2, FMatrixRMaj M, @Nullable FMatrixRMaj result) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        if (result == null) {
            result = new FMatrixRMaj(3, 3);
        }
        float x = A2.x;
        float y = A2.y;
        float z = A2.z;
        float a11 = M.data[0];
        float a12 = M.data[1];
        float a13 = M.data[2];
        float a21 = M.data[3];
        float a22 = M.data[4];
        float a23 = M.data[5];
        float a31 = M.data[6];
        float a32 = M.data[7];
        float a33 = M.data[8];
        result.data[0] = -a21 * z + a31 * y;
        result.data[1] = -a22 * z + a32 * y;
        result.data[2] = -a23 * z + a33 * y;
        result.data[3] = a11 * z - a31 * x;
        result.data[4] = a12 * z - a32 * x;
        result.data[5] = a13 * z - a33 * x;
        result.data[6] = -a11 * y + a21 * x;
        result.data[7] = -a12 * y + a22 * x;
        result.data[8] = -a13 * y + a23 * x;
        return result;
    }

    public static FMatrixRMaj multCrossATransA(GeoTuple3D_F32 A2, FMatrixRMaj M, @Nullable FMatrixRMaj result) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        if (result == null) {
            result = new FMatrixRMaj(3, 3);
        }
        float x = A2.x;
        float y = A2.y;
        float z = A2.z;
        float a11 = M.data[0];
        float a12 = M.data[1];
        float a13 = M.data[2];
        float a21 = M.data[3];
        float a22 = M.data[4];
        float a23 = M.data[5];
        float a31 = M.data[6];
        float a32 = M.data[7];
        float a33 = M.data[8];
        result.data[0] = a21 * z - a31 * y;
        result.data[1] = a22 * z - a32 * y;
        result.data[2] = a23 * z - a33 * y;
        result.data[3] = -a11 * z + a31 * x;
        result.data[4] = -a12 * z + a32 * x;
        result.data[5] = -a13 * z + a33 * x;
        result.data[6] = a11 * y - a21 * x;
        result.data[7] = a12 * y - a22 * x;
        result.data[8] = a13 * y - a23 * x;
        return result;
    }

    public static <T extends GeoTuple3D_F32> T multTran(FMatrixRMaj M, T pt, @Nullable T mod) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Rotation matrices are 3 by 3.");
        }
        if (mod == null) {
            mod = (GeoTuple3D_F32)pt.createNewInstance();
        }
        float x = pt.x;
        float y = pt.y;
        float z = pt.z;
        mod.x = M.unsafe_get(0, 0) * x + M.unsafe_get(1, 0) * y + M.unsafe_get(2, 0) * z;
        mod.y = M.unsafe_get(0, 1) * x + M.unsafe_get(1, 1) * y + M.unsafe_get(2, 1) * z;
        mod.z = M.unsafe_get(0, 2) * x + M.unsafe_get(1, 2) * y + M.unsafe_get(2, 2) * z;
        return mod;
    }

    public static <T extends GeoTuple3D_F32> T multTran(FMatrixRMaj M, GeoTuple2D_F32 pt, T mod) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Rotation matrices are 3 by 3.");
        }
        float x = pt.x;
        float y = pt.y;
        mod.x = M.unsafe_get(0, 0) * x + M.unsafe_get(1, 0) * y + M.unsafe_get(2, 0);
        mod.y = M.unsafe_get(0, 1) * x + M.unsafe_get(1, 1) * y + M.unsafe_get(2, 1);
        mod.z = M.unsafe_get(0, 2) * x + M.unsafe_get(1, 2) * y + M.unsafe_get(2, 2);
        return mod;
    }

    public static <T extends GeoTuple2D_F32> T multTran(FMatrixRMaj M, GeoTuple2D_F32 pt, T mod) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Rotation matrices are 3 by 3.");
        }
        float x = pt.x;
        float y = pt.y;
        float modZ = M.unsafe_get(0, 2) * x + M.unsafe_get(1, 2) * y + M.unsafe_get(2, 2);
        mod.x = (M.unsafe_get(0, 0) * x + M.unsafe_get(1, 0) * y + M.unsafe_get(2, 0)) / modZ;
        mod.y = (M.unsafe_get(0, 1) * x + M.unsafe_get(1, 1) * y + M.unsafe_get(2, 1)) / modZ;
        return mod;
    }

    public static float innerProd(GeoTuple3D_F32 a, FMatrixRMaj M, GeoTuple3D_F32 b) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("M must be 3 by 3.");
        }
        float am0 = a.x * M.data[0] + a.y * M.data[3] + a.z * M.data[6];
        float am1 = a.x * M.data[1] + a.y * M.data[4] + a.z * M.data[7];
        float am2 = a.x * M.data[2] + a.y * M.data[5] + a.z * M.data[8];
        return am0 * b.x + am1 * b.y + am2 * b.z;
    }

    public static float innerProdTranM(GeoTuple3D_F32 a, FMatrixRMaj M, GeoTuple3D_F32 b) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("M must be 3 by 3.");
        }
        float am0 = a.x * M.data[0] + a.y * M.data[1] + a.z * M.data[2];
        float am1 = a.x * M.data[3] + a.y * M.data[4] + a.z * M.data[5];
        float am2 = a.x * M.data[6] + a.y * M.data[7] + a.z * M.data[8];
        return am0 * b.x + am1 * b.y + am2 * b.z;
    }

    public static FMatrixRMaj outerProd(GeoTuple3D_F32 a, GeoTuple3D_F32 b, @Nullable FMatrixRMaj ret) {
        if (ret == null) {
            ret = new FMatrixRMaj(3, 3);
        }
        ret.data[0] = a.x * b.x;
        ret.data[1] = a.x * b.y;
        ret.data[2] = a.x * b.z;
        ret.data[3] = a.y * b.x;
        ret.data[4] = a.y * b.y;
        ret.data[5] = a.y * b.z;
        ret.data[6] = a.z * b.x;
        ret.data[7] = a.z * b.y;
        ret.data[8] = a.z * b.z;
        return ret;
    }

    public static FMatrixRMaj addOuterProd(FMatrixRMaj A2, float scalar, GeoTuple3D_F32 b, GeoTuple3D_F32 c, @Nullable FMatrixRMaj ret) {
        if (ret == null) {
            ret = new FMatrixRMaj(3, 3);
        }
        ret.data[0] = A2.data[0] + scalar * b.x * c.x;
        ret.data[1] = A2.data[1] + scalar * b.x * c.y;
        ret.data[2] = A2.data[2] + scalar * b.x * c.z;
        ret.data[3] = A2.data[3] + scalar * b.y * c.x;
        ret.data[4] = A2.data[4] + scalar * b.y * c.y;
        ret.data[5] = A2.data[5] + scalar * b.y * c.z;
        ret.data[6] = A2.data[6] + scalar * b.z * c.x;
        ret.data[7] = A2.data[7] + scalar * b.z * c.y;
        ret.data[8] = A2.data[8] + scalar * b.z * c.z;
        return ret;
    }

    public static float innerProd(GeoTuple2D_F32 a, FMatrixRMaj M, GeoTuple2D_F32 b) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("M must be 3 by 3.");
        }
        float am0 = a.x * M.data[0] + a.y * M.data[3] + M.data[6];
        float am1 = a.x * M.data[1] + a.y * M.data[4] + M.data[7];
        float am2 = a.x * M.data[2] + a.y * M.data[5] + M.data[8];
        return am0 * b.x + am1 * b.y + am2;
    }

    public static float dot(GeoTuple3D_F32 a, GeoTuple3D_F32 b) {
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    public static void scale(GeoTuple3D_F32 p, float v) {
        p.x *= v;
        p.y *= v;
        p.z *= v;
    }

    public static void divide(GeoTuple3D_F32 p, float v) {
        p.x /= v;
        p.y /= v;
        p.z /= v;
    }

    public static void changeSign(GeoTuple3D_F32 t) {
        t.x = -t.x;
        t.y = -t.y;
        t.z = -t.z;
    }

    public static FMatrixRMaj toMatrix(GeoTuple3D_F32 in, @Nullable FMatrixRMaj out) {
        if (out == null) {
            out = new FMatrixRMaj(3, 1);
        } else if (out.getNumElements() != 3) {
            throw new IllegalArgumentException("Vector with 3 elements expected");
        }
        out.data[0] = in.x;
        out.data[1] = in.y;
        out.data[2] = in.z;
        return out;
    }

    public static void toTuple3D(FMatrixRMaj in, GeoTuple3D_F32 out) {
        out.x = in.get(0);
        out.y = in.get(1);
        out.z = in.get(2);
    }
}

