/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.points;

import georegression.fitting.MotionTransformPoint;
import georegression.fitting.points.ClosestPointToModel;
import georegression.misc.StoppingCondition;
import georegression.struct.GeoTuple;
import georegression.struct.InvertibleTransform;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se2_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.List;

public class IterativeClosestPoint<SE extends InvertibleTransform, P extends GeoTuple> {
    private final StoppingCondition stop;
    private double foundError;
    private ClosestPointToModel<P> model;
    private final MotionTransformPoint<SE, P> motion;
    private final Distance<P> distance;
    private SE foundModelToPoints;
    private int totalMatched;

    public IterativeClosestPoint(StoppingCondition stop, MotionTransformPoint<SE, P> motion, Distance<P> distance) {
        this.stop = stop.copy();
        this.motion = motion;
        this.distance = distance;
        this.foundModelToPoints = motion.getTransformSrcToDst().createInstance();
    }

    public double getFoundError() {
        return this.foundError;
    }

    public SE getPointsToModel() {
        return this.foundModelToPoints;
    }

    public void setModel(ClosestPointToModel model) {
        this.model = model;
    }

    public boolean process(List<P> points) {
        this.foundModelToPoints.reset();
        if (points.isEmpty()) {
            return false;
        }
        int dof = ((GeoTuple)points.get(0)).getDimension();
        ArrayList<GeoTuple> modelPts = new ArrayList<GeoTuple>();
        ArrayList<GeoTuple> dstPts = new ArrayList<GeoTuple>();
        boolean first = true;
        this.stop.reset();
        this.totalMatched = 0;
        do {
            modelPts.clear();
            dstPts.clear();
            for (GeoTuple geoTuple : points) {
                GeoTuple match = this.model.findClosestPoint(geoTuple);
                if (match == null) continue;
                modelPts.add(geoTuple);
                dstPts.add(match);
            }
            this.totalMatched = points.size();
            if (!this.motion.process(modelPts, dstPts)) {
                return false;
            }
            if (dof == 2) {
                this.transform2D(points);
            } else if (dof == 3) {
                this.transform3D(points);
            } else {
                throw new RuntimeException("Unknown dimension");
            }
            if (first) {
                first = false;
                this.foundModelToPoints.setTo(this.motion.getTransformSrcToDst());
            } else {
                this.foundModelToPoints = this.motion.getTransformSrcToDst().concat(this.foundModelToPoints, null);
            }
            this.foundError = this.computeMeanSquaredError(modelPts, dstPts);
        } while (!this.stop.isFinished(this.foundError));
        return true;
    }

    private double computeMeanSquaredError(List<P> fromPts, List<P> toPts) {
        double error = 0.0;
        for (int i = 0; i < fromPts.size(); ++i) {
            GeoTuple a = (GeoTuple)fromPts.get(i);
            GeoTuple b = (GeoTuple)toPts.get(i);
            error += this.distance.distance(a, b);
        }
        return error /= (double)fromPts.size();
    }

    private void transform3D(List<Point3D_F64> points) {
        Se3_F64 m = (Se3_F64)this.motion.getTransformSrcToDst();
        for (Point3D_F64 p : points) {
            SePointOps_F64.transform(m, p, p);
        }
    }

    private void transform2D(List<Point2D_F64> points) {
        Se2_F64 m = (Se2_F64)this.motion.getTransformSrcToDst();
        for (Point2D_F64 p : points) {
            SePointOps_F64.transform(m, p, p);
        }
    }

    public int getTotalMatched() {
        return this.totalMatched;
    }

    public static interface Distance<P> {
        public double distance(P var1, P var2);
    }
}

