/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.cylinder;

import georegression.fitting.cylinder.CodecCylinder3D_F32;
import georegression.metric.MiscOps;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Vector3D_F32;
import georegression.struct.shapes.Cylinder3D_F32;
import java.util.List;
import java.util.Objects;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.jetbrains.annotations.Nullable;

public class CylinderToPointSignedDistance_F32
implements FunctionNtoM {
    private final Cylinder3D_F32 cylinder = new Cylinder3D_F32();
    @Nullable
    private List<Point3D_F32> points;
    private final CodecCylinder3D_F32 codec = new CodecCylinder3D_F32();

    public void setPoints(List<Point3D_F32> points) {
        this.points = points;
    }

    @Override
    public int getNumOfInputsN() {
        return 7;
    }

    @Override
    public int getNumOfOutputsM() {
        Objects.requireNonNull(this.points, "Call setPoints() first");
        return this.points.size();
    }

    @Override
    public void process(double[] input, double[] output) {
        Objects.requireNonNull(this.points, "Call setPoints() first");
        this.codec.decode(input, this.cylinder);
        Point3D_F32 cp = this.cylinder.line.p;
        Vector3D_F32 cs = this.cylinder.line.slope;
        float slopeDot = cs.dot(cs);
        float slopeNorm = (float)Math.sqrt(slopeDot);
        for (int i = 0; i < this.points.size(); ++i) {
            Point3D_F32 p = this.points.get(i);
            float x = cp.x - p.x;
            float y = cp.y - p.y;
            float z = cp.z - p.z;
            float cc = x * x + y * y + z * z;
            float b = MiscOps.dot(x, y, z, cs) / slopeNorm;
            float distance = cc - b * b;
            distance = distance < 0.0f ? 0.0f : (float)Math.sqrt(distance);
            output[i] = distance - this.cylinder.radius;
        }
    }
}

