/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tree;

import com.github.weisj.darklaf.ui.cell.DarkCellRendererToggleButton;
import com.github.weisj.darklaf.ui.tree.TreeRendererComponent;
import com.github.weisj.darklaf.ui.tree.TreeRendererSupport;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class DarkTreeCellRenderer
extends DefaultTreeCellRenderer
implements TreeRendererSupport {
    private final DarkCellRendererToggleButton<DarkCellRendererToggleButton.CellEditorCheckBox> checkBoxRenderer = new DarkCellRendererToggleButton<DarkCellRendererToggleButton.CellEditorCheckBox>(new DarkCellRendererToggleButton.CellEditorCheckBox(false));
    private final DarkCellRendererToggleButton<DarkCellRendererToggleButton.CellEditorRadioButton> radioRenderer = new DarkCellRendererToggleButton<DarkCellRendererToggleButton.CellEditorRadioButton>(new DarkCellRendererToggleButton.CellEditorRadioButton(false));
    private TreeRendererComponent rendererComponent = new TreeRendererComponent();

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object val = DarkTreeCellRenderer.unwrapBooleanIfPossible(value);
        if (val instanceof Boolean && DarkTreeCellRenderer.isBooleanRenderingEnabled(tree)) {
            super.getTreeCellRendererComponent(tree, val, sel, expanded, leaf, row, hasFocus);
            Component comp = this.getBooleanRenderer(tree).getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.rendererComponent.setComponentOrientation(tree.getComponentOrientation());
            comp.setComponentOrientation(tree.getComponentOrientation());
            comp.setFont(tree.getFont());
            this.rendererComponent.setRenderer(this);
            this.rendererComponent.setRenderComponent(comp);
            return this.rendererComponent;
        }
        Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (sel && !DarkUIUtil.hasFocus(tree) && !DarkUIUtil.hasFocus(comp)) {
            comp.setForeground(UIManager.getColor("Tree.selectionForegroundInactive"));
        }
        return comp;
    }

    public static Object unwrapBooleanIfPossible(Object value) {
        Object val = value;
        if (val instanceof DefaultMutableTreeNode) {
            val = ((DefaultMutableTreeNode)val).getUserObject();
        }
        if (!(val instanceof Boolean)) {
            String str = String.valueOf(val);
            if ("true".equals(str)) {
                val = true;
            }
            if ("false".equals(str)) {
                val = false;
            }
        }
        return val;
    }

    protected static boolean isBooleanRenderingEnabled(JTree tree) {
        return Boolean.TRUE.equals(tree.getClientProperty("JTree.renderBooleanAsCheckBox"));
    }

    protected DarkCellRendererToggleButton getBooleanRenderer(JTree table) {
        if ("radioButton".equals(table.getClientProperty("JTree.booleanRenderType"))) {
            return this.radioRenderer;
        }
        return this.checkBoxRenderer;
    }
}

