/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tooltip;

import com.github.weisj.darklaf.components.tooltip.ToolTipStyle;
import com.github.weisj.darklaf.ui.tooltip.DarkTooltipBorder;
import com.github.weisj.darklaf.ui.tooltip.ToolTipUtil;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.Animator;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.GraphicsContext;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Area;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.text.View;

public class DarkTooltipUI
extends BasicToolTipUI
implements PropertyChangeListener,
HierarchyListener {
    protected static final String KEY_PREFIX = "JToolTip.";
    public static final String KEY_STYLE = "JToolTip.style";
    public static final String KEY_INSETS = "JToolTip.insets";
    public static final String KEY_POINTER_LOCATION = "JToolTip.pointerLocation";
    public static final String KEY_POINTER_WIDTH = "JToolTip.pointerWidth";
    public static final String KEY_POINTER_HEIGHT = "JToolTip.pointerHeight";
    public static final String KEY_PLAIN_TOOLTIP = "JComponent.plainTooltip";
    public static final String VARIANT_PLAIN = "plain";
    public static final String VARIANT_BALLOON = "balloon";
    public static final String VARIANT_PLAIN_BALLOON = "plainBalloon";
    public static final String TIP_TEXT_PROPERTY = "tiptext";
    public static final String KEY_CONTEXT = "JToolTip.toolTipContext";
    static final float MAX_ALPHA = 1.0f;
    private Animator fadeAnimator;
    private float alpha = 0.0f;
    protected JToolTip toolTip;
    protected JRootPane lastRootPane;
    protected ToolTipStyle style;
    protected boolean isTipTextChanging;
    protected MouseListener exitListener = new MouseAdapter(){

        @Override
        public void mouseExited(MouseEvent e) {
            boolean inside = DarkTooltipUI.this.isInside(e);
            if (!inside) {
                ToolTipManager.sharedInstance().mouseExited(new MouseEvent(DarkTooltipUI.this.toolTip.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), Integer.MIN_VALUE, Integer.MIN_VALUE, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
            }
        }
    };
    protected MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            if (e.getButton() == 1) {
                return;
            }
            Point p = e.getPoint();
            JComponent c = DarkTooltipUI.this.toolTip.getComponent();
            if (p.x == ((Component)c).getWidth()) {
                --p.x;
            }
            if (p.y == ((Component)c).getHeight()) {
                --p.y;
            }
            p.x = Math.max(p.x, 0);
            p.y = Math.max(p.y, 0);
            ToolTipManager.sharedInstance().mouseEntered(new MouseEvent(c, e.getID(), e.getWhen(), e.getModifiersEx(), p.x, p.y, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            DarkTooltipUI.this.exitListener.mouseExited(e);
        }
    };
    protected PropertyChangeListener componentPropertyChaneListener = e -> {
        if (KEY_STYLE.equals(e.getPropertyName())) {
            this.updateStyle();
        }
    };
    private boolean added;

    public static ComponentUI createUI(JComponent c) {
        if (Boolean.TRUE.equals(c.getClientProperty(KEY_PLAIN_TOOLTIP))) {
            return BasicToolTipUI.createUI(c);
        }
        return new DarkTooltipUI();
    }

    protected boolean isInside(MouseEvent e) {
        Point screenPos = e.getPoint();
        SwingUtilities.convertPointToScreen(screenPos, e.getComponent());
        Point toolTipPoint = new Point(screenPos.x, screenPos.y);
        Point compPoint = new Point(screenPos.x, screenPos.y);
        SwingUtilities.convertPointFromScreen(toolTipPoint, this.toolTip);
        SwingUtilities.convertPointFromScreen(compPoint, this.toolTip.getComponent());
        return this.toolTip.getComponent().contains(compPoint) || this.contains(this.toolTip, toolTipPoint.x, toolTipPoint.y);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        Border b = c.getBorder();
        if (b instanceof DarkTooltipBorder) {
            Area insideArea = ((DarkTooltipBorder)b).getBackgroundArea(this.toolTip, this.toolTip.getWidth(), this.toolTip.getHeight());
            return insideArea.contains(x, y);
        }
        return super.contains(c, x, y);
    }

    @Override
    public void installUI(JComponent c) {
        this.toolTip = (JToolTip)c;
        super.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.toolTip = null;
    }

    @Override
    protected void installDefaults(JComponent c) {
        super.installDefaults(c);
        this.fadeAnimator = new FadeInAnimator();
        c.setOpaque(false);
        DarkTooltipBorder border = new DarkTooltipBorder();
        Alignment align = (Alignment)((Object)c.getClientProperty(KEY_POINTER_LOCATION));
        border.setPointerLocation(align == null ? Alignment.CENTER : align);
        this.toolTip.setBorder(border);
        this.updateStyle();
    }

    @Override
    protected void installListeners(JComponent c) {
        super.installListeners(c);
        c.addHierarchyListener(this);
        c.addPropertyChangeListener(this);
        c.addMouseListener(this.exitListener);
        JComponent comp = this.toolTip.getComponent();
        if (comp != null) {
            comp.addMouseListener(this.mouseListener);
        }
    }

    @Override
    protected void uninstallListeners(JComponent c) {
        super.uninstallListeners(c);
        c.removePropertyChangeListener(this);
        c.removeMouseListener(this.exitListener);
        c.removeHierarchyListener(this);
        JComponent comp = this.toolTip.getComponent();
        if (comp != null) {
            comp.removeMouseListener(this.mouseListener);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (((JToolTip)c).getTipText() == null) {
            return;
        }
        if (this.added) {
            this.added = false;
            this.alpha = 0.0f;
            this.fadeAnimator.reset();
            this.fadeAnimator.resume();
        }
        GraphicsContext config = new GraphicsContext(g);
        g.setColor(c.getBackground());
        if (c.getBorder() instanceof DarkTooltipBorder) {
            Area area = ((DarkTooltipBorder)c.getBorder()).getBackgroundArea(c, c.getWidth(), c.getHeight());
            ((Graphics2D)g).fill(area);
        }
        super.paint(g, c);
        config.restore();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Font font = c.getFont();
        FontMetrics fm = c.getFontMetrics(font);
        Insets insets = c.getInsets();
        Dimension prefSize = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        String text = ((JToolTip)c).getTipText();
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                prefSize.width += (int)v.getPreferredSpan(0) + 6;
                prefSize.height += (int)v.getPreferredSpan(1);
            } else {
                prefSize.width += fm.stringWidth(text) + 6;
                prefSize.height += fm.getHeight();
            }
        }
        return prefSize;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        Window w = SwingUtilities.getWindowAncestor(this.toolTip);
        if (this.toolTip.getParent() instanceof JComponent) {
            ((JComponent)this.toolTip.getParent()).setOpaque(false);
        }
        if (this.lastRootPane != null) {
            this.lastRootPane.putClientProperty("JRootPane.isToolTip", false);
        }
        if (w != null && !this.isDecorated(w) && w.getClass().getEnclosingClass().equals(Popup.class)) {
            w.setBackground(DarkUIUtil.TRANSPARENT_COLOR);
            if (w instanceof RootPaneContainer) {
                this.lastRootPane = ((RootPaneContainer)((Object)w)).getRootPane();
                if (this.lastRootPane != null) {
                    this.lastRootPane.putClientProperty("JRootPane.isToolTip", true);
                }
            }
        }
    }

    protected boolean isDecorated(Window w) {
        if (w instanceof Dialog) {
            return !((Dialog)w).isUndecorated();
        }
        if (w instanceof Frame) {
            return !((Frame)w).isUndecorated();
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if (evt.getSource() instanceof JToolTip) {
            JToolTip tooltip = (JToolTip)evt.getSource();
            if (tooltip.getBorder() instanceof DarkTooltipBorder) {
                DarkTooltipBorder border = (DarkTooltipBorder)tooltip.getBorder();
                Object newVal = evt.getNewValue();
                if (KEY_POINTER_LOCATION.equals(key)) {
                    if (newVal instanceof Alignment) {
                        border.setPointerLocation((Alignment)((Object)newVal));
                    } else {
                        border.setPointerLocation(Alignment.CENTER);
                    }
                    this.updateSize();
                } else if (KEY_POINTER_HEIGHT.equals(key)) {
                    if (newVal instanceof Integer) {
                        border.setPointerHeight((Integer)newVal);
                    }
                    this.updateSize();
                } else if (KEY_POINTER_WIDTH.equals(key)) {
                    if (newVal instanceof Integer) {
                        border.setPointerWidth((Integer)newVal);
                    }
                    this.updateSize();
                } else if (KEY_INSETS.equals(key)) {
                    this.updateSize();
                } else if ("component".equals(key)) {
                    Object newComp;
                    Object oldComp = evt.getOldValue();
                    if (oldComp instanceof Component) {
                        ((Component)oldComp).removeMouseListener(this.mouseListener);
                        ((Component)oldComp).removePropertyChangeListener(this.componentPropertyChaneListener);
                    }
                    if ((newComp = evt.getNewValue()) instanceof Component) {
                        ((Component)newComp).addMouseListener(this.mouseListener);
                        ((Component)newComp).addPropertyChangeListener(this.componentPropertyChaneListener);
                    }
                    this.updateStyle();
                } else if (TIP_TEXT_PROPERTY.equals(key)) {
                    if (!this.isTipTextChanging) {
                        this.isTipTextChanging = true;
                        String tipText = tooltip.getTipText();
                        if (tipText != null && !tipText.startsWith("<html>")) {
                            if (tipText.contains("\n")) {
                                tooltip.setTipText("<html>" + tipText.replaceAll("\n", "<\\br>") + "</html>");
                            } else {
                                tooltip.setTipText("<html><body><nobr>" + tipText + "</nobr></body></html>");
                            }
                        } else {
                            tooltip.setTipText(tipText);
                        }
                        this.updateSize();
                        this.isTipTextChanging = false;
                    }
                } else if ("ancestor".equals(key)) {
                    if (evt.getOldValue() == null) {
                        this.added = true;
                        ToolTipUtil.applyContext(this.toolTip);
                    }
                    if (evt.getNewValue() == null) {
                        this.alpha = 0.0f;
                    }
                }
            }
            if (KEY_STYLE.equals(key)) {
                this.updateSize();
            }
        }
    }

    private void updateStyle() {
        JComponent comp = this.toolTip.getComponent();
        if (comp != null) {
            ToolTipStyle style = DarkTooltipUI.getStyle(comp.getClientProperty(KEY_STYLE));
            ToolTipStyle tooltipStyle = DarkTooltipUI.getStyle(this.toolTip.getClientProperty(KEY_STYLE));
            this.toolTip.putClientProperty(KEY_STYLE, (Object)(style != null ? style : (tooltipStyle != null ? tooltipStyle : ToolTipStyle.PLAIN_BALLOON)));
        }
    }

    public static ToolTipStyle getStyle(Object style) {
        if (style instanceof ToolTipStyle) {
            return (ToolTipStyle)((Object)style);
        }
        if (style == null) {
            return null;
        }
        String name = style.toString();
        if (VARIANT_PLAIN_BALLOON.equals(name)) {
            return ToolTipStyle.PLAIN_BALLOON;
        }
        if (VARIANT_BALLOON.equals(name)) {
            return ToolTipStyle.BALLOON;
        }
        if (VARIANT_PLAIN.equals(name)) {
            return ToolTipStyle.PLAIN;
        }
        return null;
    }

    protected void updateSize() {
        this.toolTip.doLayout();
    }

    protected class FadeInAnimator
    extends Animator {
        private static final int DELAY_FRAMES = 6;
        private static final int FADEIN_FRAMES_COUNT = 16;

        public FadeInAnimator() {
            super("Tooltip fadein", 16, 320, false);
        }

        @Override
        public void paintNow(int frame, int totalFrames, int cycle) {
            DarkTooltipUI.this.alpha = (float)frame * 1.0f / (float)totalFrames;
            Window window = SwingUtilities.getWindowAncestor(DarkTooltipUI.this.toolTip);
            if (window != null) {
                window.setOpacity(DarkTooltipUI.this.alpha);
            }
        }

        @Override
        protected void paintCycleEnd() {
            DarkTooltipUI.this.alpha = 1.0f;
            Window window = SwingUtilities.getWindowAncestor(DarkTooltipUI.this.toolTip);
            if (window != null) {
                window.setOpacity(DarkTooltipUI.this.alpha);
            }
        }
    }
}

