/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table;

import com.github.weisj.darklaf.ui.BasicTransferable;
import com.github.weisj.darklaf.ui.DragRecognitionSupport;
import com.github.weisj.darklaf.ui.table.DarkTableHeaderUI;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.LazyActionMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public abstract class TableUIBridge
extends TableUI {
    protected static final StringBuilder BASELINE_COMPONENT_KEY = new StringBuilder("Table.baselineComponent");
    protected static final TransferHandler defaultTransferHandler = new TableTransferHandler();
    protected JTable table;
    protected CellRendererPane rendererPane;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;
    protected Handler handler;
    protected boolean isFileList = false;

    public static ComponentUI createUI(JComponent c) {
        return new BasicTableUI();
    }

    public static void loadActionMap(LazyActionMap map) {
        map.put(new Actions("selectNextColumn", 1, 0, false, false));
        map.put(new Actions("selectNextColumnChangeLead", 1, 0, false, false));
        map.put(new Actions("selectPreviousColumn", -1, 0, false, false));
        map.put(new Actions("selectPreviousColumnChangeLead", -1, 0, false, false));
        map.put(new Actions("selectNextRow", 0, 1, false, false));
        map.put(new Actions("selectNextRowChangeLead", 0, 1, false, false));
        map.put(new Actions("selectPreviousRow", 0, -1, false, false));
        map.put(new Actions("selectPreviousRowChangeLead", 0, -1, false, false));
        map.put(new Actions("selectNextColumnExtendSelection", 1, 0, true, false));
        map.put(new Actions("selectPreviousColumnExtendSelection", -1, 0, true, false));
        map.put(new Actions("selectNextRowExtendSelection", 0, 1, true, false));
        map.put(new Actions("selectPreviousRowExtendSelection", 0, -1, true, false));
        map.put(new Actions("scrollUpChangeSelection", false, false, true, false));
        map.put(new Actions("scrollDownChangeSelection", false, true, true, false));
        map.put(new Actions("selectFirstColumn", false, false, false, true));
        map.put(new Actions("selectLastColumn", false, true, false, true));
        map.put(new Actions("scrollUpExtendSelection", true, false, true, false));
        map.put(new Actions("scrollDownExtendSelection", true, true, true, false));
        map.put(new Actions("selectFirstColumnExtendSelection", true, false, false, true));
        map.put(new Actions("selectLastColumnExtendSelection", true, true, false, true));
        map.put(new Actions("selectFirstRow", false, false, true, true));
        map.put(new Actions("selectLastRow", false, true, true, true));
        map.put(new Actions("selectFirstRowExtendSelection", true, false, true, true));
        map.put(new Actions("selectLastRowExtendSelection", true, true, true, true));
        map.put(new Actions("selectNextColumnCell", 1, 0, false, true));
        map.put(new Actions("selectPreviousColumnCell", -1, 0, false, true));
        map.put(new Actions("selectNextRowCell", 0, 1, false, true));
        map.put(new Actions("selectPreviousRowCell", 0, -1, false, true));
        map.put(new Actions("selectAll"));
        map.put(new Actions("clearSelection"));
        map.put(new Actions("cancel"));
        map.put(new Actions("startEditing"));
        map.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        map.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        map.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        map.put(new Actions("scrollLeftChangeSelection", false, false, false, false));
        map.put(new Actions("scrollRightChangeSelection", false, true, false, false));
        map.put(new Actions("scrollLeftExtendSelection", true, false, false, false));
        map.put(new Actions("scrollRightExtendSelection", true, true, false, false));
        map.put(new Actions("addToSelection"));
        map.put(new Actions("toggleAndAnchor"));
        map.put(new Actions("extendTo"));
        map.put(new Actions("moveSelectionTo"));
        map.put(new Actions("focusHeader"));
    }

    protected static int getAdjustedLead(JTable table, boolean row) {
        return row ? TableUIBridge.getAdjustedLead(table, row, table.getSelectionModel()) : TableUIBridge.getAdjustedLead(table, row, table.getColumnModel().getSelectionModel());
    }

    protected static int getAdjustedLead(JTable table, boolean row, ListSelectionModel model) {
        int index = model.getLeadSelectionIndex();
        int compare = row ? table.getRowCount() : table.getColumnCount();
        return index < compare ? index : -1;
    }

    protected boolean pointOutsidePrefSize(int row, int column, Point p) {
        if (!this.isFileList) {
            return false;
        }
        return SwingUtilities2.pointOutsidePrefSize(this.table, row, column, p);
    }

    @Override
    public void installUI(JComponent c) {
        this.table = (JTable)c;
        this.rendererPane = new CellRendererPane();
        this.table.add(this.rendererPane);
        this.installDefaults();
        this.installDefaults2();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        Container parent;
        Color gridColor;
        Color sfg;
        LookAndFeel.installColorsAndFont(this.table, "Table.background", "Table.foreground", "Table.font");
        LookAndFeel.installProperty(this.table, "opaque", Boolean.TRUE);
        Color sbg = this.table.getSelectionBackground();
        if (sbg == null || sbg instanceof UIResource) {
            sbg = UIManager.getColor("Table.selectionBackground");
            this.table.setSelectionBackground(sbg != null ? sbg : UIManager.getColor("textHighlight"));
        }
        if ((sfg = this.table.getSelectionForeground()) == null || sfg instanceof UIResource) {
            sfg = UIManager.getColor("Table.selectionForeground");
            this.table.setSelectionForeground(sfg != null ? sfg : UIManager.getColor("textHighlightText"));
        }
        if ((gridColor = this.table.getGridColor()) == null || gridColor instanceof UIResource) {
            gridColor = UIManager.getColor("Table.gridColor");
            this.table.setGridColor(gridColor != null ? gridColor : Color.GRAY);
        }
        if ((parent = DarkUIUtil.getUnwrappedParent(this.table)) != null && (parent = parent.getParent()) != null && parent instanceof JScrollPane) {
            LookAndFeel.installBorder((JScrollPane)parent, "Table.scrollPaneBorder");
        }
        this.isFileList = Boolean.TRUE.equals(this.table.getClientProperty("Table.isFileList"));
    }

    protected void installDefaults2() {
        TransferHandler th = this.table.getTransferHandler();
        if (th == null || th instanceof UIResource) {
            this.table.setTransferHandler(defaultTransferHandler);
            if (this.table.getDropTarget() instanceof UIResource) {
                this.table.setDropTarget(null);
            }
        }
    }

    protected void installListeners() {
        this.focusListener = this.createFocusListener();
        this.keyListener = this.createKeyListener();
        this.mouseInputListener = this.createMouseInputListener();
        this.table.addFocusListener(this.focusListener);
        this.table.addKeyListener(this.keyListener);
        this.table.addMouseListener(this.mouseInputListener);
        this.table.addMouseMotionListener(this.mouseInputListener);
        this.table.addPropertyChangeListener(this.getHandler());
        if (this.isFileList) {
            this.table.getSelectionModel().addListSelectionListener(this.getHandler());
        }
    }

    protected void installKeyboardActions() {
        LazyActionMap.installLazyActionMap(this.table, TableUIBridge.class, "Table.actionMap");
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.table, 1, inputMap);
    }

    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    protected KeyListener createKeyListener() {
        return null;
    }

    protected MouseInputListener createMouseInputListener() {
        return this.getHandler();
    }

    protected Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            InputMap rtlKeyMap;
            InputMap keyMap = (InputMap)DefaultLookup.get(this.table, this, "Table.ancestorInputMap");
            if (this.table.getComponentOrientation().isLeftToRight() || (rtlKeyMap = (InputMap)DefaultLookup.get(this.table, this, "Table.ancestorInputMap.RightToLeft")) == null) {
                return keyMap;
            }
            rtlKeyMap.setParent(keyMap);
            return rtlKeyMap;
        }
        return null;
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.table.remove(this.rendererPane);
        this.rendererPane = null;
        this.table = null;
    }

    protected void uninstallDefaults() {
        if (this.table.getTransferHandler() instanceof UIResource) {
            this.table.setTransferHandler(null);
        }
    }

    protected void uninstallListeners() {
        this.table.removeFocusListener(this.focusListener);
        this.table.removeKeyListener(this.keyListener);
        this.table.removeMouseListener(this.mouseInputListener);
        this.table.removeMouseMotionListener(this.mouseInputListener);
        this.table.removePropertyChangeListener(this.getHandler());
        if (this.isFileList) {
            this.table.getSelectionModel().removeListSelectionListener(this.getHandler());
        }
        this.focusListener = null;
        this.keyListener = null;
        this.mouseInputListener = null;
        this.handler = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.table, 1, null);
        SwingUtilities.replaceUIActionMap(this.table, null);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Container comp;
        Object printMode;
        Rectangle clip = g.getClipBounds();
        Rectangle bounds = this.table.getBounds();
        bounds.y = 0;
        bounds.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !bounds.intersects(clip)) {
            this.paintDropLines(g);
            return;
        }
        boolean ltr = this.table.getComponentOrientation().isLeftToRight();
        Rectangle visibleBounds = clip.intersection(bounds);
        Point upperLeft = visibleBounds.getLocation();
        Point lowerRight = new Point(visibleBounds.x + visibleBounds.width - 1, visibleBounds.y + visibleBounds.height - 1);
        int rMin = this.table.rowAtPoint(upperLeft);
        int rMax = this.table.rowAtPoint(lowerRight);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        if ((printMode = this.table.getClientProperty("Table.printMode")) == JTable.PrintMode.FIT_WIDTH) {
            upperLeft = clip.getLocation();
            lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        }
        int cMin = this.table.columnAtPoint(ltr ? upperLeft : lowerRight);
        int cMax = this.table.columnAtPoint(ltr ? lowerRight : upperLeft);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        if ((comp = DarkUIUtil.getUnwrappedParent(this.table)) != null) {
            comp = comp.getParent();
        }
        if (comp != null && !(comp instanceof JViewport) && !(comp instanceof JScrollPane) && rMax != this.table.getRowCount() - 1 && this.table.getSelectedRow() == -1 && rMax - rMin > 1) {
            --rMax;
        }
        this.paintGrid(g, rMin, rMax, cMin, cMax);
        this.paintCells(g, rMin, rMax, cMin, cMax);
        this.paintDropLines(g);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createTableSize(width);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMinWidth();
        }
        return this.createTableSize(width);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMaxWidth();
        }
        return this.createTableSize(width);
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        super.getBaseline(c, width, height);
        UIDefaults lafDefaults = UIManager.getLookAndFeelDefaults();
        Component renderer = (Component)lafDefaults.get(BASELINE_COMPONENT_KEY);
        if (renderer == null) {
            DefaultTableCellRenderer tcr = new DefaultTableCellRenderer();
            renderer = tcr.getTableCellRendererComponent(this.table, "a", false, false, -1, -1);
            lafDefaults.put(BASELINE_COMPONENT_KEY, renderer);
        }
        renderer.setFont(this.table.getFont());
        int rowMargin = this.table.getRowMargin();
        return renderer.getBaseline(Integer.MAX_VALUE, this.table.getRowHeight() - rowMargin) + rowMargin / 2;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
        super.getBaselineResizeBehavior(c);
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    protected Dimension createTableSize(long width) {
        long tmp;
        int height = 0;
        int rowCount = this.table.getRowCount();
        if (rowCount > 0 && this.table.getColumnCount() > 0) {
            Rectangle r = this.table.getCellRect(rowCount - 1, 0, true);
            height = r.y + r.height;
        }
        if ((tmp = Math.abs(width)) > Integer.MAX_VALUE) {
            tmp = Integer.MAX_VALUE;
        }
        return new Dimension((int)tmp, height);
    }

    protected void paintDropLines(Graphics g) {
        JTable.DropLocation loc = this.table.getDropLocation();
        if (loc == null) {
            return;
        }
        Color color = UIManager.getColor("Table.dropLineColor");
        Color shortColor = UIManager.getColor("Table.dropLineShortColor");
        if (color == null && shortColor == null) {
            return;
        }
        Rectangle rect = this.getHDropLineRect(loc);
        if (rect != null) {
            int x = rect.x;
            int w = rect.width;
            if (color != null) {
                this.extendRect(rect, true);
                g.setColor(color);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (!loc.isInsertColumn() && shortColor != null) {
                g.setColor(shortColor);
                g.fillRect(x, rect.y, w, rect.height);
            }
        }
        if ((rect = this.getVDropLineRect(loc)) != null) {
            int y = rect.y;
            int h = rect.height;
            if (color != null) {
                this.extendRect(rect, false);
                g.setColor(color);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (!loc.isInsertRow() && shortColor != null) {
                g.setColor(shortColor);
                g.fillRect(rect.x, y, rect.width, h);
            }
        }
    }

    protected Rectangle getHDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertRow()) {
            return null;
        }
        int row = loc.getRow();
        int col = loc.getColumn();
        if (col >= this.table.getColumnCount()) {
            --col;
        }
        Rectangle rect = this.table.getCellRect(row, col, true);
        if (row >= this.table.getRowCount()) {
            Rectangle prevRect = this.table.getCellRect(--row, col, true);
            rect.y = prevRect.y + prevRect.height;
        }
        rect.y = rect.y == 0 ? -1 : (rect.y -= 2);
        rect.height = 3;
        return rect;
    }

    protected Rectangle extendRect(Rectangle rect, boolean horizontal) {
        if (rect == null) {
            return rect;
        }
        if (horizontal) {
            rect.x = 0;
            rect.width = this.table.getWidth();
        } else {
            rect.y = 0;
            if (this.table.getRowCount() != 0) {
                Rectangle lastRect = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
                rect.height = lastRect.y + lastRect.height;
            } else {
                rect.height = this.table.getHeight();
            }
        }
        return rect;
    }

    protected Rectangle getVDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertColumn()) {
            return null;
        }
        boolean ltr = this.table.getComponentOrientation().isLeftToRight();
        int col = loc.getColumn();
        Rectangle rect = this.table.getCellRect(loc.getRow(), col, true);
        if (col >= this.table.getColumnCount()) {
            rect = this.table.getCellRect(loc.getRow(), --col, true);
            if (ltr) {
                rect.x += rect.width;
            }
        } else if (!ltr) {
            rect.x += rect.width;
        }
        rect.x = rect.x == 0 ? -1 : (rect.x -= 2);
        rect.width = 3;
        return rect;
    }

    protected void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        block6: {
            int x;
            g.setColor(this.table.getGridColor());
            Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
            Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
            Rectangle damagedArea = minCell.union(maxCell);
            if (this.table.getShowHorizontalLines()) {
                int tableWidth = damagedArea.x + damagedArea.width;
                int y = damagedArea.y;
                for (int row = rMin; row <= rMax; ++row) {
                    SwingUtilities2.drawHLine(g, damagedArea.x, tableWidth - 1, (y += this.table.getRowHeight(row)) - 1);
                }
            }
            if (!this.table.getShowVerticalLines()) break block6;
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = damagedArea.y + damagedArea.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                x = damagedArea.x;
                for (int column = cMin; column <= cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    SwingUtilities2.drawVLine(g, (x += w) - 1, 0, tableHeight - 1);
                }
            } else {
                x = damagedArea.x;
                for (int column = cMax; column >= cMin; --column) {
                    int w = cm.getColumn(column).getWidth();
                    SwingUtilities2.drawVLine(g, (x += w) - 1, 0, tableHeight - 1);
                }
            }
        }
    }

    protected void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (int row = rMin; row <= rMax; ++row) {
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                for (int column = cMin; column <= cMax; ++column) {
                    TableColumn aColumn = cm.getColumn(column);
                    int columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    if (aColumn != draggedColumn) {
                        this.paintCell(g, cellRect, row, column);
                    }
                    cellRect.x += columnWidth;
                }
            }
        } else {
            for (int row = rMin; row <= rMax; ++row) {
                int columnWidth;
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                TableColumn aColumn = cm.getColumn(cMin);
                if (aColumn != draggedColumn) {
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    this.paintCell(g, cellRect, row, cMin);
                }
                for (int column = cMin + 1; column <= cMax; ++column) {
                    aColumn = cm.getColumn(column);
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    cellRect.x -= columnWidth;
                    if (aColumn == draggedColumn) continue;
                    this.paintCell(g, cellRect, row, column);
                }
            }
        }
        if (draggedColumn != null) {
            this.paintDraggedArea(g, rMin, rMax, draggedColumn, header.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    protected void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }

    protected void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        g.setColor(this.table.getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        if (this.table.getShowVerticalLines()) {
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            g.drawLine(x1 - 1, y1, x1 - 1, y2);
            g.drawLine(x2, y1, x2, y2);
        }
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
            r.x += distance;
            this.paintCell(g, r, row, draggedColumnIndex);
            if (!this.table.getShowHorizontalLines()) continue;
            g.setColor(this.table.getGridColor());
            Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
            rcr.x += distance;
            int x1 = rcr.x;
            int y1 = rcr.y;
            int x2 = x1 + rcr.width - 1;
            int y2 = y1 + rcr.height - 1;
            g.drawLine(x1, y2, x2, y2);
        }
    }

    protected int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    protected static class Actions
    extends UIAction {
        protected static final String CANCEL_EDITING = "cancel";
        protected static final String SELECT_ALL = "selectAll";
        protected static final String CLEAR_SELECTION = "clearSelection";
        protected static final String START_EDITING = "startEditing";
        protected static final String NEXT_ROW = "selectNextRow";
        protected static final String NEXT_ROW_CELL = "selectNextRowCell";
        protected static final String NEXT_ROW_EXTEND_SELECTION = "selectNextRowExtendSelection";
        protected static final String NEXT_ROW_CHANGE_LEAD = "selectNextRowChangeLead";
        protected static final String PREVIOUS_ROW = "selectPreviousRow";
        protected static final String PREVIOUS_ROW_CELL = "selectPreviousRowCell";
        protected static final String PREVIOUS_ROW_EXTEND_SELECTION = "selectPreviousRowExtendSelection";
        protected static final String PREVIOUS_ROW_CHANGE_LEAD = "selectPreviousRowChangeLead";
        protected static final String NEXT_COLUMN = "selectNextColumn";
        protected static final String NEXT_COLUMN_CELL = "selectNextColumnCell";
        protected static final String NEXT_COLUMN_EXTEND_SELECTION = "selectNextColumnExtendSelection";
        protected static final String NEXT_COLUMN_CHANGE_LEAD = "selectNextColumnChangeLead";
        protected static final String PREVIOUS_COLUMN = "selectPreviousColumn";
        protected static final String PREVIOUS_COLUMN_CELL = "selectPreviousColumnCell";
        protected static final String PREVIOUS_COLUMN_EXTEND_SELECTION = "selectPreviousColumnExtendSelection";
        protected static final String PREVIOUS_COLUMN_CHANGE_LEAD = "selectPreviousColumnChangeLead";
        protected static final String SCROLL_LEFT_CHANGE_SELECTION = "scrollLeftChangeSelection";
        protected static final String SCROLL_LEFT_EXTEND_SELECTION = "scrollLeftExtendSelection";
        protected static final String SCROLL_RIGHT_CHANGE_SELECTION = "scrollRightChangeSelection";
        protected static final String SCROLL_RIGHT_EXTEND_SELECTION = "scrollRightExtendSelection";
        protected static final String SCROLL_UP_CHANGE_SELECTION = "scrollUpChangeSelection";
        protected static final String SCROLL_UP_EXTEND_SELECTION = "scrollUpExtendSelection";
        protected static final String SCROLL_DOWN_CHANGE_SELECTION = "scrollDownChangeSelection";
        protected static final String SCROLL_DOWN_EXTEND_SELECTION = "scrollDownExtendSelection";
        protected static final String FIRST_COLUMN = "selectFirstColumn";
        protected static final String FIRST_COLUMN_EXTEND_SELECTION = "selectFirstColumnExtendSelection";
        protected static final String LAST_COLUMN = "selectLastColumn";
        protected static final String LAST_COLUMN_EXTEND_SELECTION = "selectLastColumnExtendSelection";
        protected static final String FIRST_ROW = "selectFirstRow";
        protected static final String FIRST_ROW_EXTEND_SELECTION = "selectFirstRowExtendSelection";
        protected static final String LAST_ROW = "selectLastRow";
        protected static final String LAST_ROW_EXTEND_SELECTION = "selectLastRowExtendSelection";
        protected static final String ADD_TO_SELECTION = "addToSelection";
        protected static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        protected static final String EXTEND_TO = "extendTo";
        protected static final String MOVE_SELECTION_TO = "moveSelectionTo";
        protected static final String FOCUS_HEADER = "focusHeader";
        protected int dx;
        protected int dy;
        protected boolean extend;
        protected boolean inSelection;
        protected boolean forwards;
        protected boolean vertically;
        protected boolean toLimit;
        protected int leadRow;
        protected int leadColumn;

        Actions(String name) {
            super(name);
        }

        Actions(String name, boolean extend, boolean forwards, boolean vertically, boolean toLimit) {
            this(name, 0, 0, extend, false);
            this.forwards = forwards;
            this.vertically = vertically;
            this.toLimit = toLimit;
        }

        Actions(String name, int dx, int dy, boolean extend, boolean inSelection) {
            super(name);
            if (inSelection) {
                this.inSelection = true;
                dx = Actions.sign(dx);
                dy = Actions.sign(dy);
                assert (!(dx != 0 && dy != 0 || dx == 0 && dy == 0));
            }
            this.dx = dx;
            this.dy = dy;
            this.extend = extend;
        }

        protected static int sign(int num) {
            return Integer.compare(num, 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTableHeader th;
            String key = this.getName();
            JTable table = (JTable)e.getSource();
            ListSelectionModel rsm = table.getSelectionModel();
            this.leadRow = TableUIBridge.getAdjustedLead(table, true, rsm);
            ListSelectionModel csm = table.getColumnModel().getSelectionModel();
            this.leadColumn = TableUIBridge.getAdjustedLead(table, false, csm);
            if (Objects.equals(key, SCROLL_LEFT_CHANGE_SELECTION) || Objects.equals(key, SCROLL_LEFT_EXTEND_SELECTION) || Objects.equals(key, SCROLL_RIGHT_CHANGE_SELECTION) || Objects.equals(key, SCROLL_RIGHT_EXTEND_SELECTION) || Objects.equals(key, SCROLL_UP_CHANGE_SELECTION) || Objects.equals(key, SCROLL_UP_EXTEND_SELECTION) || Objects.equals(key, SCROLL_DOWN_CHANGE_SELECTION) || Objects.equals(key, SCROLL_DOWN_EXTEND_SELECTION) || Objects.equals(key, FIRST_COLUMN) || Objects.equals(key, FIRST_COLUMN_EXTEND_SELECTION) || Objects.equals(key, FIRST_ROW) || Objects.equals(key, FIRST_ROW_EXTEND_SELECTION) || Objects.equals(key, LAST_COLUMN) || Objects.equals(key, LAST_COLUMN_EXTEND_SELECTION) || Objects.equals(key, LAST_ROW) || Objects.equals(key, LAST_ROW_EXTEND_SELECTION)) {
                if (this.toLimit) {
                    if (this.vertically) {
                        int rowCount = table.getRowCount();
                        this.dx = 0;
                        this.dy = this.forwards ? rowCount : -rowCount;
                    } else {
                        int colCount = table.getColumnCount();
                        this.dx = this.forwards ? colCount : -colCount;
                        this.dy = 0;
                    }
                } else {
                    Rectangle r;
                    if (!(DarkUIUtil.getUnwrappedParent(table).getParent() instanceof JScrollPane)) {
                        return;
                    }
                    Dimension delta = table.getParent().getSize();
                    if (this.vertically) {
                        r = table.getCellRect(this.leadRow, 0, true);
                        r.y = this.forwards ? (r.y += Math.max(delta.height, r.height)) : (r.y -= delta.height);
                        this.dx = 0;
                        int newRow = table.rowAtPoint(r.getLocation());
                        if (newRow == -1 && this.forwards) {
                            newRow = table.getRowCount();
                        }
                        this.dy = newRow - this.leadRow;
                    } else {
                        r = table.getCellRect(0, this.leadColumn, true);
                        r.x = this.forwards ? (r.x += Math.max(delta.width, r.width)) : (r.x -= delta.width);
                        int newColumn = table.columnAtPoint(r.getLocation());
                        if (newColumn == -1) {
                            boolean ltr = table.getComponentOrientation().isLeftToRight();
                            newColumn = this.forwards ? (ltr ? table.getColumnCount() : 0) : (ltr ? 0 : table.getColumnCount());
                        }
                        this.dx = newColumn - this.leadColumn;
                        this.dy = 0;
                    }
                }
            }
            if (Objects.equals(key, NEXT_ROW) || Objects.equals(key, NEXT_ROW_CELL) || Objects.equals(key, NEXT_ROW_EXTEND_SELECTION) || Objects.equals(key, NEXT_ROW_CHANGE_LEAD) || Objects.equals(key, NEXT_COLUMN) || Objects.equals(key, NEXT_COLUMN_CELL) || Objects.equals(key, NEXT_COLUMN_EXTEND_SELECTION) || Objects.equals(key, NEXT_COLUMN_CHANGE_LEAD) || Objects.equals(key, PREVIOUS_ROW) || Objects.equals(key, PREVIOUS_ROW_CELL) || Objects.equals(key, PREVIOUS_ROW_EXTEND_SELECTION) || Objects.equals(key, PREVIOUS_ROW_CHANGE_LEAD) || Objects.equals(key, PREVIOUS_COLUMN) || Objects.equals(key, PREVIOUS_COLUMN_CELL) || Objects.equals(key, PREVIOUS_COLUMN_EXTEND_SELECTION) || Objects.equals(key, PREVIOUS_COLUMN_CHANGE_LEAD) || Objects.equals(key, SCROLL_LEFT_CHANGE_SELECTION) || Objects.equals(key, SCROLL_LEFT_EXTEND_SELECTION) || Objects.equals(key, SCROLL_RIGHT_CHANGE_SELECTION) || Objects.equals(key, SCROLL_RIGHT_EXTEND_SELECTION) || Objects.equals(key, SCROLL_UP_CHANGE_SELECTION) || Objects.equals(key, SCROLL_UP_EXTEND_SELECTION) || Objects.equals(key, SCROLL_DOWN_CHANGE_SELECTION) || Objects.equals(key, SCROLL_DOWN_EXTEND_SELECTION) || Objects.equals(key, FIRST_COLUMN) || Objects.equals(key, FIRST_COLUMN_EXTEND_SELECTION) || Objects.equals(key, FIRST_ROW) || Objects.equals(key, FIRST_ROW_EXTEND_SELECTION) || Objects.equals(key, LAST_COLUMN) || Objects.equals(key, LAST_COLUMN_EXTEND_SELECTION) || Objects.equals(key, LAST_ROW) || Objects.equals(key, LAST_ROW_EXTEND_SELECTION)) {
                Rectangle cellRect;
                if (table.isEditing() && !table.getCellEditor().stopCellEditing()) {
                    return;
                }
                boolean changeLead = false;
                if (Objects.equals(key, NEXT_ROW_CHANGE_LEAD) || Objects.equals(key, PREVIOUS_ROW_CHANGE_LEAD)) {
                    changeLead = rsm.getSelectionMode() == 2;
                } else if (Objects.equals(key, NEXT_COLUMN_CHANGE_LEAD) || Objects.equals(key, PREVIOUS_COLUMN_CHANGE_LEAD)) {
                    boolean bl = changeLead = csm.getSelectionMode() == 2;
                }
                if (changeLead) {
                    this.moveWithinTableRange(table, this.dx, this.dy);
                    if (this.dy != 0) {
                        ((DefaultListSelectionModel)rsm).moveLeadSelectionIndex(this.leadRow);
                        if (TableUIBridge.getAdjustedLead(table, false, csm) == -1 && table.getColumnCount() > 0) {
                            ((DefaultListSelectionModel)csm).moveLeadSelectionIndex(0);
                        }
                    } else {
                        ((DefaultListSelectionModel)csm).moveLeadSelectionIndex(this.leadColumn);
                        if (TableUIBridge.getAdjustedLead(table, true, rsm) == -1 && table.getRowCount() > 0) {
                            ((DefaultListSelectionModel)rsm).moveLeadSelectionIndex(0);
                        }
                    }
                    if ((cellRect = table.getCellRect(this.leadRow, this.leadColumn, false)) != null) {
                        table.scrollRectToVisible(cellRect);
                    }
                } else if (!this.inSelection) {
                    this.moveWithinTableRange(table, this.dx, this.dy);
                    table.changeSelection(this.leadRow, this.leadColumn, false, this.extend);
                } else {
                    if (table.getRowCount() <= 0 || table.getColumnCount() <= 0) {
                        return;
                    }
                    if (this.moveWithinSelectedRange(table, this.dx, this.dy, rsm, csm)) {
                        if (rsm.isSelectedIndex(this.leadRow)) {
                            rsm.addSelectionInterval(this.leadRow, this.leadRow);
                        } else {
                            rsm.removeSelectionInterval(this.leadRow, this.leadRow);
                        }
                        if (csm.isSelectedIndex(this.leadColumn)) {
                            csm.addSelectionInterval(this.leadColumn, this.leadColumn);
                        } else {
                            csm.removeSelectionInterval(this.leadColumn, this.leadColumn);
                        }
                        cellRect = table.getCellRect(this.leadRow, this.leadColumn, false);
                        if (cellRect != null) {
                            table.scrollRectToVisible(cellRect);
                        }
                    } else {
                        table.changeSelection(this.leadRow, this.leadColumn, false, false);
                    }
                }
            } else if (Objects.equals(key, CANCEL_EDITING)) {
                table.removeEditor();
            } else if (Objects.equals(key, SELECT_ALL)) {
                table.selectAll();
            } else if (Objects.equals(key, CLEAR_SELECTION)) {
                table.clearSelection();
            } else if (Objects.equals(key, START_EDITING)) {
                if (!table.hasFocus()) {
                    TableCellEditor cellEditor = table.getCellEditor();
                    if (cellEditor != null && !cellEditor.stopCellEditing()) {
                        return;
                    }
                    table.requestFocus();
                    return;
                }
                table.editCellAt(this.leadRow, this.leadColumn, e);
                Component editorComp = table.getEditorComponent();
                if (editorComp != null) {
                    editorComp.requestFocus();
                }
            } else if (Objects.equals(key, ADD_TO_SELECTION)) {
                if (!table.isCellSelected(this.leadRow, this.leadColumn)) {
                    int oldAnchorRow = rsm.getAnchorSelectionIndex();
                    int oldAnchorColumn = csm.getAnchorSelectionIndex();
                    rsm.setValueIsAdjusting(true);
                    csm.setValueIsAdjusting(true);
                    table.changeSelection(this.leadRow, this.leadColumn, true, false);
                    rsm.setAnchorSelectionIndex(oldAnchorRow);
                    csm.setAnchorSelectionIndex(oldAnchorColumn);
                    rsm.setValueIsAdjusting(false);
                    csm.setValueIsAdjusting(false);
                }
            } else if (Objects.equals(key, TOGGLE_AND_ANCHOR)) {
                table.changeSelection(this.leadRow, this.leadColumn, true, false);
            } else if (Objects.equals(key, EXTEND_TO)) {
                table.changeSelection(this.leadRow, this.leadColumn, false, true);
            } else if (Objects.equals(key, MOVE_SELECTION_TO)) {
                table.changeSelection(this.leadRow, this.leadColumn, false, false);
            } else if (Objects.equals(key, FOCUS_HEADER) && (th = table.getTableHeader()) != null) {
                TableHeaderUI thUI;
                int col = table.getSelectedColumn();
                if (col >= 0 && (thUI = th.getUI()) instanceof DarkTableHeaderUI) {
                    ((DarkTableHeaderUI)thUI).selectColumn(col);
                }
                th.requestFocusInWindow();
            }
        }

        protected void moveWithinTableRange(JTable table, int dx, int dy) {
            this.leadRow = Actions.clipToRange(this.leadRow + dy, 0, table.getRowCount());
            this.leadColumn = Actions.clipToRange(this.leadColumn + dx, 0, table.getColumnCount());
        }

        protected static int clipToRange(int i, int a, int b) {
            return Math.min(Math.max(i, a), b - 1);
        }

        protected boolean moveWithinSelectedRange(JTable table, int dx, int dy, ListSelectionModel rsm, ListSelectionModel csm) {
            boolean stayInSelection;
            int maxY;
            int minY;
            int maxX;
            int minX;
            int totalCount;
            boolean rs = table.getRowSelectionAllowed();
            boolean cs = table.getColumnSelectionAllowed();
            if (rs && cs) {
                totalCount = table.getSelectedRowCount() * table.getSelectedColumnCount();
                minX = csm.getMinSelectionIndex();
                maxX = csm.getMaxSelectionIndex();
                minY = rsm.getMinSelectionIndex();
                maxY = rsm.getMaxSelectionIndex();
            } else if (rs) {
                totalCount = table.getSelectedRowCount();
                minX = 0;
                maxX = table.getColumnCount() - 1;
                minY = rsm.getMinSelectionIndex();
                maxY = rsm.getMaxSelectionIndex();
            } else if (cs) {
                totalCount = table.getSelectedColumnCount();
                minX = csm.getMinSelectionIndex();
                maxX = csm.getMaxSelectionIndex();
                minY = 0;
                maxY = table.getRowCount() - 1;
            } else {
                totalCount = 0;
                maxY = 0;
                minY = 0;
                maxX = 0;
                minX = 0;
            }
            if (totalCount == 0 || totalCount == 1 && table.isCellSelected(this.leadRow, this.leadColumn)) {
                stayInSelection = false;
                maxX = table.getColumnCount() - 1;
                maxY = table.getRowCount() - 1;
                minX = Math.min(0, maxX);
                minY = Math.min(0, maxY);
            } else {
                stayInSelection = true;
            }
            if (dy == 1 && this.leadColumn == -1) {
                this.leadColumn = minX;
                this.leadRow = -1;
            } else if (dx == 1 && this.leadRow == -1) {
                this.leadRow = minY;
                this.leadColumn = -1;
            } else if (dy == -1 && this.leadColumn == -1) {
                this.leadColumn = maxX;
                this.leadRow = maxY + 1;
            } else if (dx == -1 && this.leadRow == -1) {
                this.leadRow = maxY;
                this.leadColumn = maxX + 1;
            }
            this.leadRow = Math.min(Math.max(this.leadRow, minY - 1), maxY + 1);
            this.leadColumn = Math.min(Math.max(this.leadColumn, minX - 1), maxX + 1);
            do {
                this.calcNextPos(dx, minX, maxX, dy, minY, maxY);
            } while (stayInSelection && !table.isCellSelected(this.leadRow, this.leadColumn));
            return stayInSelection;
        }

        protected void calcNextPos(int dx, int minX, int maxX, int dy, int minY, int maxY) {
            if (dx != 0) {
                this.leadColumn += dx;
                if (this.leadColumn > maxX) {
                    this.leadColumn = minX;
                    ++this.leadRow;
                    if (this.leadRow > maxY) {
                        this.leadRow = minY;
                    }
                } else if (this.leadColumn < minX) {
                    this.leadColumn = maxX;
                    --this.leadRow;
                    if (this.leadRow < minY) {
                        this.leadRow = maxY;
                    }
                }
            } else {
                this.leadRow += dy;
                if (this.leadRow > maxY) {
                    this.leadRow = minY;
                    ++this.leadColumn;
                    if (this.leadColumn > maxX) {
                        this.leadColumn = minX;
                    }
                } else if (this.leadRow < minY) {
                    this.leadRow = maxY;
                    --this.leadColumn;
                    if (this.leadColumn < minX) {
                        this.leadColumn = maxX;
                    }
                }
            }
        }

        @Override
        public boolean accept(Object sender) {
            String key = this.getName();
            if (sender instanceof JTable && Boolean.TRUE.equals(((JTable)sender).getClientProperty("Table.isFileList")) && (Objects.equals(key, NEXT_COLUMN) || Objects.equals(key, NEXT_COLUMN_CELL) || Objects.equals(key, NEXT_COLUMN_EXTEND_SELECTION) || Objects.equals(key, NEXT_COLUMN_CHANGE_LEAD) || Objects.equals(key, PREVIOUS_COLUMN) || Objects.equals(key, PREVIOUS_COLUMN_CELL) || Objects.equals(key, PREVIOUS_COLUMN_EXTEND_SELECTION) || Objects.equals(key, PREVIOUS_COLUMN_CHANGE_LEAD) || Objects.equals(key, SCROLL_LEFT_CHANGE_SELECTION) || Objects.equals(key, SCROLL_LEFT_EXTEND_SELECTION) || Objects.equals(key, SCROLL_RIGHT_CHANGE_SELECTION) || Objects.equals(key, SCROLL_RIGHT_EXTEND_SELECTION) || Objects.equals(key, FIRST_COLUMN) || Objects.equals(key, FIRST_COLUMN_EXTEND_SELECTION) || Objects.equals(key, LAST_COLUMN) || Objects.equals(key, LAST_COLUMN_EXTEND_SELECTION) || Objects.equals(key, NEXT_ROW_CELL) || Objects.equals(key, PREVIOUS_ROW_CELL))) {
                return false;
            }
            if (Objects.equals(key, CANCEL_EDITING) && sender instanceof JTable) {
                return ((JTable)sender).isEditing();
            }
            if (Objects.equals(key, NEXT_ROW_CHANGE_LEAD) || Objects.equals(key, PREVIOUS_ROW_CHANGE_LEAD)) {
                return sender != null && ((JTable)sender).getSelectionModel() instanceof DefaultListSelectionModel;
            }
            if (Objects.equals(key, NEXT_COLUMN_CHANGE_LEAD) || Objects.equals(key, PREVIOUS_COLUMN_CHANGE_LEAD)) {
                return sender != null && ((JTable)sender).getColumnModel().getSelectionModel() instanceof DefaultListSelectionModel;
            }
            if (Objects.equals(key, ADD_TO_SELECTION) && sender instanceof JTable) {
                JTable table = (JTable)sender;
                int leadRow = TableUIBridge.getAdjustedLead(table, true);
                int leadCol = TableUIBridge.getAdjustedLead(table, false);
                return !table.isEditing() && !table.isCellSelected(leadRow, leadCol);
            }
            if (Objects.equals(key, FOCUS_HEADER) && sender instanceof JTable) {
                JTable table = (JTable)sender;
                return table.getTableHeader() != null;
            }
            return true;
        }
    }

    protected class Handler
    implements FocusListener,
    MouseInputListener,
    PropertyChangeListener,
    ListSelectionListener,
    ActionListener,
    DragRecognitionSupport.BeforeDrag {
        protected Component dispatchComponent;
        protected int pressedRow;
        protected int pressedCol;
        protected MouseEvent pressedEvent;
        protected boolean dragPressDidSelection;
        protected boolean dragStarted;
        protected boolean shouldStartTimer;
        protected boolean outsidePrefSize;
        protected Timer timer = null;

        protected Handler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.repaintLeadCell();
        }

        protected void repaintLeadCell() {
            int lr = TableUIBridge.getAdjustedLead(TableUIBridge.this.table, true);
            int lc = TableUIBridge.getAdjustedLead(TableUIBridge.this.table, false);
            if (lr < 0 || lc < 0) {
                return;
            }
            Rectangle dirtyRect = TableUIBridge.this.table.getCellRect(lr, lc, false);
            TableUIBridge.this.table.repaint(dirtyRect);
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.repaintLeadCell();
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke((int)e.getKeyChar(), e.getModifiers());
            InputMap map = TableUIBridge.this.table.getInputMap(0);
            if (map != null && map.get(keyStroke) != null) {
                return;
            }
            map = TableUIBridge.this.table.getInputMap(1);
            if (map != null && map.get(keyStroke) != null) {
                return;
            }
            keyStroke = KeyStroke.getKeyStrokeForEvent(e);
            if (e.getKeyChar() == '\r') {
                return;
            }
            int leadRow = TableUIBridge.getAdjustedLead(TableUIBridge.this.table, true);
            int leadColumn = TableUIBridge.getAdjustedLead(TableUIBridge.this.table, false);
            if (leadRow != -1 && leadColumn != -1 && !TableUIBridge.this.table.isEditing() && !TableUIBridge.this.table.editCellAt(leadRow, leadColumn)) {
                return;
            }
            Component editorComp = TableUIBridge.this.table.getEditorComponent();
            if (TableUIBridge.this.table.isEditing() && editorComp != null && editorComp instanceof JComponent) {
                Object binding;
                JComponent component = (JComponent)editorComp;
                map = component.getInputMap(0);
                Object object = binding = map != null ? map.get(keyStroke) : null;
                if (binding == null) {
                    map = component.getInputMap(1);
                    Object object2 = binding = map != null ? map.get(keyStroke) : null;
                }
                if (binding != null) {
                    Action action;
                    ActionMap am = component.getActionMap();
                    Action action2 = action = am != null ? am.get(binding) : null;
                    if (action != null && SwingUtilities.notifyAction(action, keyStroke, e, component, e.getModifiers())) {
                        e.consume();
                    }
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities2.shouldIgnore(e, TableUIBridge.this.table)) {
                return;
            }
            if (TableUIBridge.this.table.isEditing() && !TableUIBridge.this.table.getCellEditor().stopCellEditing()) {
                Component editorComponent = TableUIBridge.this.table.getEditorComponent();
                if (editorComponent != null && !editorComponent.hasFocus()) {
                    SwingUtilities2.compositeRequestFocus(editorComponent);
                }
                return;
            }
            Point p = e.getPoint();
            this.pressedRow = TableUIBridge.this.table.rowAtPoint(p);
            this.pressedCol = TableUIBridge.this.table.columnAtPoint(p);
            this.outsidePrefSize = TableUIBridge.this.pointOutsidePrefSize(this.pressedRow, this.pressedCol, p);
            if (TableUIBridge.this.isFileList) {
                boolean bl = this.shouldStartTimer = TableUIBridge.this.table.isCellSelected(this.pressedRow, this.pressedCol) && !e.isShiftDown() && !DarkUIUtil.isMenuShortcutKeyDown(e) && !this.outsidePrefSize;
            }
            if (TableUIBridge.this.table.getDragEnabled()) {
                this.mousePressedDND(e);
            } else {
                SwingUtilities2.adjustFocus(TableUIBridge.this.table);
                if (!TableUIBridge.this.isFileList) {
                    this.setValueIsAdjusting(true);
                }
                this.adjustSelection(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities2.shouldIgnore(e, TableUIBridge.this.table)) {
                return;
            }
            if (TableUIBridge.this.table.getDragEnabled()) {
                this.mouseReleasedDND(e);
            } else if (TableUIBridge.this.isFileList) {
                this.maybeStartTimer();
            }
            this.pressedEvent = null;
            this.repostEvent(e);
            this.dispatchComponent = null;
            this.setValueIsAdjusting(false);
        }

        protected void mouseReleasedDND(MouseEvent e) {
            MouseEvent me = DragRecognitionSupport.mouseReleased(e);
            if (me != null) {
                SwingUtilities2.adjustFocus(TableUIBridge.this.table);
                if (!this.dragPressDidSelection) {
                    this.adjustSelection(me);
                }
            }
            if (!this.dragStarted) {
                if (TableUIBridge.this.isFileList) {
                    this.maybeStartTimer();
                    return;
                }
                Point p = e.getPoint();
                if (this.pressedEvent != null && TableUIBridge.this.table.rowAtPoint(p) == this.pressedRow && TableUIBridge.this.table.columnAtPoint(p) == this.pressedCol && TableUIBridge.this.table.editCellAt(this.pressedRow, this.pressedCol, this.pressedEvent)) {
                    this.setDispatchComponent(this.pressedEvent);
                    this.repostEvent(this.pressedEvent);
                    TableCellEditor ce = TableUIBridge.this.table.getCellEditor();
                    if (ce != null) {
                        ce.shouldSelectCell(this.pressedEvent);
                    }
                }
            }
        }

        protected void adjustSelection(MouseEvent e) {
            if (this.outsidePrefSize) {
                if (!(e.getID() != 501 || e.isShiftDown() && TableUIBridge.this.table.getSelectionModel().getSelectionMode() != 0)) {
                    TableUIBridge.this.table.clearSelection();
                    TableCellEditor tce = TableUIBridge.this.table.getCellEditor();
                    if (tce != null) {
                        tce.stopCellEditing();
                    }
                }
                return;
            }
            if (this.pressedCol == -1 || this.pressedRow == -1) {
                return;
            }
            boolean dragEnabled = TableUIBridge.this.table.getDragEnabled();
            if (!dragEnabled && !TableUIBridge.this.isFileList && TableUIBridge.this.table.editCellAt(this.pressedRow, this.pressedCol, e)) {
                this.setDispatchComponent(e);
                this.repostEvent(e);
            }
            TableCellEditor editor = TableUIBridge.this.table.getCellEditor();
            if (dragEnabled || editor == null || editor.shouldSelectCell(e)) {
                TableUIBridge.this.table.changeSelection(this.pressedRow, this.pressedCol, DarkUIUtil.isMenuShortcutKeyDown(e), e.isShiftDown());
            }
        }

        protected void maybeStartTimer() {
            if (!this.shouldStartTimer) {
                return;
            }
            if (this.timer == null) {
                this.timer = new Timer(1200, this);
                this.timer.setRepeats(false);
            }
            this.timer.start();
        }

        protected void setDispatchComponent(MouseEvent e) {
            Component editorComponent = TableUIBridge.this.table.getEditorComponent();
            Point p = e.getPoint();
            Point p2 = SwingUtilities.convertPoint(TableUIBridge.this.table, p, editorComponent);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
            SwingUtilities2.setSkipClickCount(this.dispatchComponent, e.getClickCount() - 1);
        }

        protected boolean repostEvent(MouseEvent e) {
            if (this.dispatchComponent == null || !TableUIBridge.this.table.isEditing()) {
                return false;
            }
            MouseEvent e2 = SwingUtilities.convertMouseEvent(TableUIBridge.this.table, e, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(e2);
            return true;
        }

        protected void mousePressedDND(MouseEvent e) {
            this.pressedEvent = e;
            boolean grabFocus = true;
            this.dragStarted = false;
            if (this.canStartDrag() && DragRecognitionSupport.mousePressed(e)) {
                this.dragPressDidSelection = false;
                if (DarkUIUtil.isMenuShortcutKeyDown(e) && TableUIBridge.this.isFileList) {
                    return;
                }
                if (!e.isShiftDown() && TableUIBridge.this.table.isCellSelected(this.pressedRow, this.pressedCol)) {
                    TableUIBridge.this.table.getSelectionModel().addSelectionInterval(this.pressedRow, this.pressedRow);
                    TableUIBridge.this.table.getColumnModel().getSelectionModel().addSelectionInterval(this.pressedCol, this.pressedCol);
                    return;
                }
                this.dragPressDidSelection = true;
                grabFocus = false;
            } else if (!TableUIBridge.this.isFileList) {
                this.setValueIsAdjusting(true);
            }
            if (grabFocus) {
                SwingUtilities2.adjustFocus(TableUIBridge.this.table);
            }
            this.adjustSelection(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        protected boolean canStartDrag() {
            if (this.pressedRow == -1 || this.pressedCol == -1) {
                return false;
            }
            if (TableUIBridge.this.isFileList) {
                return !this.outsidePrefSize;
            }
            if (TableUIBridge.this.table.getSelectionModel().getSelectionMode() == 0 && TableUIBridge.this.table.getColumnModel().getSelectionModel().getSelectionMode() == 0) {
                return true;
            }
            return TableUIBridge.this.table.isCellSelected(this.pressedRow, this.pressedCol);
        }

        protected void setValueIsAdjusting(boolean flag) {
            TableUIBridge.this.table.getSelectionModel().setValueIsAdjusting(flag);
            TableUIBridge.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TableUIBridge.this.table.editCellAt(this.pressedRow, this.pressedCol, null);
            Component editorComponent = TableUIBridge.this.table.getEditorComponent();
            if (editorComponent != null && !editorComponent.hasFocus()) {
                SwingUtilities2.compositeRequestFocus(editorComponent);
            }
        }

        @Override
        public void dragStarting(MouseEvent me) {
            this.dragStarted = true;
            if (DarkUIUtil.isMenuShortcutKeyDown(me) && TableUIBridge.this.isFileList) {
                TableUIBridge.this.table.getSelectionModel().addSelectionInterval(this.pressedRow, this.pressedRow);
                TableUIBridge.this.table.getColumnModel().getSelectionModel().addSelectionInterval(this.pressedCol, this.pressedCol);
            }
            this.pressedEvent = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SwingUtilities2.shouldIgnore(e, TableUIBridge.this.table)) {
                return;
            }
            if (TableUIBridge.this.table.getDragEnabled() && (DragRecognitionSupport.mouseDragged(e, this) || this.dragStarted)) {
                return;
            }
            this.repostEvent(e);
            if (TableUIBridge.this.isFileList || TableUIBridge.this.table.isEditing()) {
                return;
            }
            Point p = e.getPoint();
            int row = TableUIBridge.this.table.rowAtPoint(p);
            int column = TableUIBridge.this.table.columnAtPoint(p);
            if (column == -1 || row == -1) {
                return;
            }
            TableUIBridge.this.table.changeSelection(row, column, DarkUIUtil.isMenuShortcutKeyDown(e), true);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String changeName = event.getPropertyName();
            if ("componentOrientation".equals(changeName)) {
                InputMap inputMap = TableUIBridge.this.getInputMap(1);
                SwingUtilities.replaceUIInputMap(TableUIBridge.this.table, 1, inputMap);
                JTableHeader header = TableUIBridge.this.table.getTableHeader();
                if (header != null) {
                    header.setComponentOrientation((ComponentOrientation)event.getNewValue());
                }
            } else if ("dropLocation".equals(changeName)) {
                JTable.DropLocation oldValue = (JTable.DropLocation)event.getOldValue();
                this.repaintDropLocation(oldValue);
                this.repaintDropLocation(TableUIBridge.this.table.getDropLocation());
            } else if ("Table.isFileList".equals(changeName)) {
                TableUIBridge.this.isFileList = Boolean.TRUE.equals(TableUIBridge.this.table.getClientProperty("Table.isFileList"));
                TableUIBridge.this.table.revalidate();
                TableUIBridge.this.table.repaint();
                if (TableUIBridge.this.isFileList) {
                    TableUIBridge.this.table.getSelectionModel().addListSelectionListener(TableUIBridge.this.getHandler());
                } else {
                    TableUIBridge.this.table.getSelectionModel().removeListSelectionListener(TableUIBridge.this.getHandler());
                    this.timer = null;
                }
            } else if ("selectionModel".equals(changeName) && TableUIBridge.this.isFileList) {
                ListSelectionModel old = (ListSelectionModel)event.getOldValue();
                old.removeListSelectionListener(TableUIBridge.this.getHandler());
                TableUIBridge.this.table.getSelectionModel().addListSelectionListener(TableUIBridge.this.getHandler());
            }
        }

        protected void repaintDropLocation(JTable.DropLocation loc) {
            Rectangle rect;
            if (loc == null) {
                return;
            }
            if (!loc.isInsertRow() && !loc.isInsertColumn()) {
                Rectangle rect2 = TableUIBridge.this.table.getCellRect(loc.getRow(), loc.getColumn(), false);
                if (rect2 != null) {
                    TableUIBridge.this.table.repaint(rect2);
                }
                return;
            }
            if (loc.isInsertRow() && (rect = TableUIBridge.this.extendRect(TableUIBridge.this.getHDropLineRect(loc), true)) != null) {
                TableUIBridge.this.table.repaint(rect);
            }
            if (loc.isInsertColumn() && (rect = TableUIBridge.this.extendRect(TableUIBridge.this.getVDropLineRect(loc), false)) != null) {
                TableUIBridge.this.table.repaint(rect);
            }
        }
    }

    static class TableTransferHandler
    extends TransferHandler
    implements UIResource {
        TableTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof JTable) {
                int[] cols;
                int counter;
                int[] rows;
                JTable table = (JTable)c;
                if (!table.getRowSelectionAllowed() && !table.getColumnSelectionAllowed()) {
                    return null;
                }
                if (!table.getRowSelectionAllowed()) {
                    int rowCount = table.getRowCount();
                    rows = new int[rowCount];
                    for (counter = 0; counter < rowCount; ++counter) {
                        rows[counter] = counter;
                    }
                } else {
                    rows = table.getSelectedRows();
                }
                if (!table.getColumnSelectionAllowed()) {
                    int colCount = table.getColumnCount();
                    cols = new int[colCount];
                    for (counter = 0; counter < colCount; ++counter) {
                        cols[counter] = counter;
                    }
                } else {
                    cols = table.getSelectedColumns();
                }
                if (rows == null || cols == null || rows.length == 0 || cols.length == 0) {
                    return null;
                }
                StringBuilder plainStr = new StringBuilder();
                StringBuilder htmlStr = new StringBuilder();
                htmlStr.append("<html>\n<body>\n<table>\n");
                for (int row = 0; row < rows.length; ++row) {
                    htmlStr.append("<tr>\n");
                    for (int col = 0; col < cols.length; ++col) {
                        Object obj = table.getValueAt(rows[row], cols[col]);
                        String val = obj == null ? "" : obj.toString();
                        plainStr.append(val).append('\t');
                        htmlStr.append("  <td>").append(val).append("</td>\n");
                    }
                    plainStr.deleteCharAt(plainStr.length() - 1).append('\n');
                    htmlStr.append("</tr>\n");
                }
                plainStr.deleteCharAt(plainStr.length() - 1);
                htmlStr.append("</table>\n</body>\n</html>");
                return new BasicTransferable(plainStr.toString(), htmlStr.toString());
            }
            return null;
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        @Override
        public void mouseClicked(MouseEvent e) {
            TableUIBridge.this.getHandler().mouseClicked(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TableUIBridge.this.getHandler().mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TableUIBridge.this.getHandler().mouseReleased(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            TableUIBridge.this.getHandler().mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            TableUIBridge.this.getHandler().mouseExited(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            TableUIBridge.this.getHandler().mouseDragged(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            TableUIBridge.this.getHandler().mouseMoved(e);
        }
    }

    public class FocusHandler
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            TableUIBridge.this.getHandler().focusGained(e);
        }

        @Override
        public void focusLost(FocusEvent e) {
            TableUIBridge.this.getHandler().focusLost(e);
        }
    }

    public class KeyHandler
    implements KeyListener {
        @Override
        public void keyTyped(KeyEvent e) {
            TableUIBridge.this.getHandler().keyTyped(e);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TableUIBridge.this.getHandler().keyPressed(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            TableUIBridge.this.getHandler().keyReleased(e);
        }
    }
}

