/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table;

import com.github.weisj.darklaf.ui.table.DarkTableBorder;
import com.github.weisj.darklaf.ui.table.DarkTableHeaderUIBridge;
import com.github.weisj.darklaf.ui.table.DarkTableUI;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.GraphicsContext;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DarkTableHeaderUI
extends DarkTableHeaderUIBridge {
    private static final int HEADER_HEIGHT = 26;
    protected Color borderColor;
    protected Color background;

    public static ComponentUI createUI(JComponent c) {
        return new DarkTableHeaderUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        Dimension dim = this.header.getPreferredSize();
        int headerHeight = UIManager.getInt("TableHeader.height");
        if (headerHeight < 0) {
            headerHeight = 26;
        }
        this.header.setPreferredSize(new Dimension(dim.width, Math.max(dim.height, headerHeight)));
        TableCellRenderer defaultRenderer = this.header.getDefaultRenderer();
        if (defaultRenderer instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)this.header.getDefaultRenderer();
            renderer.setHorizontalAlignment(10);
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.background = UIManager.getColor("TableHeader.background");
        this.borderColor = UIManager.getColor("TableHeader.borderColor");
        LookAndFeel.installBorder(this.header, "TableHeader.border");
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (this.header.getBorder() instanceof UIResource) {
            LookAndFeel.uninstallBorder(this.header);
        }
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        int column;
        Graphics2D g = (Graphics2D)g2;
        GraphicsContext config = new GraphicsContext(g);
        int h = c.getHeight();
        int w = c.getWidth();
        g.setColor(this.getHeaderBackground());
        g.fillRect(0, 0, w, h);
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Rectangle clip = g.getClipBounds();
        Point left = clip.getLocation();
        Point right = new Point(clip.x + clip.width - 1, clip.y);
        TableColumnModel cm = this.header.getColumnModel();
        int cMin = this.header.columnAtPoint(ltr ? left : right);
        int cMax = this.header.columnAtPoint(ltr ? right : left);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
        }
        Color borderColor = c.getBorder() instanceof DarkTableBorder ? ((DarkTableBorder)c.getBorder()).getBorderColor() : this.getBorderColor();
        g.setColor(borderColor);
        TableColumn draggedColumn = this.header.getDraggedColumn();
        Rectangle cellRect = this.header.getHeaderRect(ltr ? cMin : cMax);
        if (ltr) {
            for (column = cMin; column <= cMax; ++column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column);
                }
                cellRect.x += columnWidth;
                if (column == cMax) continue;
                g.setColor(borderColor);
                g.fillRect(cellRect.x - 1, 0, 1, h);
            }
        } else {
            for (column = cMax; column >= cMin; --column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column);
                }
                cellRect.x += columnWidth;
                if (column == cMin) continue;
                g.setColor(borderColor);
                g.fillRect(cellRect.x - 1, 0, 1, h);
            }
        }
        if (draggedColumn != null) {
            boolean onRightEdge;
            boolean onLeftEdge;
            int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
            boolean scrollPaneRtl = this.isScrollPaneRtl();
            Rectangle draggedCellRect = this.header.getHeaderRect(draggedColumnIndex);
            int dist = DarkTableUI.adjustDistance(this.header.getDraggedDistance(), draggedCellRect, this.header.getTable());
            g.setColor(this.header.getParent().getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            g.setColor(borderColor);
            if (this.scrollBarVisible()) {
                if (ltr) {
                    if (!scrollPaneRtl) {
                        g.fillRect(draggedCellRect.x + draggedCellRect.width - 1, draggedCellRect.y, 1, draggedCellRect.height);
                    } else {
                        if (draggedColumnIndex != cMax) {
                            g.fillRect(draggedCellRect.x + draggedCellRect.width - 1, draggedCellRect.y, 1, draggedCellRect.height);
                        } else {
                            g.fillRect(draggedCellRect.x + draggedCellRect.width, draggedCellRect.y, 1, draggedCellRect.height);
                        }
                        if (draggedColumnIndex == cMin) {
                            g.fillRect(draggedCellRect.x, draggedCellRect.y, 1, draggedCellRect.height);
                        }
                    }
                } else if (!scrollPaneRtl) {
                    g.fillRect(draggedCellRect.x + draggedCellRect.width - 1, draggedCellRect.y, 1, draggedCellRect.height);
                } else {
                    if (draggedColumnIndex != cMin) {
                        g.fillRect(draggedCellRect.x + draggedCellRect.width - 1, draggedCellRect.y, 1, draggedCellRect.height);
                    }
                    if (draggedColumnIndex == cMax) {
                        g.fillRect(draggedCellRect.x, draggedCellRect.y, 1, draggedCellRect.height);
                    }
                }
            } else if (ltr) {
                if (draggedColumnIndex != cMax) {
                    g.fillRect(draggedCellRect.x + draggedCellRect.width - 1, draggedCellRect.y, 1, draggedCellRect.height);
                } else {
                    g.fillRect(draggedCellRect.x + draggedCellRect.width, draggedCellRect.y, 1, draggedCellRect.height);
                }
            } else if (draggedColumnIndex != cMin) {
                g.fillRect(draggedCellRect.x + draggedCellRect.width - 1, draggedCellRect.y, 1, draggedCellRect.height);
            }
            draggedCellRect.x += dist;
            g.setColor(this.header.getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            this.paintCell(g, draggedCellRect, draggedColumnIndex);
            g.setColor(borderColor);
            boolean bl = ltr ? draggedColumnIndex == cMin : (onLeftEdge = draggedColumnIndex == cMax);
            boolean bl2 = ltr ? draggedColumnIndex == cMax : (onRightEdge = draggedColumnIndex == cMin);
            if (dist != 0 || !onLeftEdge) {
                g.fillRect(draggedCellRect.x - 1, draggedCellRect.y, 1, draggedCellRect.height);
            }
            if (dist != 0 || !onRightEdge) {
                g.fillRect(draggedCellRect.x + draggedCellRect.width - 1, draggedCellRect.y, 1, draggedCellRect.height);
            }
        }
        this.rendererPane.removeAll();
        config.restore();
    }

    protected Color getHeaderBackground() {
        return this.background;
    }

    protected Color getBorderColor() {
        return this.borderColor;
    }

    protected boolean isScrollPaneRtl() {
        if (!this.isInScrollPane()) {
            return false;
        }
        Container comp = DarkUIUtil.getUnwrappedParent(this.header).getParent();
        return !comp.getComponentOrientation().isLeftToRight();
    }

    protected boolean scrollBarVisible() {
        Container comp = DarkUIUtil.getUnwrappedParent(this.header);
        if (comp != null) {
            comp = comp.getParent();
        }
        return comp instanceof JScrollPane && ((JScrollPane)comp).getVerticalScrollBar().isVisible();
    }

    protected boolean isInScrollPane() {
        Container comp = DarkUIUtil.getUnwrappedParent(this.header);
        if (comp != null) {
            comp = comp.getParent();
        }
        return comp instanceof JScrollPane;
    }
}

