/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table;

import com.github.weisj.darklaf.ui.cell.DarkCellBorder;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class DarkTableCellFocusBorder
extends DarkCellBorder {
    protected Color rowBorderColor = UIManager.getColor("Table.focusRowBorderColor");
    protected Color borderColor = UIManager.getColor("Table.focusBorderColor");

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        super.paintBorder(c, g, x, y, width, height);
        if (DarkTableCellFocusBorder.isRowFocusBorder(c)) {
            g.setColor(this.rowBorderColor);
            g.fillRect(0, 0, width, 1);
            g.fillRect(0, height - 1, width, 1);
            if (DarkTableCellFocusBorder.forcePaintLeft(c)) {
                g.fillRect(0, 0, 1, height);
            }
            if (DarkTableCellFocusBorder.forcePaintRight(c)) {
                g.fillRect(width - 1, 0, 1, height);
            }
        } else {
            g.setColor(this.borderColor);
            DarkUIUtil.drawRect(g, 0, 0, width, height, 1);
        }
    }

    public static boolean isRowFocusBorder(Component c) {
        return c instanceof JComponent && Boolean.TRUE.equals(((JComponent)c).getClientProperty("JTable.rowFocusBorder"));
    }

    protected static boolean forcePaintLeft(Component c) {
        return c instanceof JComponent && Boolean.TRUE.equals(((JComponent)c).getClientProperty("JTable.forcePaintLeft"));
    }

    protected static boolean forcePaintRight(Component c) {
        return c instanceof JComponent && Boolean.TRUE.equals(((JComponent)c).getClientProperty("JTable.forcePaintRight"));
    }
}

