/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabbedpane;

import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUIBridge;
import com.github.weisj.darklaf.ui.tabbedpane.TabbedPaneLayout;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;

abstract class TabbedPaneScrollLayout
extends TabbedPaneLayout {
    public TabbedPaneScrollLayout(DarkTabbedPaneUIBridge ui) {
        super(ui);
    }

    @Override
    protected void calculateTabRects(int tabPlacement, int tabCount) {
        int i;
        FontMetrics metrics = this.ui.getFontMetrics();
        Dimension size = this.ui.tabPane.getSize();
        Insets insets = this.ui.tabPane.getInsets();
        Insets tabAreaInsets = this.ui.getTabAreaInsets(tabPlacement);
        int fontHeight = metrics.getHeight();
        int selectedIndex = this.ui.tabPane.getSelectedIndex();
        boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
        boolean leftToRight = this.ui.tabPane.getComponentOrientation().isLeftToRight();
        int x = tabAreaInsets.left;
        int y = tabAreaInsets.top;
        int totalWidth = 0;
        int totalHeight = 0;
        switch (tabPlacement) {
            case 2: 
            case 4: {
                this.ui.maxTabWidth = this.ui.calculateMaxTabWidth(tabPlacement);
                break;
            }
            default: {
                this.ui.maxTabHeight = this.ui.calculateMaxTabHeight(tabPlacement);
            }
        }
        this.ui.runCount = 0;
        this.ui.selectedRun = -1;
        if (tabCount == 0) {
            return;
        }
        this.ui.selectedRun = 0;
        this.ui.runCount = 1;
        for (i = 0; i < tabCount; ++i) {
            Rectangle rect = this.ui.rects[i];
            if (!verticalTabRuns) {
                if (i > 0) {
                    rect.x = this.ui.rects[i - 1].x + this.ui.rects[i - 1].width;
                } else {
                    this.ui.tabRuns[0] = 0;
                    this.ui.maxTabWidth = 0;
                    totalHeight += this.ui.maxTabHeight;
                    rect.x = x;
                }
                rect.width = this.ui.calculateTabWidth(tabPlacement, i, metrics);
                totalWidth = rect.x + rect.width;
                this.ui.maxTabWidth = Math.max(this.ui.maxTabWidth, rect.width);
                rect.y = y;
                rect.height = this.ui.maxTabHeight;
                continue;
            }
            if (i > 0) {
                rect.y = this.ui.rects[i - 1].y + this.ui.rects[i - 1].height;
            } else {
                this.ui.tabRuns[0] = 0;
                this.ui.maxTabHeight = 0;
                totalWidth = this.ui.maxTabWidth;
                rect.y = y;
            }
            rect.height = this.ui.calculateTabHeight(tabPlacement, i, fontHeight);
            totalHeight = rect.y + rect.height;
            this.ui.maxTabHeight = Math.max(this.ui.maxTabHeight, rect.height);
            rect.x = x;
            rect.width = this.ui.maxTabWidth;
        }
        if (this.ui.tabsOverlapBorder) {
            this.padSelectedTab(tabPlacement, selectedIndex);
        }
        if (!leftToRight && !verticalTabRuns) {
            int rightMargin = size.width - (insets.right + tabAreaInsets.right);
            for (i = 0; i < tabCount; ++i) {
                this.ui.rects[i].x = rightMargin - this.ui.rects[i].x - this.ui.rects[i].width;
            }
        }
        this.ui.tabScroller.tabPanel.setPreferredSize(new Dimension(totalWidth, totalHeight));
    }

    @Override
    protected int preferredTabAreaWidth(int tabPlacement, int height) {
        return this.ui.calculateMaxTabWidth(tabPlacement);
    }

    @Override
    protected int preferredTabAreaHeight(int tabPlacement, int width) {
        return this.ui.calculateMaxTabHeight(tabPlacement);
    }
}

