/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.splitpane;

import com.github.weisj.darklaf.decorators.LayoutManagerDelegate;
import com.github.weisj.darklaf.ui.splitpane.DarkSplitPaneDivider;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class DarkSplitPaneUI
extends BasicSplitPaneUI
implements PropertyChangeListener {
    protected static final String KEY_PREFIX = "JSplitPane.";
    public static final String KEY_STYLE = "JSplitPane.style";
    public static final String STYLE_GRIP = "grip";
    public static final String STYLE_LINE = "line";
    public static final String STYLE_INVISIBLE = "invisible";
    private static final int DIVIDER_DRAG_SIZE = 10;
    private static final int DIVIDER_DRAG_OFFSET = 5;
    private Style style;
    private Color dividerLine;

    protected DarkSplitPaneUI(Style style) {
        this.style = style;
    }

    public static ComponentUI createUI(JComponent c) {
        return new DarkSplitPaneUI(Style.get(UIManager.getString("SplitPane.defaultDividerStyle")));
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setComponentZOrder(this.getDivider(), 0);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.dividerLine = UIManager.getColor("SplitPane.dividerLineColor");
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.splitPane.addPropertyChangeListener(this);
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (this.splitPane.getLayout() instanceof LayoutManagerDelegate) {
            this.splitPane.setLayout(null);
        }
        super.uninstallUI(c);
        this.divider = null;
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.splitPane.removePropertyChangeListener(this);
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        if (this.style == Style.GRIP) {
            return new DarkSplitPaneDivider(this);
        }
        return new ThinDivider(this);
    }

    @Override
    protected void resetLayoutManager() {
        super.resetLayoutManager();
        this.splitPane.setLayout(new LayoutManagerDelegate(this.splitPane.getLayout()){

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                if (DarkSplitPaneUI.this.style != Style.GRIP) {
                    Rectangle bounds = DarkSplitPaneUI.this.getDivider().getBounds();
                    if (DarkSplitPaneUI.this.getOrientation() == 1) {
                        bounds.x -= 5;
                        bounds.width = 10;
                    } else {
                        bounds.y -= 5;
                        bounds.height = 10;
                    }
                    DarkSplitPaneUI.this.getDivider().setBounds(bounds);
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if (KEY_STYLE.equals(key)) {
            Object val = evt.getNewValue();
            Style oldStyle = this.style;
            this.style = Style.INVISIBLE.name.equals(val) ? Style.INVISIBLE : (Style.LINE.name.equals(val) ? Style.LINE : Style.GRIP);
            if (oldStyle != this.style) {
                if (this.style == Style.GRIP || oldStyle == Style.GRIP) {
                    this.splitPane.setUI(new DarkSplitPaneUI(this.style));
                } else {
                    this.splitPane.doLayout();
                }
            }
        } else if ("orientation".equals(key)) {
            this.splitPane.doLayout();
        }
    }

    protected Color getDividerLineColor() {
        return this.dividerLine;
    }

    private static enum Style {
        GRIP("grip"),
        LINE("line"),
        INVISIBLE("invisible");

        private final String name;

        private Style(String name) {
            this.name = name;
        }

        static Style get(String style) {
            try {
                return Style.valueOf(style.toLowerCase());
            }
            catch (IllegalArgumentException e) {
                return GRIP;
            }
        }
    }

    private final class ThinDivider
    extends BasicSplitPaneDivider {
        private ThinDivider(BasicSplitPaneUI ui) {
            super(ui);
        }

        @Override
        public int getDividerSize() {
            return DarkSplitPaneUI.this.style == Style.LINE ? 1 : 0;
        }

        @Override
        public void paint(Graphics g) {
            if (DarkSplitPaneUI.this.style == Style.LINE) {
                g.setColor(DarkSplitPaneUI.this.getDividerLineColor());
                if (this.orientation == 1) {
                    g.drawLine(5, 0, 5, this.getHeight());
                } else {
                    g.drawLine(0, 5, this.getWidth(), 5);
                }
            }
        }

        @Override
        public boolean contains(Point p) {
            if (!this.isEnabled()) {
                return false;
            }
            return super.contains(p);
        }

        @Override
        protected void dragDividerTo(int location) {
            super.dragDividerTo(location + 5);
        }

        @Override
        protected void finishDraggingTo(int location) {
            super.finishDraggingTo(location + 5);
        }
    }
}

