/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.spinner;

import com.github.weisj.darklaf.components.ArrowButton;
import com.github.weisj.darklaf.decorators.LayoutManagerDelegate;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class DarkSpinnerUI
extends BasicSpinnerUI
implements PropertyChangeListener {
    protected static final String KEY_PREFIX = "JSpinner.";
    public static final String KEY_VARIANT = "JSpinner.variant";
    public static final String KEY_IS_TREE_EDITOR = "JSpinner.isTreeCellEditor";
    public static final String KEY_IS_TREE_RENDER = "JSpinner.isTreeCellRenderer";
    public static final String KEY_IS_TABLE_EDITOR = "JSpinner.isTableCellEditor";
    public static final String KEY_IS_TABLE_RENDERER = "JSpinner.isTableCellRenderer";
    public static final String KEY_EDITOR_ALIGNMENT = "JSpinner.cellEditorAlignment";
    public static final String VARIANT_PLUS_MINUS = "plusMinus";
    private final FocusListener focusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            DarkSpinnerUI.this.spinner.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            DarkSpinnerUI.this.spinner.repaint();
        }
    };
    private final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            DarkSpinnerUI.this.spinner.getEditor().requestFocus();
        }
    };
    protected Color arrowBackground;
    protected Color background;
    protected Color arrowBackgroundEnd;
    protected Icon arrowDownIcon;
    protected Color inactiveBackground;
    protected int arc;
    protected int borderSize;
    protected Icon arrowUpIcon;
    protected Icon plusIcon;
    protected Icon minusIcon;
    protected Icon arrowDownInactiveIcon;
    protected Icon arrowUpInactiveIcon;
    protected Icon plusInactiveIcon;
    protected Icon minusInactiveIcon;
    private JComponent editor;
    private JButton prevButton;
    private Component editorComponent;
    private JButton nextButton;

    public static ComponentUI createUI(JComponent c) {
        return new DarkSpinnerUI();
    }

    protected static boolean usePlusMinusIcons(JSpinner spinner) {
        return VARIANT_PLUS_MINUS.equals(spinner.getClientProperty(KEY_VARIANT));
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.spinner.addMouseListener(this.mouseListener);
        this.spinner.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.editor != null && this.editor.getComponents().length > 0) {
            this.editor.getComponents()[0].removeFocusListener(this.focusListener);
        }
        this.spinner.removeMouseListener(this.mouseListener);
        this.spinner.removePropertyChangeListener(this);
    }

    protected static boolean isTableCellEditor(Component c) {
        return c instanceof JComponent && Boolean.TRUE.equals(((JComponent)c).getClientProperty(KEY_IS_TABLE_EDITOR));
    }

    @Override
    protected LayoutManager createLayout() {
        return new LayoutManagerDelegate(super.createLayout()){
            private Component editor;
            {
                this.editor = null;
            }

            @Override
            public void addLayoutComponent(String name, Component comp) {
                super.addLayoutComponent(name, comp);
                if ("Editor".equals(name)) {
                    this.editor = comp;
                }
            }

            protected void adjustButton(JComponent button, int adj) {
                Rectangle bounds = button.getBounds();
                bounds.x += adj;
                button.setBounds(bounds);
            }

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                if (DarkSpinnerUI.isTableCellEditor(DarkSpinnerUI.this.spinner) || DarkSpinnerUI.isTreeCellEditor(DarkSpinnerUI.this.spinner)) {
                    int adj = DarkSpinnerUI.this.borderSize / 2;
                    if (!DarkSpinnerUI.this.spinner.getComponentOrientation().isLeftToRight()) {
                        adj *= -1;
                    }
                    this.adjustButton(DarkSpinnerUI.this.prevButton, adj);
                    this.adjustButton(DarkSpinnerUI.this.nextButton, adj);
                }
                if (this.editor != null && !DarkSpinnerUI.this.spinner.getComponentOrientation().isLeftToRight()) {
                    Rectangle bounds = this.editor.getBounds();
                    bounds.x += DarkSpinnerUI.this.borderSize;
                    bounds.width -= DarkSpinnerUI.this.borderSize;
                    this.editor.setBounds(bounds);
                }
            }
        };
    }

    @Override
    protected Component createPreviousButton() {
        this.prevButton = this.createArrow(5);
        this.prevButton.setName("Spinner.previousButton");
        this.prevButton.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.prevButton.setCursor(Cursor.getPredefinedCursor(12));
        this.installPreviousButtonListeners(this.prevButton);
        return this.prevButton;
    }

    @Override
    protected Component createNextButton() {
        this.nextButton = this.createArrow(1);
        this.nextButton.setName("Spinner.nextButton");
        this.nextButton.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.nextButton.setCursor(Cursor.getPredefinedCursor(12));
        this.installNextButtonListeners(this.nextButton);
        return this.nextButton;
    }

    @Override
    protected JComponent createEditor() {
        this.editor = super.createEditor();
        this.editorComponent = this.editor instanceof JSpinner.DefaultEditor ? ((JSpinner.DefaultEditor)this.editor).getTextField() : this.editor;
        this.editorComponent.addFocusListener(this.focusListener);
        return this.editor;
    }

    @Override
    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        super.replaceEditor(oldEditor, newEditor);
        this.editor = newEditor;
        if (oldEditor != null && oldEditor.getComponents().length > 0) {
            oldEditor.getComponents()[0].removeFocusListener(this.focusListener);
        }
        this.editor = newEditor;
        if (oldEditor != null && oldEditor.getComponents().length > 0) {
            oldEditor.getComponents()[0].removeFocusListener(this.focusListener);
        }
        if (newEditor != null && newEditor.getComponents().length > 0) {
            Component comp = newEditor.getComponents()[0];
            comp.addFocusListener(this.focusListener);
        }
    }

    private JButton createArrow(int direction) {
        int buttonPad = UIManager.getInt("Spinner.buttonPad");
        Insets insets = new Insets(0, buttonPad, 0, buttonPad);
        JButton button = ArrowButton.createUpDownArrow(this.spinner, this.getArrowIcon(direction), this.getArrowInactiveIcon(direction), direction, false, true, insets);
        Border buttonBorder = UIManager.getBorder("Spinner.arrowButtonBorder");
        if (buttonBorder instanceof UIResource) {
            button.setBorder(new CompoundBorder(buttonBorder, null));
        } else {
            button.setBorder(buttonBorder);
        }
        button.setInheritsPopupMenu(true);
        return button;
    }

    protected SpinnerIcon getArrowIcon(int direction) {
        if (direction == 5) {
            return new SpinnerIcon(this.spinner, this.arrowDownIcon, this.minusIcon);
        }
        return new SpinnerIcon(this.spinner, this.arrowUpIcon, this.plusIcon);
    }

    protected SpinnerIcon getArrowInactiveIcon(int direction) {
        if (direction == 5) {
            return new SpinnerIcon(this.spinner, this.arrowDownInactiveIcon, this.minusInactiveIcon);
        }
        return new SpinnerIcon(this.spinner, this.arrowUpInactiveIcon, this.plusInactiveIcon);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int size = this.borderSize;
        int width = c.getWidth();
        int height = c.getHeight();
        JComponent editor = this.spinner.getEditor();
        if (this.editorComponent != null) {
            this.editorComponent.setBackground(this.getBackground(c));
            g.setColor(this.editorComponent.getBackground());
        } else {
            ((Graphics2D)g).setPaint(this.getBackground(c));
        }
        if (!DarkSpinnerUI.isTableCellEditor(c) && !DarkSpinnerUI.isTreeCellEditor(c)) {
            DarkUIUtil.fillRoundRect((Graphics2D)g, size, size, width - 2 * size, height - 2 * size, this.arc);
        } else {
            int off;
            Rectangle bounds = this.prevButton.getBounds();
            boolean leftToRight = this.spinner.getComponentOrientation().isLeftToRight();
            int n = off = leftToRight ? bounds.x + 1 : bounds.x + bounds.width;
            if (leftToRight) {
                g.fillRect(0, 0, off, height);
            } else {
                g.fillRect(off, 0, width - off, height);
            }
        }
        if (editor != null) {
            this.paintSpinBackground((Graphics2D)g, width, height, size, this.arc);
        }
    }

    protected Color getBackground(JComponent c) {
        return c == null || !c.isEnabled() ? this.inactiveBackground : this.background;
    }

    protected static boolean isTreeCellEditor(Component c) {
        return c instanceof JComponent && Boolean.TRUE.equals(((JComponent)c).getClientProperty(KEY_IS_TREE_EDITOR));
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.arc = UIManager.getInt("Spinner.arc");
        this.borderSize = UIManager.getInt("Spinner.borderThickness");
        this.background = UIManager.getColor("Spinner.activeBackground");
        this.inactiveBackground = UIManager.getColor("Spinner.inactiveBackground");
        this.arrowBackground = UIManager.getColor("Spinner.arrowBackground");
        this.arrowDownIcon = UIManager.getIcon("Spinner.arrowDown.icon");
        this.arrowUpIcon = UIManager.getIcon("Spinner.arrowUp.icon");
        this.minusIcon = UIManager.getIcon("Spinner.minus.icon");
        this.plusIcon = UIManager.getIcon("Spinner.plus.icon");
        this.arrowDownInactiveIcon = UIManager.getIcon("Spinner.arrowDownInactive.icon");
        this.arrowUpInactiveIcon = UIManager.getIcon("Spinner.arrowUpInactive.icon");
        this.minusInactiveIcon = UIManager.getIcon("Spinner.minusInactive.icon");
        this.plusInactiveIcon = UIManager.getIcon("Spinner.plusInactive.icon");
        LookAndFeel.installProperty(this.spinner, "opaque", false);
    }

    private void paintSpinBackground(Graphics2D g, int width, int height, int bSize, int arc) {
        Rectangle bounds = this.prevButton.getBounds();
        boolean leftToRight = this.spinner.getComponentOrientation().isLeftToRight();
        int off = leftToRight ? bounds.x : bounds.x + bounds.width;
        Area rect = !DarkSpinnerUI.isTableCellEditor(this.spinner) && !DarkSpinnerUI.isTreeCellEditor(this.spinner) ? new Area(new RoundRectangle2D.Double(bSize - 1, bSize - 1, width - 2 * bSize + 1, height - 2 * bSize + 1, arc, arc)) : new Area(new Rectangle(0, 0, width, height));
        Area iconRect = new Area(new Rectangle(off, 0, width, height));
        if (leftToRight) {
            rect.intersect(iconRect);
        } else {
            rect.subtract(iconRect);
        }
        g.setPaint(this.getArrowBackground(this.spinner));
        g.fill(rect);
    }

    protected Paint getArrowBackground(JComponent c) {
        return c == null || !c.isEnabled() ? this.inactiveBackground : this.arrowBackground;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if ("opaque".equals(key)) {
            boolean val = Boolean.TRUE.equals(evt.getNewValue());
            this.spinner.getEditor().setOpaque(val);
            if (this.editorComponent instanceof JComponent) {
                ((JComponent)this.editorComponent).setOpaque(val);
            }
        } else if (KEY_IS_TABLE_EDITOR.equals(key)) {
            if (Boolean.FALSE.equals(evt.getNewValue()) && this.editor instanceof JSpinner.DefaultEditor) {
                int alignment = UIManager.getInt("Spinner.editorAlignment");
                JFormattedTextField text = ((JSpinner.DefaultEditor)this.editor).getTextField();
                text.setHorizontalAlignment(alignment);
            }
            this.spinner.revalidate();
            this.spinner.repaint();
        } else if (KEY_EDITOR_ALIGNMENT.equals(key) && DarkSpinnerUI.isTableCellEditor(this.spinner)) {
            if (this.editorComponent instanceof JTextField && evt.getNewValue() instanceof Integer) {
                ((JTextField)this.editorComponent).setHorizontalAlignment((Integer)evt.getNewValue());
            }
            this.spinner.revalidate();
        } else if (KEY_VARIANT.equals(key)) {
            this.spinner.repaint();
        } else if (KEY_IS_TREE_EDITOR.equals(key)) {
            this.spinner.revalidate();
            this.spinner.repaint();
        }
    }

    protected static class SpinnerIcon
    implements Icon {
        private final JSpinner spinner;
        private final Icon icon;
        private final Icon mathIcon;

        public SpinnerIcon(JSpinner spinner, Icon icon, Icon mathIcon) {
            this.spinner = spinner;
            this.icon = icon;
            this.mathIcon = mathIcon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.getCurrent().paintIcon(c, g, x, y);
        }

        protected Icon getCurrent() {
            return DarkSpinnerUI.usePlusMinusIcons(this.spinner) ? this.mathIcon : this.icon;
        }

        @Override
        public int getIconWidth() {
            return this.getCurrent().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getCurrent().getIconHeight();
        }
    }
}

