/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.radiobutton;

import com.github.weisj.darklaf.icons.EmptyIcon;
import com.github.weisj.darklaf.ui.checkbox.DarkCheckBoxUI;
import com.github.weisj.darklaf.ui.radiobutton.DarkRadioButtonBorder;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.GraphicsContext;
import com.github.weisj.darklaf.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.metal.MetalRadioButtonUI;
import sun.swing.SwingUtilities2;

public class DarkRadioButtonUI
extends MetalRadioButtonUI
implements PropertyChangeListener {
    private static final int ICON_OFF = 4;
    private static final int SIZE = 13;
    private static final int BULLET_RAD = 5;
    private static final Rectangle viewRect = new Rectangle();
    private static final Rectangle iconRect = new Rectangle();
    private static final Rectangle textRect = new Rectangle();
    private static Dimension size = new Dimension();
    private RectangularShape hitArea;
    protected JRadioButton radioButton;
    protected Color background;
    protected Color inactiveBackground;
    protected Color focusBorderColor;
    protected Color focusSelectedBorderColor;
    protected Color borderColor;
    protected Color inactiveBorderColor;
    protected Color checkColor;
    protected Color inactiveCheckColor;
    protected Color focusCheckColor;
    protected Color selectedBorderColor;
    protected Color selectedBackground;
    private Icon radioIcon;
    private Icon radioDisabledIcon;
    private Icon radioFocusedIcon;
    private Icon radioSelectedIcon;
    private Icon radioSelectedDisabledIcon;
    private Icon radioSelectedFocusedIcon;

    public static ComponentUI createUI(JComponent c) {
        return new DarkRadioButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.radioButton = (JRadioButton)c;
        super.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.radioButton = null;
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        LookAndFeel.installProperty(b, "opaque", false);
        this.radioIcon = UIManager.getIcon("RadioButton.unchecked.icon");
        this.radioDisabledIcon = UIManager.getIcon("RadioButton.uncheckedDisabled.icon");
        this.radioFocusedIcon = UIManager.getIcon("RadioButton.uncheckedFocused.icon");
        this.radioSelectedIcon = UIManager.getIcon("RadioButton.selected.icon");
        this.radioSelectedDisabledIcon = UIManager.getIcon("RadioButton.selectedDisabled.icon");
        this.radioSelectedFocusedIcon = UIManager.getIcon("RadioButton.selectedFocused.icon");
        this.background = UIManager.getColor("RadioButton.activeFillColor");
        this.inactiveBackground = UIManager.getColor("RadioButton.inactiveFillColor");
        this.focusBorderColor = UIManager.getColor("RadioButton.focusBorderColor");
        this.borderColor = UIManager.getColor("RadioButton.activeBorderColor");
        this.inactiveBorderColor = UIManager.getColor("RadioButton.inactiveBorderColor");
        this.checkColor = UIManager.getColor("RadioButton.selectionSelectedColor");
        this.inactiveCheckColor = UIManager.getColor("RadioButton.selectionDisabledColor");
        this.focusCheckColor = UIManager.getColor("RadioButton.selectionFocusSelectedColor");
        this.selectedBorderColor = UIManager.getColor("RadioButton.selectedBorderColor");
        this.selectedBackground = UIManager.getColor("RadioButton.selectedFillColor");
        this.focusSelectedBorderColor = UIManager.getColor("RadioButton.focusSelectedBorderColor");
    }

    @Override
    public synchronized void paint(Graphics g2d, JComponent c) {
        Graphics2D g = (Graphics2D)g2d;
        AbstractButton b = (AbstractButton)c;
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g, f);
        String text = this.layoutRadioButton(b, fm);
        this.paintBackground(c, g);
        GraphicsContext config = GraphicsUtil.setupStrokePainting(g);
        Icon icon = DarkCheckBoxUI.getIconBullet(c, g, b);
        if (icon != null) {
            icon.paintIcon(c, g, DarkRadioButtonUI.iconRect.x, DarkRadioButtonUI.iconRect.y);
        } else {
            Icon radioIcon = this.getRadioIcon(b);
            if (radioIcon != null) {
                radioIcon.paintIcon(c, g, DarkRadioButtonUI.iconRect.x, DarkRadioButtonUI.iconRect.y + 1);
            } else {
                this.paintDarkBullet(c, g, b);
            }
        }
        config.restore();
        if (text != null) {
            DarkCheckBoxUI.paintText(g, b, textRect, text, fm, this.getDisabledTextColor());
        }
    }

    @Override
    protected void installListeners(AbstractButton button) {
        super.installListeners(button);
        button.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(AbstractButton button) {
        super.uninstallListeners(button);
        button.removePropertyChangeListener(this);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        if (this.hitArea == null || this.hitArea.isEmpty() && c instanceof JRadioButton) {
            this.layoutRadioButton((JRadioButton)c, c.getFontMetrics(c.getFont()));
        }
        return this.hitArea.contains(x, y);
    }

    private void paintBackground(JComponent c, Graphics2D g) {
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
    }

    protected Icon getRadioIcon(AbstractButton b) {
        boolean selected = b.isSelected();
        boolean enabled = b.isEnabled();
        boolean hasFocus = b.hasFocus();
        return selected ? (enabled ? (hasFocus ? this.radioSelectedFocusedIcon : this.radioSelectedIcon) : this.radioSelectedDisabledIcon) : (enabled ? (hasFocus ? this.radioFocusedIcon : this.radioIcon) : this.radioDisabledIcon);
    }

    protected void paintDarkBullet(JComponent c, Graphics2D g, AbstractButton b) {
        GraphicsContext config = GraphicsUtil.setupStrokePainting(g);
        boolean enabled = b.isEnabled();
        g.translate(DarkRadioButtonUI.iconRect.x + 4, DarkRadioButtonUI.iconRect.y + 4);
        g.translate(-0.25, 0.0);
        this.paintCheckBorder(g, enabled, b.hasFocus() && b.isFocusPainted(), b.isSelected());
        if (b.isSelected()) {
            this.paintCheckBullet(g, enabled, b.hasFocus() && b.isFocusPainted());
        }
        g.translate(0.25, 0.0);
        g.translate(-DarkRadioButtonUI.iconRect.x - 4, -DarkRadioButtonUI.iconRect.y - 4);
        config.restore();
    }

    @Override
    public Icon getDefaultIcon() {
        return new IconUIResource(EmptyIcon.create(20));
    }

    protected void paintCheckBorder(Graphics2D g, boolean enabled, boolean focus, boolean selected) {
        Graphics2D g2 = (Graphics2D)g.create();
        Color bgColor = this.getFillColor(selected, enabled);
        Color border = this.getBorderColor(selected, focus, enabled);
        g.setColor(bgColor);
        g.fillOval(0, 0, 13, 13);
        if (focus) {
            g2.translate(-0.2, -0.2);
            DarkUIUtil.paintFocusOval(g2, 1, 1, 12, 12);
        }
        g.setColor(border);
        g.drawOval(0, 0, 13, 13);
        g2.dispose();
    }

    protected void paintCheckBullet(Graphics2D g, boolean enabled, boolean focus) {
        Color color = this.getCheckColor(focus, enabled);
        g.setColor(color);
        g.translate(0.2, 0.2);
        g.fillOval(4, 4, 5, 5);
        g.translate(-0.2, -0.2);
    }

    protected Color getFillColor(boolean selected, boolean enabled) {
        return enabled ? (selected ? this.selectedBackground : this.background) : this.inactiveBorderColor;
    }

    protected Color getBorderColor(boolean selected, boolean focus, boolean enabled) {
        return enabled ? (focus ? (selected ? this.focusSelectedBorderColor : this.focusBorderColor) : (selected ? this.selectedBorderColor : this.borderColor)) : this.inactiveBorderColor;
    }

    protected Color getCheckColor(boolean focus, boolean enabled) {
        return enabled ? (focus ? this.focusCheckColor : this.checkColor) : this.inactiveCheckColor;
    }

    protected String layoutRadioButton(AbstractButton b, FontMetrics fm) {
        Insets i = b.getInsets();
        size = b.getSize(size);
        DarkRadioButtonUI.viewRect.x = i.left;
        DarkRadioButtonUI.viewRect.y = i.top;
        DarkRadioButtonUI.viewRect.width = DarkRadioButtonUI.size.width - (i.right + DarkRadioButtonUI.viewRect.x);
        DarkRadioButtonUI.viewRect.height = DarkRadioButtonUI.size.height - (i.bottom + DarkRadioButtonUI.viewRect.y);
        DarkRadioButtonUI.iconRect.height = 0;
        DarkRadioButtonUI.iconRect.width = 0;
        DarkRadioButtonUI.iconRect.y = 0;
        DarkRadioButtonUI.iconRect.x = 0;
        DarkRadioButtonUI.textRect.height = 0;
        DarkRadioButtonUI.textRect.width = 0;
        DarkRadioButtonUI.textRect.y = 0;
        DarkRadioButtonUI.textRect.x = 0;
        String text = SwingUtilities.layoutCompoundLabel(b, fm, b.getText(), this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
        if (DarkRadioButtonBorder.isTableCellEditor(b) || DarkRadioButtonBorder.isTreeCellEditor(b)) {
            this.hitArea = new Ellipse2D.Float(Math.max(DarkRadioButtonUI.iconRect.x, 0) + 4, Math.max(DarkRadioButtonUI.iconRect.y, 0) + 4, 13.0f, 13.0f);
        } else {
            int x = Math.min(DarkRadioButtonUI.iconRect.x, DarkRadioButtonUI.textRect.x);
            int y = Math.min(DarkRadioButtonUI.iconRect.y, DarkRadioButtonUI.textRect.y);
            int xEnd = Math.max(DarkRadioButtonUI.iconRect.x + DarkRadioButtonUI.iconRect.width, DarkRadioButtonUI.textRect.x + DarkRadioButtonUI.textRect.width);
            int yEnd = Math.max(DarkRadioButtonUI.iconRect.y + DarkRadioButtonUI.iconRect.height, DarkRadioButtonUI.textRect.y + DarkRadioButtonUI.textRect.y);
            this.hitArea = new Rectangle(x, y, xEnd - x, yEnd - y);
        }
        return text;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if ("componentOrientation".equals(key)) {
            this.radioButton.repaint();
        } else if ("JToggleButton.isTreeCellEditor".equals(key) || "JToggleButton.isTableCellEditor".equals(key)) {
            this.radioButton.repaint();
        }
    }
}

