/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.list;

import com.github.weisj.darklaf.ui.list.DarkListCellRenderer;
import com.github.weisj.darklaf.ui.list.DarkListUIBridge;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class DarkListUI
extends DarkListUIBridge {
    protected static final String KEY_PREFIX = "JList.";
    public static final String KEY_ALTERNATE_ROW_COLOR = "JList.alternateRowColor";
    public static final String KEY_RENDER_BOOLEAN_AS_CHECKBOX = "JList.renderBooleanAsCheckBox";
    public static final String KEY_BOOLEAN_RENDER_TYPE = "JList.booleanRenderType";
    public static final String KEY_SHRINK_WRAP = "JList.shrinkWrap";
    public static final String KEY_FULL_ROW_SELECTION = "JList.fullRowSelection";
    public static final String KEY_IS_EDITING = "JList.isEditing";
    public static final String RENDER_TYPE_CHECKBOX = "checkBox";
    public static final String RENDER_TYPE_RADIOBUTTON = "radioButton";

    public static ComponentUI createUI(JComponent list) {
        return new DarkListUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.list.putClientProperty(KEY_ALTERNATE_ROW_COLOR, UIManager.getBoolean("List.alternateRowColor"));
    }

    @Override
    protected DarkListUIBridge.Handler getHandler() {
        if (this.handler == null) {
            this.handler = new DarkHandler();
        }
        return this.handler;
    }

    @Override
    protected void paintImpl(Graphics g, JComponent c) {
        int endColumn;
        int startColumn;
        switch (this.layoutOrientation) {
            case 1: {
                if (this.list.getHeight() == this.listHeight) break;
                this.updateLayoutStateNeeded |= 0x100;
                this.redrawList();
                break;
            }
            case 2: {
                if (this.list.getWidth() == this.listWidth) break;
                this.updateLayoutStateNeeded |= 0x200;
                this.redrawList();
                break;
            }
        }
        this.maybeUpdateLayoutState();
        ListCellRenderer<Object> renderer = this.list.getCellRenderer();
        ListModel<Object> dataModel = this.list.getModel();
        ListSelectionModel selModel = this.list.getSelectionModel();
        if (renderer == null || dataModel.getSize() == 0) {
            return;
        }
        Rectangle paintBounds = g.getClipBounds();
        if (c.getComponentOrientation().isLeftToRight()) {
            startColumn = this.convertLocationToColumn(paintBounds.x, paintBounds.y);
            endColumn = this.convertLocationToColumn(paintBounds.x + paintBounds.width, paintBounds.y);
        } else {
            startColumn = this.convertLocationToColumn(paintBounds.x + paintBounds.width, paintBounds.y);
            endColumn = this.convertLocationToColumn(paintBounds.x, paintBounds.y);
        }
        int maxY = paintBounds.y + paintBounds.height;
        int maxX = paintBounds.x + paintBounds.width;
        int leadIndex = DarkListUI.adjustIndex(this.list.getLeadSelectionIndex(), this.list);
        int rowIncrement = this.layoutOrientation == 2 ? this.columnCount : 1;
        for (int colCounter = startColumn; colCounter <= endColumn; ++colCounter) {
            int bgWidth;
            int row;
            int rowCount = Math.max(this.rowsPerColumn, this.getRowCount(colCounter));
            int index = this.getModelIndex(colCounter, row);
            Rectangle rowBounds = this.getCellBounds(this.list, index);
            if (rowBounds == null) {
                return;
            }
            int n = bgWidth = colCounter == endColumn ? maxX - rowBounds.x : 0;
            for (row = this.convertLocationToRowInColumn(paintBounds.y, colCounter); row < rowCount && rowBounds.y < maxY; ++row) {
                rowBounds.height = this.getHeight(colCounter, row);
                g.setClip(rowBounds.x, rowBounds.y, bgWidth > 0 ? bgWidth : rowBounds.width, rowBounds.height);
                g.clipRect(paintBounds.x, paintBounds.y, paintBounds.width, paintBounds.height);
                this.paintCell(g, index, rowBounds, renderer, dataModel, selModel, leadIndex, row, bgWidth);
                rowBounds.y += rowBounds.height;
                index += rowIncrement;
            }
        }
        this.rendererPane.removeAll();
    }

    protected void paintCell(Graphics g, int index, Rectangle rowBounds, ListCellRenderer<Object> cellRenderer, ListModel<Object> dataModel, ListSelectionModel selModel, int leadIndex, int row, int bgWidth) {
        boolean empty = index >= this.list.getModel().getSize();
        Object value = empty ? null : dataModel.getElementAt(index);
        boolean cellHasFocus = this.list.hasFocus() && index == leadIndex;
        boolean isSelected = selModel.isSelectedIndex(index);
        int cx = rowBounds.x;
        int cy = rowBounds.y;
        int cw = rowBounds.width;
        int ch = rowBounds.height;
        if (empty || bgWidth > 0) {
            boolean alternativeRow = Boolean.TRUE.equals(this.list.getClientProperty(KEY_ALTERNATE_ROW_COLOR));
            Color alternativeRowColor = UIManager.getColor("List.alternateRowBackground");
            Color normalColor = this.list.getBackground();
            Color background = alternativeRow && row % 2 == 1 ? alternativeRowColor : normalColor;
            Color c = g.getColor();
            g.setColor(background);
            g.fillRect(cx, cy, bgWidth > 0 ? bgWidth : cw, ch);
            g.setColor(c);
        }
        if (!empty) {
            Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, index, isSelected, cellHasFocus);
            if (Boolean.TRUE.equals(this.list.getClientProperty(KEY_SHRINK_WRAP))) {
                int w = Math.min(cw, rendererComponent.getPreferredSize().width + 4);
                if (!this.list.getComponentOrientation().isLeftToRight()) {
                    cx += cw - w;
                }
                cw = w;
            }
            this.rendererPane.paintComponent(g, rendererComponent, this.list, cx, cy, cw, ch, true);
        }
    }

    static {
        UIManager.put("List.cellRenderer", new DarkListCellRenderer());
    }

    protected class DarkHandler
    extends DarkListUIBridge.Handler {
        protected DarkHandler() {
            super(DarkListUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String key = e.getPropertyName();
            if (DarkListUI.KEY_ALTERNATE_ROW_COLOR.equals(key)) {
                DarkListUI.this.list.repaint();
            }
        }

        @Override
        protected void adjustSelection(MouseEvent e) {
            int row = DarkListUI.this.list.locationToIndex(e.getPoint());
            if (row < 0) {
                if (!(!DarkListUI.this.isFileList || Boolean.TRUE.equals(DarkListUI.this.list.getClientProperty(DarkListUI.KEY_FULL_ROW_SELECTION)) || e.getID() != 501 || e.isShiftDown() && DarkListUI.this.list.getSelectionMode() != 0)) {
                    DarkListUI.this.list.clearSelection();
                }
            } else {
                boolean anchorSelected;
                int anchorIndex = DarkListUIBridge.adjustIndex(DarkListUI.this.list.getAnchorSelectionIndex(), DarkListUI.this.list);
                if (anchorIndex == -1) {
                    anchorIndex = 0;
                    anchorSelected = false;
                } else {
                    anchorSelected = DarkListUI.this.list.isSelectedIndex(anchorIndex);
                }
                if (DarkUIUtil.isMenuShortcutKeyDown(e)) {
                    if (e.isShiftDown()) {
                        if (anchorSelected) {
                            DarkListUI.this.list.addSelectionInterval(anchorIndex, row);
                        } else {
                            DarkListUI.this.list.removeSelectionInterval(anchorIndex, row);
                            if (DarkListUI.this.isFileList) {
                                DarkListUI.this.list.addSelectionInterval(row, row);
                                DarkListUI.this.list.getSelectionModel().setAnchorSelectionIndex(anchorIndex);
                            }
                        }
                    } else if (DarkListUI.this.list.isSelectedIndex(row)) {
                        DarkListUI.this.list.removeSelectionInterval(row, row);
                    } else {
                        DarkListUI.this.list.addSelectionInterval(row, row);
                    }
                } else if (e.isShiftDown()) {
                    DarkListUI.this.list.setSelectionInterval(anchorIndex, row);
                } else {
                    DarkListUI.this.list.setSelectionInterval(row, row);
                }
            }
        }
    }
}

