/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.list;

import com.github.weisj.darklaf.ui.list.DarkListUI;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.plaf.ListUI;

public class DarkListCellRenderer
extends DefaultListCellRenderer {
    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color background;
        if (this.getHorizontalAlignment() != 0) {
            if (list.getComponentOrientation().isLeftToRight()) {
                this.setHorizontalAlignment(2);
            } else {
                this.setHorizontalAlignment(4);
            }
        }
        Component comp = null;
        boolean isEditing = Boolean.TRUE.equals(list.getClientProperty("JList.isEditing"));
        if (isEditing && list.getSelectionModel().getLeadSelectionIndex() == index) {
            comp = super.getListCellRendererComponent(list, value, index, false, false);
        }
        if (comp == null) {
            comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
        boolean alternativeRow = Boolean.TRUE.equals(list.getClientProperty("JList.alternateRowColor"));
        int layout = list.getLayoutOrientation();
        if (layout == 0) {
            alternativeRow = alternativeRow && index % 2 == 1;
        } else if (layout == 1 || layout == 2) {
            ListUI ui = list.getUI();
            if (ui instanceof DarkListUI) {
                int row = ((DarkListUI)ui).convertModelToRow(index);
                alternativeRow = alternativeRow && row % 2 == 1;
            } else {
                alternativeRow = false;
            }
        }
        Color alternativeRowColor = UIManager.getColor("List.alternateRowBackground");
        Color normalColor = list.getBackground();
        Color color = background = alternativeRow ? alternativeRowColor : normalColor;
        if (!isSelected) {
            comp.setBackground(background);
            comp.setForeground(list.getForeground());
        } else if (DarkUIUtil.hasFocus(list) || DarkUIUtil.getParentOfType(JPopupMenu.class, list) != null) {
            comp.setForeground(list.getSelectionForeground());
            comp.setBackground(list.getSelectionBackground());
        } else {
            comp.setBackground(UIManager.getColor("List.selectionNoFocusBackground"));
            comp.setForeground(UIManager.getColor("List.selectionForegroundInactive"));
        }
        if (this.getText().isEmpty()) {
            this.setText(" ");
        }
        return comp;
    }
}

