/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.checkbox;

import com.github.weisj.darklaf.decorators.MouseClickListener;
import com.github.weisj.darklaf.ui.menu.DarkMenuItemUIBase;
import com.github.weisj.darklaf.util.GraphicsContext;
import com.github.weisj.darklaf.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import sun.swing.MenuItemLayoutHelper;

public class DarkCheckBoxMenuItemUI
extends DarkMenuItemUIBase {
    protected static final String KEY_PREFIX = "CheckBoxMenuItem";
    public static final String KEY_NO_NOT_CLOSE_ON_CLICK = "CheckBoxMenuItem.doNotCloseOnMouseClick";
    private final MouseClickListener clickListener = e -> SwingUtilities.invokeLater(() -> {
        if (this.menuItem != null) {
            this.menuItem.setArmed(true);
        }
    });
    private Icon checkBoxIcon;
    private Icon checkBoxDisabledIcon;
    private Icon checkBoxFocusedIcon;
    private Icon checkBoxSelectedIcon;
    private Icon checkBoxSelectedDisabledIcon;
    private Icon checkBoxSelectedFocusedIcon;

    public static ComponentUI createUI(JComponent c) {
        return new DarkCheckBoxMenuItemUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.putClientProperty(KEY_NO_NOT_CLOSE_ON_CLICK, UIManager.getBoolean(KEY_NO_NOT_CLOSE_ON_CLICK));
    }

    @Override
    protected void paintCheckIcon(Graphics g2, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr, Color holdc, Color foreground) {
        Graphics2D g = (Graphics2D)g2;
        GraphicsContext config = GraphicsUtil.setupStrokePainting(g);
        Rectangle rect = lr.getCheckRect();
        this.getCheckBoxIcon(lh.getMenuItem()).paintIcon(lh.getMenuItem(), g2, rect.x - 1, rect.y);
        config.restore();
        g.setColor(foreground);
    }

    protected Icon getCheckBoxIcon(AbstractButton b) {
        boolean selected = b.isSelected();
        boolean enabled = b.isEnabled();
        boolean hasFocus = b.hasFocus();
        return selected ? (enabled ? (hasFocus ? this.checkBoxSelectedFocusedIcon : this.checkBoxSelectedIcon) : this.checkBoxSelectedDisabledIcon) : (enabled ? (hasFocus ? this.checkBoxFocusedIcon : this.checkBoxIcon) : this.checkBoxDisabledIcon);
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.checkBoxIcon = UIManager.getIcon("CheckBox.unchecked.icon");
        this.checkBoxDisabledIcon = UIManager.getIcon("CheckBox.uncheckedDisabled.icon");
        this.checkBoxFocusedIcon = UIManager.getIcon("CheckBox.uncheckedFocused.icon");
        this.checkBoxSelectedIcon = UIManager.getIcon("CheckBox.selected.icon");
        this.checkBoxSelectedDisabledIcon = UIManager.getIcon("CheckBox.selectedDisabled.icon");
        this.checkBoxSelectedFocusedIcon = UIManager.getIcon("CheckBox.selectedFocused.icon");
    }

    @Override
    protected String getPropertyPrefix() {
        return KEY_PREFIX;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.menuItem.addMouseListener(this.clickListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removeMouseListener(this.clickListener);
    }
}

