/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.cell;

import com.github.weisj.darklaf.components.SelectableTreeNode;
import com.github.weisj.darklaf.decorators.CellRenderer;
import com.github.weisj.darklaf.ui.cell.CellEditorToggleButton;
import com.github.weisj.darklaf.ui.table.DarkTableCellFocusBorder;
import com.github.weisj.darklaf.ui.tree.DarkTreeCellRenderer;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class DarkCellRendererToggleButton<T extends JToggleButton>
implements TableCellRenderer,
TreeCellRenderer,
SwingConstants {
    private final T toggleButton;

    public DarkCellRendererToggleButton(T toggleButton) {
        this.toggleButton = toggleButton;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean focus, int row, int column) {
        Color background;
        if (value instanceof Boolean) {
            ((AbstractButton)this.toggleButton).setSelected((Boolean)value);
        }
        ((AbstractButton)this.toggleButton).setHorizontalAlignment(table.getComponentOrientation().isLeftToRight() ? 2 : 4);
        ((CellEditorToggleButton)this.toggleButton).setHasFocus(focus);
        boolean isLeadSelectionCell = DarkUIUtil.hasFocus(table) && focus && !DarkTableCellFocusBorder.isRowFocusBorder(table);
        boolean alternativeRow = Boolean.TRUE.equals(table.getClientProperty("JTable.alternateRowColor"));
        Color alternativeRowColor = UIManager.getColor("Table.alternateRowBackground");
        Color normalColor = UIManager.getColor("Table.background");
        Color color = background = alternativeRow && row % 2 == 1 ? alternativeRowColor : normalColor;
        if (!isSelected || isLeadSelectionCell || table.isEditing()) {
            ((JComponent)this.toggleButton).setBackground(background);
            ((JComponent)this.toggleButton).setForeground(table.getForeground());
        } else {
            if (DarkUIUtil.hasFocus(table)) {
                ((JComponent)this.toggleButton).setForeground(UIManager.getColor("Table.selectionForeground"));
            } else {
                ((JComponent)this.toggleButton).setForeground(UIManager.getColor("Table.selectionForegroundInactive"));
            }
            ((JComponent)this.toggleButton).setBackground(table.getSelectionBackground());
        }
        return this.toggleButton;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean focus) {
        if (value instanceof Boolean) {
            ((AbstractButton)this.toggleButton).setSelected((Boolean)value);
        } else {
            boolean sel = Boolean.TRUE.equals(DarkTreeCellRenderer.unwrapBooleanIfPossible(value));
            ((AbstractButton)this.toggleButton).setSelected(sel);
            if (value instanceof SelectableTreeNode) {
                ((AbstractButton)this.toggleButton).setText(((SelectableTreeNode)value).getLabel());
            }
        }
        if (selected) {
            if (DarkUIUtil.hasFocus(tree)) {
                ((JComponent)this.toggleButton).setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                ((JComponent)this.toggleButton).setForeground(UIManager.getColor("Tree.selectionForegroundInactive"));
            }
        } else {
            ((JComponent)this.toggleButton).setForeground(tree.getForeground());
        }
        ((AbstractButton)this.toggleButton).setHorizontalAlignment(tree.getComponentOrientation().isLeftToRight() ? 2 : 4);
        ((CellEditorToggleButton)this.toggleButton).setHasFocus(false);
        return this.toggleButton;
    }

    public JToggleButton getButton() {
        return this.toggleButton;
    }

    public static class CellEditorRadioButton
    extends JRadioButton
    implements CellRenderer,
    CellEditorToggleButton {
        private boolean hasFocus;

        public CellEditorRadioButton(boolean opaque) {
            this.setOpaque(opaque);
            this.putClientProperty("JToggleButton.isTreeCellEditor", true);
            this.putClientProperty("JToggleButton.isTableCellEditor", true);
        }

        @Override
        public void setHasFocus(boolean hasFocus) {
            this.hasFocus = hasFocus;
        }

        @Override
        public boolean hasFocus() {
            return this.hasFocus || super.hasFocus();
        }

        @Override
        public boolean isFocusOwner() {
            return super.hasFocus();
        }
    }

    public static class CellEditorCheckBox
    extends JCheckBox
    implements CellRenderer,
    CellEditorToggleButton {
        private boolean hasFocus;

        public CellEditorCheckBox(boolean opaque) {
            this.setOpaque(opaque);
            this.putClientProperty("JToggleButton.isTreeCellEditor", true);
            this.putClientProperty("JToggleButton.isTableCellEditor", true);
        }

        @Override
        public void setHasFocus(boolean hasFocus) {
            this.hasFocus = hasFocus;
        }

        @Override
        public boolean hasFocus() {
            return this.hasFocus || super.hasFocus();
        }

        @Override
        public boolean isFocusOwner() {
            return super.hasFocus();
        }
    }
}

