/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.theme;

import com.github.weisj.darklaf.DarkLaf;
import com.github.weisj.darklaf.DarkMetalTheme;
import com.github.weisj.darklaf.PropertyLoader;
import com.github.weisj.darklaf.util.SystemInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.html.StyleSheet;

public abstract class Theme {
    private static final Logger LOGGER = Logger.getLogger(Theme.class.getName());
    private static final String[] UI_PROPERTIES = new String[]{"borders", "button", "checkBox", "colorChooser", "comboBox", "fileChooser", "tristate", "internalFrame", "label", "list", "menu", "menuBar", "menuItem", "numberingPane", "optionPane", "panel", "popupMenu", "progressBar", "radioButton", "rootPane", "scrollBar", "scrollPane", "separator", "slider", "spinner", "splitPane", "statusBar", "tabbedPane", "tabFrame", "table", "taskPane", "text", "toggleButton", "toolBar", "toolTip", "tree"};
    private static final String[] ICON_PROPERTIES = new String[]{"control", "dialog", "files", "frame", "indicator", "menu", "misc", "navigation"};

    public UIManager.LookAndFeelInfo createLookAndFeelInfo() {
        return new UIManager.LookAndFeelInfo(this.getName(), DarkLaf.class.getCanonicalName());
    }

    public void beforeInstall() {
        if (SystemInfo.isWindows || SystemInfo.isLinux) {
            MetalLookAndFeel.setCurrentTheme(new DarkMetalTheme());
        }
    }

    public void loadDefaults(Properties properties, UIDefaults currentDefaults) {
        String name = this.getResourcePath() + this.getName() + "_defaults.properties";
        PropertyLoader.putProperties(this.load(name), properties, currentDefaults);
    }

    public void loadGlobals(Properties properties, UIDefaults currentDefaults) {
        PropertyLoader.putProperties(PropertyLoader.loadProperties(DarkLaf.class, "globals", "properties/"), properties, currentDefaults);
    }

    public void loadIconProperties(Properties properties, UIDefaults currentDefaults) {
        this.loadIconTheme(properties, currentDefaults);
        for (String property : ICON_PROPERTIES) {
            PropertyLoader.putProperties(PropertyLoader.loadProperties(DarkLaf.class, property, "properties/icons/"), properties, currentDefaults);
        }
    }

    protected void loadIconTheme(Properties properties, UIDefaults currentDefaults) {
        Properties props;
        IconTheme iconTheme = this.getPresetIconTheme();
        switch (iconTheme) {
            case DARK: {
                props = PropertyLoader.loadProperties(DarkLaf.class, "dark_icons", "properties/icons/presets/");
                break;
            }
            case LIGHT: {
                props = PropertyLoader.loadProperties(DarkLaf.class, "light_icons", "properties/icons/presets/");
                break;
            }
            default: {
                props = this.load(this.getResourcePath() + this.getName() + "_icons.properties");
            }
        }
        PropertyLoader.putProperties(props, properties, currentDefaults);
    }

    public void loadPlatformProperties(Properties properties, UIDefaults currentDefaults) {
        PropertyLoader.putProperties(PropertyLoader.loadProperties(DarkLaf.class, this.getOsName(), "properties/platform/"), properties, currentDefaults);
    }

    private String getOsName() {
        return SystemInfo.isMac ? "mac" : (SystemInfo.isWindows ? "windows" : "linux");
    }

    public void loadUIProperties(Properties properties, UIDefaults currentDefaults) {
        for (String property : UI_PROPERTIES) {
            PropertyLoader.putProperties(PropertyLoader.loadProperties(DarkLaf.class, property, "properties/ui/"), properties, currentDefaults);
        }
    }

    protected abstract IconTheme getPresetIconTheme();

    protected void loadCustomProperties(String propertySuffix, Properties properties, UIDefaults currentDefaults) {
        String name = this.getResourcePath() + this.getName() + "_" + propertySuffix + ".properties";
        PropertyLoader.putProperties(this.load(name), properties, currentDefaults);
    }

    protected Properties load(String name) {
        return this.loadWithClass(name, this.getLoaderClass());
    }

    protected Properties loadWithClass(String name, Class<?> loaderClass) {
        Properties properties = new Properties();
        try (InputStream stream = loaderClass.getResourceAsStream(name);){
            properties.load(stream);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not load " + name + ".properties. " + e.getMessage(), e.getStackTrace());
        }
        return properties;
    }

    protected String getResourcePath() {
        return "";
    }

    public abstract String getName();

    protected abstract Class<? extends Theme> getLoaderClass();

    public StyleSheet loadStyleSheet() {
        return this.loadStyleSheetWithClass(this.getLoaderClass());
    }

    public StyleSheet loadStyleSheetWithClass(Class<?> loaderClass) {
        StyleSheet styleSheet = new StyleSheet();
        try (InputStream in = loaderClass.getResourceAsStream(this.getResourcePath() + this.getName() + "_styleSheet.css");
             InputStreamReader inReader = new InputStreamReader(in, StandardCharsets.UTF_8);
             BufferedReader r = new BufferedReader(inReader);){
            styleSheet.loadRules(r, null);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e.getStackTrace());
        }
        return styleSheet;
    }

    public boolean useCustomDecorations() {
        return true;
    }

    public abstract boolean useDarkIcons();

    protected static enum IconTheme {
        NONE,
        DARK,
        LIGHT;

    }
}

