/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.tristate;

import com.github.weisj.darklaf.DarkLaf;
import com.github.weisj.darklaf.components.tristate.TristateButtonModel;
import com.github.weisj.darklaf.components.tristate.TristateState;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;

public class TristateCheckBox
extends JCheckBox {
    private final ChangeListener enableListener = e -> this.setFocusable(this.getModel().isEnabled());

    public TristateCheckBox(String text) {
        this(text, null, TristateState.DESELECTED);
    }

    public TristateCheckBox(String text, Icon icon, TristateState initial) {
        super(text, icon);
        this.setModel(new TristateButtonModel(initial));
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TristateCheckBox.this.iterateState();
            }
        });
    }

    private void iterateState() {
        if (!this.getModel().isEnabled()) {
            return;
        }
        this.grabFocus();
        this.getTristateModel().iterateState();
        this.repaint();
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiersEx();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        this.fireActionPerformed(new ActionEvent(this, 1001, this.getText(), System.currentTimeMillis(), modifiers));
    }

    public TristateButtonModel getTristateModel() {
        return (TristateButtonModel)super.getModel();
    }

    @Override
    public String getUIClassID() {
        if (UIManager.getLookAndFeel() instanceof DarkLaf) {
            return "TristateCheckBoxUI";
        }
        return super.getUIClassID();
    }

    @Override
    public void setSelected(boolean b) {
        this.setState(b ? TristateState.SELECTED : TristateState.DESELECTED);
    }

    @Override
    public void setModel(ButtonModel newModel) {
        super.setModel(newModel);
        if (this.model instanceof TristateButtonModel) {
            this.model.addChangeListener(this.enableListener);
        }
    }

    public void setIndeterminate() {
        this.getTristateModel().setIndeterminate();
    }

    public boolean isIndeterminate() {
        return this.getTristateModel().isIndeterminate();
    }

    public TristateState getState() {
        return this.getTristateModel().getState();
    }

    public void setState(TristateState state) {
        this.getTristateModel().setState(state);
    }
}

