/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.border;

import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.GraphicsContext;
import com.github.weisj.darklaf.util.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.InsetsUIResource;

public class BubbleBorder
extends AbstractBorder {
    private final Insets insets;
    private Alignment pointerSide = Alignment.NORTH;
    private Color color;
    private int thickness;
    private int radius;
    private int pointerSize;
    private int pointerWidth;
    private BasicStroke stroke;

    public BubbleBorder(Color color) {
        this(color, 2, 4, 5);
    }

    public BubbleBorder(Color color, int thickness, int radius, int pointerSize) {
        this.color = color;
        this.thickness = thickness;
        this.radius = radius;
        this.pointerSize = pointerSize;
        this.pointerWidth = pointerSize;
        this.insets = new InsetsUIResource(0, 0, 0, 0);
        this.setThickness(thickness);
    }

    public Color getColor() {
        return this.color;
    }

    public BubbleBorder setColor(Color color) {
        this.color = color;
        return this;
    }

    public int getPointerWidth() {
        return this.pointerWidth;
    }

    public BubbleBorder setPointerWidth(int pointerWidth) {
        this.pointerWidth = pointerWidth;
        return this;
    }

    public int getThickness() {
        return this.thickness;
    }

    public BubbleBorder setThickness(int n) {
        this.thickness = Math.max(n, 0);
        this.stroke = new BasicStroke(this.thickness);
        return this.setPointerSize(this.pointerSize);
    }

    public int getRadius() {
        return this.radius;
    }

    public BubbleBorder setPointerSize(int size) {
        this.pointerSize = Math.max(size, 0);
        int left = this.thickness;
        int right = this.thickness;
        int bottom = this.thickness;
        int top = this.thickness;
        switch (this.pointerSide) {
            case NORTH: 
            case NORTH_WEST: 
            case NORTH_EAST: {
                top += this.pointerSize;
                break;
            }
            case SOUTH: 
            case SOUTH_WEST: 
            case SOUTH_EAST: {
                bottom += this.pointerSize;
                break;
            }
            case WEST: {
                left += this.pointerSize;
                break;
            }
            case EAST: {
                right += this.pointerSize;
                break;
            }
        }
        this.insets.set(top, left, bottom, right);
        return this;
    }

    public int getPointerSize() {
        return this.pointerSize;
    }

    public BubbleBorder setRadius(int radius) {
        this.radius = radius;
        return this.setPointerSize(this.pointerSize);
    }

    public Alignment getPointerSide() {
        return this.pointerSide;
    }

    public BubbleBorder setPointerSide(Alignment side) {
        this.pointerSide = side;
        this.setPointerSize(this.pointerSize);
        return this;
    }

    public int getOffset(int w, int h) {
        return (int)this.calculatePointerPad(w, h, Alignment.NORTH_WEST);
    }

    private double calculatePointerPad(int width, int height, Alignment side) {
        double pointerPad;
        switch (side) {
            case WEST: 
            case EAST: {
                pointerPad = (double)this.radius + (double)(height - this.insets.top - this.insets.bottom - 2 * this.radius) / 2.0;
                break;
            }
            case NORTH_WEST: 
            case SOUTH_WEST: {
                pointerPad = this.radius + this.insets.left + this.pointerWidth;
                break;
            }
            case NORTH_EAST: 
            case SOUTH_EAST: {
                pointerPad = width - this.radius - this.insets.right - this.pointerWidth;
                break;
            }
            case NORTH: 
            case SOUTH: {
                pointerPad = (double)this.radius + 0.5 * (double)(width - this.insets.left - this.insets.right - 2 * this.radius);
                break;
            }
            default: {
                pointerPad = 0.0;
            }
        }
        return pointerPad;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Area area = this.getInnerArea(x, y, width, height);
        this.paintBorder(g, area);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new InsetsUIResource(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return this.getBorderInsets(c);
    }

    public Area getInnerArea(int x, int y, int width, int height) {
        RoundRectangle2D.Double bubble = this.calculateBubbleRect(x, y, width, height);
        Area area = new Area(bubble);
        if (this.pointerSide != Alignment.CENTER) {
            double pointerPad = this.calculatePointerPad(width, height, this.pointerSide);
            Path2D pointer = this.creatPointerShape(pointerPad, bubble);
            area.add(new Area(pointer));
        }
        return area;
    }

    public void paintBorder(Graphics g, Area innerArea) {
        Graphics2D g2 = (Graphics2D)g;
        GraphicsContext config = GraphicsUtil.setupStrokePainting(g);
        g2.setColor(this.color);
        g2.setStroke(this.stroke);
        g2.draw(innerArea);
        config.restore();
    }

    public RoundRectangle2D.Double calculateBubbleRect(int x, int y, int width, int height) {
        return new RoundRectangle2D.Double(x + this.insets.left, y + this.insets.top, width - this.insets.left - this.insets.right, height - this.insets.top - this.insets.bottom, this.radius, this.radius);
    }

    private Path2D creatPointerShape(double pointerPad, RoundRectangle2D.Double bubble) {
        double w = (double)this.pointerWidth / 2.0;
        Path2D.Double pointer = new Path2D.Double(0);
        double x = bubble.x;
        double y = bubble.y;
        switch (this.pointerSide) {
            case WEST: {
                ((Path2D)pointer).moveTo(x, y + pointerPad - w);
                ((Path2D)pointer).lineTo(x - (double)this.pointerSize, y + pointerPad);
                ((Path2D)pointer).lineTo(x, y + pointerPad + w);
                break;
            }
            case EAST: {
                ((Path2D)pointer).moveTo(x + bubble.width, y + pointerPad - w);
                ((Path2D)pointer).lineTo(x + bubble.width + (double)this.pointerSize, y + pointerPad);
                ((Path2D)pointer).lineTo(x + bubble.width, y + pointerPad + w);
                break;
            }
            case NORTH: 
            case NORTH_WEST: 
            case NORTH_EAST: {
                ((Path2D)pointer).moveTo(x + pointerPad - w, y);
                ((Path2D)pointer).lineTo(x + pointerPad, y - (double)this.pointerSize);
                ((Path2D)pointer).lineTo(x + pointerPad + w, y);
                break;
            }
            case SOUTH: 
            case SOUTH_WEST: 
            case SOUTH_EAST: {
                ((Path2D)pointer).moveTo(x + pointerPad - w, y + bubble.height);
                ((Path2D)pointer).lineTo(x + pointerPad, y + bubble.height + (double)this.pointerSize);
                ((Path2D)pointer).lineTo(x + pointerPad + w, y + bubble.height);
                break;
            }
        }
        pointer.closePath();
        return pointer;
    }
}

