/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf;

import com.github.weisj.darklaf.icons.DarkUIAwareIcon;
import com.github.weisj.darklaf.icons.EmptyIcon;
import com.github.weisj.darklaf.icons.IconLoader;
import com.github.weisj.darklaf.util.ColorUtil;
import com.github.weisj.darklaf.util.Pair;
import com.github.weisj.darklaf.util.StringUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;

public final class PropertyLoader {
    private static final Logger LOGGER = Logger.getLogger(PropertyLoader.class.getName());
    private static final IconLoader ICON_LOADER = IconLoader.get();
    private static final String DUAL_KEY = "[dual]";
    private static final String AWARE_KEY = "[aware]";
    private static final String THEMED_KEY = "[themed]";
    private static final String REFERENCE_PREFIX = "%";
    private static final String FONT_FROM = "from";
    private static final String FONT_SIZE = "withSize";
    private static final String FONT_STYLE = "withStyle";
    private static boolean addReferenceInfo;
    private static final Map<AttributedCharacterIterator.Attribute, Integer> attributes;

    public static void setAddReferenceInfo(boolean addReferenceInfo) {
        PropertyLoader.addReferenceInfo = addReferenceInfo;
    }

    public static Properties loadProperties(Class<?> clazz, String name, String path) {
        Properties properties = new Properties();
        String p = path + name + ".properties";
        try (InputStream stream = clazz.getResourceAsStream(p);){
            properties.load(stream);
        }
        catch (IOException | NullPointerException e) {
            LOGGER.log(Level.SEVERE, "Could not load " + p + " " + e.getMessage(), e.getStackTrace());
        }
        return properties;
    }

    public static void putProperties(Properties properties, Properties accumulator, UIDefaults currentDefaults) {
        PropertyLoader.putProperties(properties, accumulator, currentDefaults, ICON_LOADER);
    }

    public static void putProperties(Properties properties, Properties accumulator, UIDefaults currentDefaults, IconLoader iconLoader) {
        for (String key : properties.stringPropertyNames()) {
            String value;
            Object parsed = PropertyLoader.parseValue(key, value = properties.getProperty(key), accumulator, currentDefaults, iconLoader);
            if (parsed != null) {
                accumulator.put(PropertyLoader.parseKey(key), parsed);
                continue;
            }
            currentDefaults.remove(PropertyLoader.parseKey(key));
        }
    }

    private static Object parseValue(String key, String value, Properties accumulator, UIDefaults currentDefaults, IconLoader iconLoader) {
        return PropertyLoader.parseValue(key, value, false, accumulator, currentDefaults, iconLoader);
    }

    private static String parseKey(String key) {
        if (addReferenceInfo) {
            return key;
        }
        return key.startsWith(REFERENCE_PREFIX) ? key.substring(REFERENCE_PREFIX.length()) : key;
    }

    private static Object parseValue(String propertyKey, String value, boolean ignoreRequest, Map<Object, Object> accumulator, UIDefaults currentDefaults, IconLoader iconLoader) {
        if ("null".equals(value)) {
            return null;
        }
        String key = propertyKey;
        boolean skipObjects = ignoreRequest;
        if (key.startsWith(REFERENCE_PREFIX)) {
            key = PropertyLoader.parseKey(key);
            skipObjects = true;
        }
        Pair<String, Object> returnVal = new LoadError();
        if (key.endsWith("Insets") || key.endsWith(".insets")) {
            returnVal = PropertyLoader.parseInsets(value);
        } else {
            if (!skipObjects && (key.endsWith("Border") || key.endsWith(".border") || key.endsWith("Renderer"))) {
                return def -> PropertyLoader.parseObject(value);
            }
            if (key.endsWith(".component") || key.endsWith("Component")) {
                return def -> PropertyLoader.parseObject(value);
            }
            if (key.toLowerCase().endsWith("font")) {
                returnVal = PropertyLoader.parseFont(key, value, accumulator, currentDefaults);
            } else if (key.endsWith(".icon") || key.endsWith("Icon")) {
                returnVal = PropertyLoader.parseIcon(value, iconLoader);
            } else if (key.endsWith("Size") || key.endsWith(".size")) {
                returnVal = PropertyLoader.parseSize(value);
            } else if ("null".equalsIgnoreCase(value)) {
                returnVal = null;
            } else if (value.startsWith(REFERENCE_PREFIX)) {
                boolean containsKey;
                String val = PropertyLoader.parseKey(value);
                String referenceFreeKey = val.substring(REFERENCE_PREFIX.length());
                boolean bl = containsKey = accumulator.containsKey(val) || addReferenceInfo && accumulator.containsKey(referenceFreeKey);
                if (!containsKey) {
                    LOGGER.warning("Could not reference value '" + val + "' while loading '" + key + "'. May be a forward reference");
                }
                returnVal = accumulator.get(val);
                if (addReferenceInfo) {
                    if (returnVal == null) {
                        returnVal = accumulator.get(referenceFreeKey);
                    }
                    returnVal = new Pair<String, Object>(value, returnVal);
                }
            }
        }
        if (returnVal instanceof LoadError) {
            Boolean boolVal;
            Color color = ColorUtil.fromHex(value, null);
            Integer invVal = PropertyLoader.getInteger(value);
            Boolean bl = "true".equalsIgnoreCase(value) ? Boolean.TRUE : (boolVal = "false".equalsIgnoreCase(value) ? Boolean.FALSE : null);
            if (color != null && (value.length() == 6 || value.length() == 8)) {
                return new ColorUIResource(color);
            }
            if (invVal != null) {
                return invVal;
            }
            if (boolVal != null) {
                return boolVal;
            }
        } else {
            return returnVal;
        }
        return value;
    }

    private static Object parseInsets(String value) {
        List<String> numbers = StringUtil.split(value, ",");
        return new InsetsUIResource(Integer.parseInt(numbers.get(0)), Integer.parseInt(numbers.get(1)), Integer.parseInt(numbers.get(2)), Integer.parseInt(numbers.get(3)));
    }

    private static Object parseFont(String key, String value, Map<Object, Object> accumulator, UIDefaults currentDefaults) {
        String val = value;
        Font base = null;
        int size = -1;
        int style = -1;
        while (true) {
            Pair<Serializable, String> result;
            if (val.startsWith(FONT_FROM)) {
                result = PropertyLoader.parseFrom(val, accumulator, currentDefaults);
                base = result.getFirst();
                val = result.getSecond();
                continue;
            }
            if (val.startsWith(FONT_SIZE)) {
                result = PropertyLoader.parseFontAttribute(FONT_SIZE, val);
                size = (Integer)result.getFirst();
                val = result.getSecond();
                continue;
            }
            if (!val.startsWith(FONT_STYLE)) break;
            result = PropertyLoader.parseFontAttribute(FONT_STYLE, val);
            style = (Integer)result.getFirst();
            val = result.getSecond();
        }
        if (base == null) {
            base = PropertyLoader.parseExplicitFont(value);
        }
        if (base == null && accumulator.get(key) instanceof Font) {
            base = (Font)accumulator.get(key);
        }
        if (base == null) {
            base = currentDefaults.getFont(key);
        }
        if (base == null) {
            base = new Font("Dialog", 0, 12);
        }
        if (size > 0) {
            base = base.deriveFont((float)size);
        }
        if (style >= 0) {
            base = base.deriveFont(style);
        }
        return new FontUIResource(base.deriveFont(attributes));
    }

    private static Font parseExplicitFont(String value) {
        try {
            String[] decode = value.split("-");
            return new FontUIResource(decode[0], Integer.parseInt(decode[1]), Integer.parseInt(decode[2]));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Pair<Integer, String> parseFontAttribute(String identifier, String val) {
        String key = val.substring(identifier.length() + 1);
        int lastIndex = key.indexOf(41);
        String rest = key.substring(lastIndex + 1);
        key = key.substring(0, lastIndex);
        try {
            return new Pair<Integer, String>(Integer.parseInt(key), rest);
        }
        catch (NumberFormatException e) {
            return new Pair<Integer, String>(-1, rest);
        }
    }

    private static Pair<Font, String> parseFrom(String val, Map<Object, Object> accumulator, UIDefaults currentDefaults) {
        String key = val.substring(FONT_FROM.length() + 1);
        int index = key.indexOf(41);
        String rest = key.substring(index + 1);
        key = key.substring(0, index);
        Font font = null;
        if (accumulator.get(key) instanceof Font) {
            font = (Font)accumulator.get(key);
        }
        if (font == null) {
            font = currentDefaults.getFont(key);
        }
        return new Pair<Font, String>(font, rest);
    }

    private static Icon parseIcon(String value, IconLoader iconLoader) {
        String path = value;
        Dimension dim = new Dimension(16, 16);
        if (value.charAt(value.length() - 1) == ')') {
            int i = path.lastIndexOf(40);
            String dimVal = path.substring(i + 1, path.length() - 1);
            int[] values = Arrays.stream(dimVal.split(",", 2)).mapToInt(Integer::parseInt).toArray();
            dim.width = values[0];
            dim.height = values[1];
            path = path.substring(0, i);
        }
        if (path.charAt(path.length() - 1) == ']') {
            String tag = null;
            if (path.endsWith(DUAL_KEY)) {
                tag = DUAL_KEY;
            } else if (path.endsWith(AWARE_KEY)) {
                tag = AWARE_KEY;
            } else if (path.endsWith(THEMED_KEY)) {
                tag = THEMED_KEY;
            }
            if (tag == null) {
                throw new IllegalArgumentException("Invalid tag on icon path: '" + value + "'");
            }
            String iconPath = path.substring(0, path.length() - tag.length());
            if (tag.equals(THEMED_KEY)) {
                return iconLoader.getIcon(iconPath, dim.width, dim.height, true);
            }
            DarkUIAwareIcon icon = iconLoader.getUIAwareIcon(iconPath, dim.width, dim.height);
            if (tag.equals(DUAL_KEY)) {
                return icon.getDual();
            }
            return icon;
        }
        if (path.equals("empty")) {
            return EmptyIcon.create(dim.width, dim.height);
        }
        return iconLoader.getIcon(path, dim.width, dim.height);
    }

    private static Object parseSize(String value) {
        try {
            int[] dim = Arrays.stream(value.split(",", 2)).mapToInt(Integer::parseInt).toArray();
            return new DimensionUIResource(dim[0], dim[1]);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            return new LoadError();
        }
    }

    private static Integer getInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    private static Object parseObject(String value) {
        try {
            return Class.forName(value).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        attributes = Collections.singletonMap(TextAttribute.KERNING, TextAttribute.KERNING_ON);
    }

    private static final class LoadError {
        private LoadError() {
        }
    }
}

