/*
 * Decompiled with CFR 0.152.
 */
package boofcv.visualize;

import boofcv.alg.cloud.AccessColorIndex;
import boofcv.alg.cloud.AccessPointIndex;
import boofcv.struct.Point3dRgbI_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.List;
import javax.swing.JComponent;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F32;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;

public interface PointCloudViewer {
    public void setShowAxis(boolean var1);

    public void setTranslationStep(double var1);

    public void setDotSize(int var1);

    public void setClipDistance(double var1);

    public void setFog(boolean var1);

    public void setBackgroundColor(int var1);

    public void setColorFrame(boolean var1);

    public void addCloud(IteratePoint var1, boolean var2);

    default public void addCloud(final AccessPointIndex<Point3D_F64> accessPoint, final @Nullable AccessColorIndex accessColor, final int size) {
        if (accessColor == null) {
            this.addCloud(new IteratePoint(){
                int index = 0;

                @Override
                public int next(Point3D_F64 point) {
                    accessPoint.getPoint(this.index++, point);
                    return -1;
                }

                @Override
                public boolean hasNext() {
                    return this.index < size;
                }
            }, false);
        } else {
            this.addCloud(new IteratePoint(){
                int index = 0;

                @Override
                public int next(Point3D_F64 point) {
                    accessPoint.getPoint(this.index, point);
                    return accessColor.getRGB(this.index++);
                }

                @Override
                public boolean hasNext() {
                    return this.index < size;
                }
            }, true);
        }
    }

    @Deprecated
    default public void addCloud(List<Point3D_F64> cloudXyz, int[] colorsRgb) {
        this.addCloud((index, p) -> p.setTo((Point3D_F64)cloudXyz.get(index)), index -> colorsRgb[index], cloudXyz.size());
    }

    @Deprecated
    default public void addCloud(List<Point3D_F64> cloud) {
        this.addCloud((index, p) -> p.setTo((Point3D_F64)cloud.get(index)), null, cloud.size());
    }

    @Deprecated
    default public void addCloud(DogArray_F32 cloudXYZ, DogArray_I32 colorRGB) {
        int size = cloudXYZ.size / 3;
        this.addCloud((index, p) -> {
            int i = index * 3;
            p.setTo(cloudXYZ.data[i], cloudXYZ.data[i + 1], cloudXYZ.data[i + 2]);
        }, colorRGB::get, size);
    }

    public void addPoint(double var1, double var3, double var5, int var7);

    public void addWireFrame(List<Point3D_F64> var1, boolean var2, int var3, int var4);

    public void clearPoints();

    public void setColorizer(Colorizer var1);

    public void removeColorizer();

    public void setCameraHFov(double var1);

    public void setCameraToWorld(Se3_F64 var1);

    public Se3_F64 getCameraToWorld(@Nullable Se3_F64 var1);

    public DogArray<Point3dRgbI_F64> copyCloud(@Nullable DogArray<Point3dRgbI_F64> var1);

    public JComponent getComponent();

    public static interface IteratePoint {
        public int next(Point3D_F64 var1);

        public boolean hasNext();
    }

    public static interface Colorizer {
        public int color(int var1, double var2, double var4, double var6);
    }
}

