/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.packed;

import boofcv.misc.BoofLambdas;
import boofcv.struct.PackedArray;
import georegression.struct.point.Point3D_F64;
import org.ddogleg.struct.BigDogArray_F64;
import org.ddogleg.struct.BigDogGrowth;

public class PackedBigArrayPoint3D_F64
implements PackedArray<Point3D_F64> {
    private static final int DOF = 3;
    public final Point3D_F64 temp = new Point3D_F64();
    private final BigDogArray_F64 dog;
    protected int size;

    public PackedBigArrayPoint3D_F64() {
        this(10);
    }

    public PackedBigArrayPoint3D_F64(int reservedPoints) {
        this(reservedPoints, 50000, BigDogGrowth.GROW_FIRST);
    }

    public PackedBigArrayPoint3D_F64(int reservedPoints, int blockSize, BigDogGrowth growth) {
        this.dog = new BigDogArray_F64(reservedPoints * 3, blockSize * 3, growth);
    }

    public PackedBigArrayPoint3D_F64 setTo(PackedBigArrayPoint3D_F64 src) {
        this.reset();
        this.reserve(src.size);
        src.forIdx(0, src.size, (int idx, Point3D_F64 p) -> this.append(p.x, p.y, p.z));
        return this;
    }

    @Override
    public void reset() {
        this.dog.reset();
        this.size = 0;
    }

    @Override
    public void reserve(int numPoints) {
        this.dog.reserve(numPoints * 3);
    }

    public void append(double x, double y, double z) {
        this.dog.add(x);
        this.dog.add(y);
        this.dog.add(z);
        ++this.size;
    }

    @Override
    public void append(Point3D_F64 element) {
        this.dog.add(element.x);
        this.dog.add(element.y);
        this.dog.add(element.z);
        ++this.size;
    }

    @Override
    public Point3D_F64 getTemp(int index) {
        double[] block = (double[])this.dog.getBlocks().get((index *= 3) / this.dog.getBlockSize());
        int element = index % this.dog.getBlockSize();
        this.temp.x = block[element];
        this.temp.y = block[element + 1];
        this.temp.z = block[element + 2];
        return this.temp;
    }

    @Override
    public void getCopy(int index, Point3D_F64 dst) {
        double[] block = (double[])this.dog.getBlocks().get((index *= 3) / this.dog.getBlockSize());
        int element = index % this.dog.getBlockSize();
        dst.x = block[element];
        dst.y = block[element + 1];
        dst.z = block[element + 2];
    }

    @Override
    public void copy(Point3D_F64 src, Point3D_F64 dst) {
        dst.setTo(src);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Class<Point3D_F64> getElementType() {
        return Point3D_F64.class;
    }

    @Override
    public void forIdx(int idx0, int idx1, BoofLambdas.ProcessIndex<Point3D_F64> op) {
        this.dog.processByBlock(idx0 * 3, idx1 * 3, (array, arrayIdx0, arrayIdx1, offset) -> {
            int pointIndex = idx0 + offset / 3;
            for (int i = arrayIdx0; i < arrayIdx1; i += 3) {
                this.temp.x = array[i];
                this.temp.y = array[i + 1];
                this.temp.z = array[i + 2];
                op.process(pointIndex++, this.temp);
                array[i] = this.temp.x;
                array[i + 1] = this.temp.y;
                array[i + 2] = this.temp.z;
            }
        });
    }
}

