/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.packed;

import boofcv.misc.BoofLambdas;
import boofcv.struct.PackedArray;
import georegression.struct.point.Point2D_F64;
import org.ddogleg.struct.BigDogArray_F64;
import org.ddogleg.struct.BigDogGrowth;

public class PackedBigArrayPoint2D_F64
implements PackedArray<Point2D_F64> {
    private static final int DOF = 2;
    private final BigDogArray_F64 dog;
    public final Point2D_F64 temp = new Point2D_F64();
    protected int numPoints;

    public PackedBigArrayPoint2D_F64() {
        this(10);
    }

    public PackedBigArrayPoint2D_F64(int reservedPoints) {
        this(reservedPoints, 50000, BigDogGrowth.GROW_FIRST);
    }

    public PackedBigArrayPoint2D_F64(int reservedPoints, int blockSize, BigDogGrowth growth) {
        this.dog = new BigDogArray_F64(reservedPoints * 2, blockSize * 2, growth);
    }

    @Override
    public void reset() {
        this.dog.reset();
        this.numPoints = 0;
    }

    @Override
    public void reserve(int numPoints) {
        this.dog.reserve(numPoints * 2);
    }

    public void append(double x, double y) {
        this.dog.add(x);
        this.dog.add(y);
        ++this.numPoints;
    }

    @Override
    public void append(Point2D_F64 element) {
        this.dog.add(element.x);
        this.dog.add(element.y);
        ++this.numPoints;
    }

    @Override
    public Point2D_F64 getTemp(int index) {
        double[] block = (double[])this.dog.getBlocks().get((index *= 2) / this.dog.getBlockSize());
        int element = index % this.dog.getBlockSize();
        this.temp.x = block[element];
        this.temp.y = block[element + 1];
        return this.temp;
    }

    @Override
    public void getCopy(int index, Point2D_F64 dst) {
        double[] block = (double[])this.dog.getBlocks().get((index *= 2) / this.dog.getBlockSize());
        int element = index % this.dog.getBlockSize();
        dst.x = block[element];
        dst.y = block[element + 1];
    }

    @Override
    public void copy(Point2D_F64 src, Point2D_F64 dst) {
        dst.setTo(src);
    }

    @Override
    public int size() {
        return this.numPoints;
    }

    @Override
    public Class<Point2D_F64> getElementType() {
        return Point2D_F64.class;
    }

    @Override
    public void forIdx(int idx0, int idx1, BoofLambdas.ProcessIndex<Point2D_F64> op) {
        this.dog.processByBlock(idx0 * 2, idx1 * 2, (array, arrayIdx0, arrayIdx1, offset) -> {
            int pointIndex = idx0 + offset / 2;
            for (int i = arrayIdx0; i < arrayIdx1; i += 2) {
                this.temp.x = array[i];
                this.temp.y = array[i + 1];
                op.process(pointIndex++, this.temp);
                array[i] = this.temp.x;
                array[i + 1] = this.temp.y;
            }
        });
    }
}

