/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.packed;

import boofcv.misc.BoofLambdas;
import boofcv.struct.PackedArray;
import georegression.struct.point.Point3D_F32;
import org.ddogleg.struct.DogArray_F32;

public class PackedArrayPoint3D_F32
implements PackedArray<Point3D_F32> {
    private static final int DOF = 3;
    public final DogArray_F32 array;
    public final Point3D_F32 temp = new Point3D_F32();
    protected int numElements;

    public PackedArrayPoint3D_F32() {
        this.array = new DogArray_F32();
        this.array.resize(0);
    }

    @Override
    public void reset() {
        this.numElements = 0;
        this.array.reset();
    }

    @Override
    public void reserve(int numTuples) {
        this.array.reserve(numTuples * 2);
    }

    @Override
    public void append(Point3D_F32 element) {
        this.array.add(element.x);
        this.array.add(element.y);
        this.array.add(element.z);
        ++this.numElements;
    }

    @Override
    public Point3D_F32 getTemp(int index) {
        this.temp.x = this.array.data[index *= 3];
        this.temp.y = this.array.data[index + 1];
        this.temp.z = this.array.data[index + 2];
        return this.temp;
    }

    @Override
    public void getCopy(int index, Point3D_F32 dst) {
        dst.x = this.array.data[index *= 3];
        dst.y = this.array.data[index + 1];
        dst.z = this.array.data[index + 2];
    }

    @Override
    public void copy(Point3D_F32 src, Point3D_F32 dst) {
        dst.setTo(src);
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public Class<Point3D_F32> getElementType() {
        return Point3D_F32.class;
    }

    @Override
    public void forIdx(int idx0, int idx1, BoofLambdas.ProcessIndex<Point3D_F32> op) {
        int pointIndex = idx0;
        idx1 *= 3;
        for (int i = idx0 *= 3; i < idx1; i += 3) {
            this.temp.x = this.array.data[i];
            this.temp.y = this.array.data[i + 1];
            this.temp.z = this.array.data[i + 2];
            op.process(pointIndex++, this.temp);
            this.array.data[i] = this.temp.x;
            this.array.data[i + 1] = this.temp.y;
            this.array.data[i + 2] = this.temp.z;
        }
    }
}

