/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.packed;

import boofcv.misc.BoofLambdas;
import boofcv.struct.PackedArray;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.struct.DogArray_I16;

public class PackedArrayPoint2D_I16
implements PackedArray<Point2D_I16> {
    private static final int DOF = 2;
    public final DogArray_I16 array;
    public final Point2D_I16 temp = new Point2D_I16();
    protected int numElements;

    public PackedArrayPoint2D_I16() {
        this.array = new DogArray_I16();
        this.array.resize(0);
    }

    @Override
    public void reset() {
        this.numElements = 0;
        this.array.reset();
    }

    @Override
    public void reserve(int numTuples) {
        this.array.reserve(numTuples * 2);
    }

    public final void append(int x, int y) {
        this.array.add(x);
        this.array.add(y);
        ++this.numElements;
    }

    @Override
    public void append(Point2D_I16 element) {
        this.append(element.x, element.y);
    }

    @Override
    public Point2D_I16 getTemp(int index) {
        this.temp.x = this.array.data[index * 2];
        this.temp.y = this.array.data[index * 2 + 1];
        return this.temp;
    }

    @Override
    public void getCopy(int index, Point2D_I16 dst) {
        dst.x = this.array.data[index * 2];
        dst.y = this.array.data[index * 2 + 1];
    }

    @Override
    public void copy(Point2D_I16 src, Point2D_I16 dst) {
        dst.setTo(src);
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public Class<Point2D_I16> getElementType() {
        return Point2D_I16.class;
    }

    @Override
    public void forIdx(int idx0, int idx1, BoofLambdas.ProcessIndex<Point2D_I16> op) {
        int pointIndex = idx0;
        idx1 *= 2;
        for (int i = idx0 *= 2; i < idx1; i += 2) {
            this.temp.x = this.array.data[i];
            this.temp.y = this.array.data[i + 1];
            op.process(pointIndex++, this.temp);
            this.array.data[i] = this.temp.x;
            this.array.data[i + 1] = this.temp.y;
        }
    }
}

