/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.InterleavedInteger;
import org.jetbrains.annotations.Nullable;

public abstract class InterleavedI16<T extends InterleavedI16<T>>
extends InterleavedInteger<T> {
    public short[] data;

    protected InterleavedI16(int width, int height, int numBands) {
        super(width, height, numBands);
    }

    protected InterleavedI16() {
        this.data = new short[0];
    }

    @Override
    public String toString_element(int index) {
        return String.format("%04x", this.data[index] & 0xFFFF);
    }

    @Override
    public ImageDataType getDataType() {
        return ImageDataType.I16;
    }

    public short[] get(int x, int y, @Nullable short[] storage) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        if (storage == null) {
            storage = new short[this.numBands];
        }
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            storage[i] = this.data[index];
            ++i;
            ++index;
        }
        return storage;
    }

    public void set(int x, int y, short ... value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            this.data[index] = value[i];
            ++i;
            ++index;
        }
    }

    public void setBand(int x, int y, int band, short value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        this.data[this.getIndex((int)x, (int)y, (int)band)] = value;
    }

    @Override
    public void unsafe_set(int x, int y, int ... value) {
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            this.data[index] = (short)value[i];
            ++i;
            ++index;
        }
    }

    @Override
    public void setBand(int x, int y, int band, int value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds. (" + x + "," + y + ")");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested. band=" + band);
        }
        this.data[this.getIndex((int)x, (int)y, (int)band)] = (short)value;
    }

    @Override
    public void copyCol(int col, int row0, int row1, int offset, Object array) {
        int idxSrc;
        short[] dst = (short[])array;
        int idxDst = offset;
        int end = idxSrc + (row1 - row0) * this.stride;
        for (idxSrc = this.startIndex + this.stride * row0 + col * this.numBands; idxSrc < end; idxSrc += this.stride) {
            for (int i = 0; i < this.numBands; ++i) {
                dst[idxDst++] = this.data[idxSrc + i];
            }
        }
    }

    @Override
    protected Object _getData() {
        return this.data;
    }

    @Override
    protected Class getPrimitiveDataType() {
        return Short.TYPE;
    }

    @Override
    protected void _setData(Object data) {
        this.data = (short[])data;
    }
}

