/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageInterleaved;
import org.jetbrains.annotations.Nullable;

public class InterleavedF64
extends ImageInterleaved<InterleavedF64> {
    public double[] data;

    public InterleavedF64(int width, int height, int numBands) {
        super(width, height, numBands);
    }

    public InterleavedF64() {
        this.data = new double[0];
    }

    @Override
    public String toString_element(int index) {
        return String.format("%5f", this.data[index]);
    }

    @Override
    public ImageDataType getDataType() {
        return ImageDataType.F64;
    }

    public double[] get(int x, int y, @Nullable double[] storage) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        if (storage == null) {
            storage = new double[this.numBands];
        }
        this.unsafe_get(x, y, storage);
        return storage;
    }

    public void unsafe_get(int x, int y, double[] storage) {
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            storage[i] = this.data[index];
            ++i;
            ++index;
        }
    }

    public void set(int x, int y, double ... value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        this.unsafe_set(x, y, value);
    }

    public void unsafe_set(int x, int y, double ... value) {
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            this.data[index] = value[i];
            ++i;
            ++index;
        }
    }

    public double getBand(int x, int y, int band) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        return this.data[this.getIndex(x, y, band)];
    }

    public void setBand(int x, int y, int band, double value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        this.data[this.getIndex((int)x, (int)y, (int)band)] = value;
    }

    @Override
    public void copyCol(int col, int row0, int row1, int offset, Object array) {
        int idxSrc;
        double[] dst = (double[])array;
        int idxDst = offset;
        int end = idxSrc + (row1 - row0) * this.stride;
        for (idxSrc = this.startIndex + this.stride * row0 + col * this.numBands; idxSrc < end; idxSrc += this.stride) {
            for (int i = 0; i < this.numBands; ++i) {
                dst[idxDst++] = this.data[idxSrc + i];
            }
        }
    }

    @Override
    protected Object _getData() {
        return this.data;
    }

    @Override
    protected Class getPrimitiveDataType() {
        return Double.TYPE;
    }

    @Override
    protected void _setData(Object data) {
        this.data = (double[])data;
    }

    @Override
    public InterleavedF64 createNew(int imgWidth, int imgHeight) {
        if (imgWidth == -1 || imgHeight == -1) {
            return new InterleavedF64();
        }
        return new InterleavedF64(imgWidth, imgHeight, this.numBands);
    }
}

