/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import java.io.Serializable;
import java.lang.reflect.Array;

public class ImageType<T extends ImageBase>
implements Serializable {
    public static final ImageType<GrayU8> SB_U8 = ImageType.single(GrayU8.class);
    public static final ImageType<GrayS8> SB_S8 = ImageType.single(GrayS8.class);
    public static final ImageType<GrayU16> SB_U16 = ImageType.single(GrayU16.class);
    public static final ImageType<GrayS16> SB_S16 = ImageType.single(GrayS16.class);
    public static final ImageType<GrayS32> SB_S32 = ImageType.single(GrayS32.class);
    public static final ImageType<GrayS64> SB_S64 = ImageType.single(GrayS64.class);
    public static final ImageType<GrayF32> SB_F32 = ImageType.single(GrayF32.class);
    public static final ImageType<GrayF64> SB_F64 = ImageType.single(GrayF64.class);
    public static final ImageType<InterleavedU8> IL_U8 = ImageType.il(0, InterleavedU8.class);
    public static final ImageType<InterleavedS8> IL_S8 = ImageType.il(0, InterleavedS8.class);
    public static final ImageType<InterleavedU16> IL_U16 = ImageType.il(0, InterleavedU16.class);
    public static final ImageType<InterleavedS16> IL_S16 = ImageType.il(0, InterleavedS16.class);
    public static final ImageType<InterleavedS32> IL_S32 = ImageType.il(0, InterleavedS32.class);
    public static final ImageType<InterleavedS64> IL_S64 = ImageType.il(0, InterleavedS64.class);
    public static final ImageType<InterleavedF32> IL_F32 = ImageType.il(0, InterleavedF32.class);
    public static final ImageType<InterleavedF64> IL_F64 = ImageType.il(0, InterleavedF64.class);
    public static final ImageType<Planar<GrayU8>> PL_U8 = ImageType.pl(0, GrayU8.class);
    public static final ImageType<Planar<GrayS8>> PL_S8 = ImageType.pl(0, GrayS8.class);
    public static final ImageType<Planar<GrayU16>> PL_U16 = ImageType.pl(0, GrayU16.class);
    public static final ImageType<Planar<GrayS16>> PL_S16 = ImageType.pl(0, GrayS16.class);
    public static final ImageType<Planar<GrayS32>> PL_S32 = ImageType.pl(0, GrayS32.class);
    public static final ImageType<Planar<GrayS64>> PL_S64 = ImageType.pl(0, GrayS64.class);
    public static final ImageType<Planar<GrayF32>> PL_F32 = ImageType.pl(0, GrayF32.class);
    public static final ImageType<Planar<GrayF64>> PL_F64 = ImageType.pl(0, GrayF64.class);
    Family family;
    ImageDataType dataType;
    public int numBands;

    public ImageType(Family family, ImageDataType dataType, int numBands) {
        this.family = family;
        this.dataType = dataType;
        this.numBands = numBands;
    }

    protected ImageType() {
        this.family = Family.GRAY;
        this.dataType = ImageDataType.U8;
        this.numBands = 1;
    }

    public static <I extends ImageGray<I>> ImageType<I> single(Class<I> imageType) {
        return new ImageType(Family.GRAY, ImageDataType.classToType(imageType), 1);
    }

    public static <I extends ImageGray<I>> ImageType<I> single(ImageDataType type) {
        return new ImageType(Family.GRAY, type, 1);
    }

    public static <I extends ImageGray<I>> ImageType<Planar<I>> pl(int numBands, Class<I> imageType) {
        return new ImageType<Planar<I>>(Family.PLANAR, ImageDataType.classToType(imageType), numBands);
    }

    public static <I extends ImageGray<I>> ImageType<Planar<I>> pl(int numBands, ImageDataType type) {
        return new ImageType<Planar<I>>(Family.PLANAR, type, numBands);
    }

    public static <I extends ImageInterleaved<I>> ImageType<I> il(int numBands, Class<I> imageType) {
        return new ImageType(Family.INTERLEAVED, ImageDataType.classToType(imageType), numBands);
    }

    public static <I extends ImageInterleaved<I>> ImageType<I> il(int numBands, ImageDataType type) {
        return new ImageType(Family.INTERLEAVED, type, numBands);
    }

    public static <T extends ImageBase> ImageType<T> stringToType(String name, int numBands) {
        ImageType<ImageBase> imageType;
        ImageType<T> type = new ImageType<T>();
        switch (name) {
            case "SB_U8": {
                imageType = SB_U8;
                break;
            }
            case "SB_S8": {
                imageType = SB_S8;
                break;
            }
            case "SB_S16": {
                imageType = SB_S16;
                break;
            }
            case "SB_U16": {
                imageType = SB_U16;
                break;
            }
            case "SB_S32": {
                imageType = SB_S32;
                break;
            }
            case "SB_S64": {
                imageType = SB_S64;
                break;
            }
            case "SB_F32": {
                imageType = SB_F32;
                break;
            }
            case "SB_F64": {
                imageType = SB_F64;
                break;
            }
            case "IL_U8": {
                imageType = IL_U8;
                break;
            }
            case "IL_S8": {
                imageType = IL_S8;
                break;
            }
            case "IL_S16": {
                imageType = IL_S16;
                break;
            }
            case "IL_U16": {
                imageType = IL_U16;
                break;
            }
            case "IL_S32": {
                imageType = IL_S32;
                break;
            }
            case "IL_S64": {
                imageType = IL_S64;
                break;
            }
            case "IL_F32": {
                imageType = IL_F32;
                break;
            }
            case "IL_F64": {
                imageType = IL_F64;
                break;
            }
            case "PL_U8": {
                imageType = PL_U8;
                break;
            }
            case "PL_S8": {
                imageType = PL_S8;
                break;
            }
            case "PL_S16": {
                imageType = PL_S16;
                break;
            }
            case "PL_U16": {
                imageType = PL_U16;
                break;
            }
            case "PL_S32": {
                imageType = PL_S32;
                break;
            }
            case "PL_S64": {
                imageType = PL_S64;
                break;
            }
            case "PL_F32": {
                imageType = PL_F32;
                break;
            }
            case "PL_F64": {
                imageType = PL_F64;
                break;
            }
            default: {
                throw new RuntimeException("Unknown " + name);
            }
        }
        type.setTo(imageType);
        type.numBands = numBands;
        return type;
    }

    public ImageDataType getDataType() {
        return this.dataType;
    }

    public T createImage(int width, int height) {
        Planar<Object> planar;
        switch (this.family) {
            case GRAY: {
                planar = ImageGray.create(this.getImageClass(), width, height);
                break;
            }
            case INTERLEAVED: {
                planar = ImageInterleaved.create(this.getImageClass(), width, height, this.numBands);
                break;
            }
            case PLANAR: {
                planar = new Planar(this.getImageClass(), width, height, this.numBands);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type not yet supported");
            }
        }
        return (T)planar;
    }

    public T[] createArray(int length) {
        ImageBase[] imageBaseArray;
        switch (this.family) {
            case GRAY: 
            case INTERLEAVED: {
                imageBaseArray = (ImageBase[])Array.newInstance(this.getImageClass(), length);
                break;
            }
            case PLANAR: {
                imageBaseArray = new Planar[length];
                break;
            }
            default: {
                throw new IllegalArgumentException("Type not yet supported");
            }
        }
        return imageBaseArray;
    }

    public int getNumBands() {
        return this.numBands;
    }

    public Family getFamily() {
        return this.family;
    }

    public Class getImageClass() {
        return ImageType.getImageClass(this.family, this.dataType);
    }

    public static Class getImageClass(Family family, ImageDataType dataType) {
        Class clazz;
        block0 : switch (family) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case GRAY: 
            case PLANAR: {
                switch (dataType) {
                    case F32: {
                        clazz = GrayF32.class;
                        break block0;
                    }
                    case F64: {
                        clazz = GrayF64.class;
                        break block0;
                    }
                    case U8: {
                        clazz = GrayU8.class;
                        break block0;
                    }
                    case S8: {
                        clazz = GrayS8.class;
                        break block0;
                    }
                    case U16: {
                        clazz = GrayU16.class;
                        break block0;
                    }
                    case S16: {
                        clazz = GrayS16.class;
                        break block0;
                    }
                    case S32: {
                        clazz = GrayS32.class;
                        break block0;
                    }
                    case S64: {
                        clazz = GrayS64.class;
                        break block0;
                    }
                    case I8: {
                        clazz = GrayI8.class;
                        break block0;
                    }
                    case I16: {
                        clazz = GrayI16.class;
                        break block0;
                    }
                }
                throw new RuntimeException("Support this image type thing");
            }
            case INTERLEAVED: {
                switch (dataType) {
                    case F32: {
                        clazz = InterleavedF32.class;
                        break block0;
                    }
                    case F64: {
                        clazz = InterleavedF64.class;
                        break block0;
                    }
                    case U8: {
                        clazz = InterleavedU8.class;
                        break block0;
                    }
                    case S8: {
                        clazz = InterleavedS8.class;
                        break block0;
                    }
                    case U16: {
                        clazz = InterleavedU16.class;
                        break block0;
                    }
                    case S16: {
                        clazz = InterleavedS16.class;
                        break block0;
                    }
                    case S32: {
                        clazz = InterleavedS32.class;
                        break block0;
                    }
                    case S64: {
                        clazz = InterleavedS64.class;
                        break block0;
                    }
                    case I8: {
                        clazz = InterleavedI8.class;
                        break block0;
                    }
                    case I16: {
                        clazz = InterleavedI16.class;
                        break block0;
                    }
                }
                throw new RuntimeException("Support this image type thing");
            }
        }
        return clazz;
    }

    public String toString() {
        return "ImageType( " + this.family + " " + this.dataType + " " + this.numBands + " )";
    }

    public boolean isSameType(ImageType o) {
        if (this.family != o.family) {
            return false;
        }
        if (this.dataType != o.dataType) {
            return false;
        }
        return this.numBands == o.numBands;
    }

    public void setTo(ImageType o) {
        this.family = o.family;
        this.dataType = o.dataType;
        this.numBands = o.numBands;
    }

    public static enum Family {
        GRAY,
        PLANAR,
        INTERLEAVED;

    }
}

