/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;

public abstract class GrayI<T extends GrayI<T>>
extends ImageGray<T> {
    protected GrayI(int width, int height) {
        super(width, height);
    }

    protected GrayI() {
    }

    public int get(int x, int y) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds: " + x + " " + y);
        }
        return this.unsafe_get(x, y);
    }

    public abstract void set(int var1, int var2, int var3);

    public abstract void unsafe_set(int var1, int var2, int var3);

    public abstract int unsafe_get(int var1, int var2);

    public void forEachPixel(EachPixel function) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                function.process(x, y, this.unsafe_get(x, y));
            }
        }
    }

    @Override
    public ImageDataType getDataType() {
        return ImageDataType.I;
    }

    @Override
    public void print() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                System.out.printf("%3d ", this.get(x, y));
            }
            System.out.println();
        }
    }

    public void printBinary() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                System.out.printf("%1d", this.get(x, y));
            }
            System.out.println();
        }
    }

    public void printNotZero() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (this.unsafe_get(x, y) == 0) {
                    System.out.print("0");
                    continue;
                }
                System.out.print("1");
            }
            System.out.println();
        }
    }

    @FunctionalInterface
    public static interface EachPixel {
        public void process(int var1, int var2, int var3);
    }
}

