/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.geo;

import georegression.struct.point.Point2D_F64;

public class AssociatedPair {
    public Point2D_F64 p1;
    public Point2D_F64 p2;

    public AssociatedPair() {
        this.p1 = new Point2D_F64();
        this.p2 = new Point2D_F64();
    }

    public AssociatedPair(double x1, double y1, double x2, double y2) {
        this.p1 = new Point2D_F64(x1, y1);
        this.p2 = new Point2D_F64(x2, y2);
    }

    public AssociatedPair(Point2D_F64 p1, Point2D_F64 p2) {
        this(p1, p2, true);
    }

    public AssociatedPair(Point2D_F64 p1, Point2D_F64 p2, boolean newInstance) {
        if (newInstance) {
            this.p1 = new Point2D_F64(p1);
            this.p2 = new Point2D_F64(p2);
        } else {
            this.p1 = p1;
            this.p2 = p2;
        }
    }

    public AssociatedPair setTo(AssociatedPair original) {
        this.p1.setTo(original.p1);
        this.p2.setTo(original.p2);
        return this;
    }

    public AssociatedPair setTo(Point2D_F64 p1, Point2D_F64 p2) {
        this.p1.setTo(p1);
        this.p2.setTo(p2);
        return this;
    }

    public AssociatedPair setTo(Point2D_F64 p1, double p2_x, double p2_y) {
        this.p1.setTo(p1);
        this.p2.setTo(p2_x, p2_y);
        return this;
    }

    public AssociatedPair setTo(double p1_x, double p1_y, Point2D_F64 p2) {
        this.p1.setTo(p1_x, p1_y);
        this.p2.setTo(p2);
        return this;
    }

    public AssociatedPair setTo(double p1_x, double p1_y, double p2_x, double p2_y) {
        this.p1.setTo(p1_x, p1_y);
        this.p2.setTo(p2_x, p2_y);
        return this;
    }

    public void assign(Point2D_F64 p1, Point2D_F64 p2) {
        this.p1 = p1;
        this.p2 = p2;
    }

    public void zero() {
        this.p1.zero();
        this.p2.zero();
    }

    public AssociatedPair copy() {
        return new AssociatedPair().setTo(this.p1, this.p2);
    }

    public double distance() {
        return this.p1.distance(this.p2);
    }

    public double distance2() {
        return this.p1.distance2(this.p2);
    }

    public String toString() {
        return "AssociatedPair{p1=(" + this.p1.x + ", " + this.p1.y + "), p2=(" + this.p2.x + ", " + this.p2.y + ")}";
    }

    public Point2D_F64 getP1() {
        return this.p1;
    }

    public Point2D_F64 getP2() {
        return this.p2;
    }
}

