/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.calib;

import boofcv.struct.calib.CameraModel;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.EulerType;
import georegression.struct.se.Se3_F64;
import georegression.struct.se.SpecialEuclideanOps_F64;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MultiCameraCalibParams
implements Serializable {
    public static final long serialVersionUID = 1L;
    public final List<CameraModel> intrinsics = new ArrayList<CameraModel>();
    public final List<Se3_F64> camerasToSensor = new ArrayList<Se3_F64>();

    public void reset() {
        this.intrinsics.clear();
        this.camerasToSensor.clear();
    }

    public <Cam extends CameraModel> Cam getIntrinsics(int index) {
        return (Cam)this.intrinsics.get(index);
    }

    public Se3_F64 getCameraToSensor(int index) {
        return this.camerasToSensor.get(index);
    }

    public double getBaseline(int cam0, int cam1) {
        return this.computeExtrinsics((int)cam0, (int)cam1, null).T.norm();
    }

    public Se3_F64 computeExtrinsics(int cam0, int cam1, @Nullable Se3_F64 cam0_to_cam1) {
        if (cam0_to_cam1 == null) {
            cam0_to_cam1 = new Se3_F64();
        }
        Se3_F64 camera0_to_sensor = this.camerasToSensor.get(cam0);
        Se3_F64 camera1_to_sensor = this.camerasToSensor.get(cam1);
        camera0_to_sensor.concat(camera1_to_sensor.invert((Se3_F64)null), cam0_to_cam1);
        return cam0_to_cam1;
    }

    public boolean isIdentical_WARNING(MultiCameraCalibParams o) {
        Serializable b;
        Serializable a;
        int i;
        if (this.intrinsics.size() != o.intrinsics.size()) {
            return false;
        }
        if (this.camerasToSensor.size() != o.camerasToSensor.size()) {
            return false;
        }
        for (i = 0; i < this.intrinsics.size(); ++i) {
            a = this.intrinsics.get(i);
            b = o.intrinsics.get(i);
            if (a.getClass() == b.getClass()) continue;
            return false;
        }
        for (i = 0; i < this.camerasToSensor.size(); ++i) {
            a = this.camerasToSensor.get(i);
            if (SpecialEuclideanOps_F64.isIdentical((Se3_F64)a, (Se3_F64)(b = o.camerasToSensor.get(i)), 0.0, 0.0)) continue;
            return false;
        }
        return true;
    }

    public String toStringFormat() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" {\n");
        builder.append("  intrinsics {\n");
        for (i = 0; i < this.intrinsics.size(); ++i) {
            CameraModel model = this.intrinsics.get(i);
            builder.append("    [").append(i).append("] ").append(model).append("\n");
        }
        builder.append("  }\n");
        builder.append("  camerasToSensor {\n");
        for (i = 0; i < this.camerasToSensor.size(); ++i) {
            Se3_F64 extrinsic = this.camerasToSensor.get(i);
            double[] euler = ConvertRotation3D_F64.matrixToEuler(extrinsic.getR(), EulerType.XYZ, null);
            builder.append(String.format("    [%d] SE3{ T={%.2e, %.2e, %.2e} euler_xyz={%.5f, %.5f, %.5f} }\n", i, extrinsic.T.x, extrinsic.T.y, extrinsic.T.z, euler[0], euler[1], euler[2]));
        }
        builder.append("  }\n}\n");
        return builder.toString();
    }

    public String toString() {
        String human = this.toStringFormat();
        return human.replace("\n", "").replace("  ", " ");
    }

    public List<CameraModel> getIntrinsics() {
        return this.intrinsics;
    }

    public List<Se3_F64> getCamerasToSensor() {
        return this.camerasToSensor;
    }
}

