/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct;

import boofcv.struct.Configuration;

public class ConfigLength
implements Configuration {
    public double length = -1.0;
    public double fraction = -1.0;

    public ConfigLength(double length, double fraction) {
        this.length = length;
        this.fraction = fraction;
    }

    public ConfigLength() {
    }

    public static ConfigLength fixed(double length) {
        return new ConfigLength(length, -1.0);
    }

    public static ConfigLength relative(double fraction, double minimum) {
        return new ConfigLength(minimum, fraction);
    }

    public void setFixed(double length) {
        this.fraction = -1.0;
        this.length = length;
    }

    public void setRelative(double fraction, double minimum) {
        this.fraction = fraction;
        this.length = minimum;
    }

    public double compute(double totalLength) {
        double size;
        if (this.fraction >= 0.0) {
            size = this.fraction * totalLength;
            size = Math.max(size, this.length);
        } else {
            size = this.length;
        }
        return size;
    }

    public boolean isRelative() {
        return this.fraction >= 0.0;
    }

    public boolean isFixed() {
        return this.fraction < 0.0;
    }

    public int computeI(double totalLength) {
        double size = this.compute(totalLength);
        if (size >= 0.0) {
            return (int)Math.round(size);
        }
        throw new IllegalArgumentException("Threshold was set to a negative value: " + size);
    }

    public int computeNegMaxI(double totalLength) {
        double size = this.compute(totalLength);
        if (size >= 0.0) {
            return (int)Math.round(size);
        }
        return Integer.MAX_VALUE;
    }

    public int getLengthI() {
        return (int)Math.round(this.length);
    }

    public boolean isIdentical(ConfigLength a) {
        return this.length == a.length && this.fraction == a.fraction;
    }

    @Override
    public void checkValidity() {
        if (this.isRelative() && (this.fraction < 0.0 || this.fraction > 1.0)) {
            throw new IllegalArgumentException("Fractional value must be from 0.0 to 1.0, inclusive");
        }
    }

    public ConfigLength setTo(ConfigLength src) {
        this.length = src.length;
        this.fraction = src.fraction;
        return this;
    }

    public ConfigLength copy() {
        return new ConfigLength().setTo(this);
    }

    public String toString() {
        Object out = "ConfigLength{";
        out = this.fraction >= 0.0 ? (String)out + "fraction=" + this.fraction + ", minimum=" + this.length : (String)out + ", length=" + this.length;
        out = (String)out + "}";
        return out;
    }

    public double getLength() {
        return this.length;
    }

    public double getFraction() {
        return this.fraction;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public void setFraction(double fraction) {
        this.fraction = fraction;
    }
}

