/*
 * Decompiled with CFR 0.152.
 */
package boofcv.misc;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Nullable;

public class VariableLockSet {
    protected ReentrantLock lock = new ReentrantLock();

    public void safe(Runnable r) {
        this.lock.lock();
        try {
            r.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    public <T> T select(SelectObject<T> select) {
        this.lock.lock();
        try {
            T t = select.select();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean safe(long timeoutMS, Runnable r) {
        block6: {
            try {
                if (this.lock.tryLock(timeoutMS, TimeUnit.MILLISECONDS)) {
                    r.run();
                    break block6;
                }
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> SelectResults<T> select(long timeoutMS, SelectObject<T> select) {
        SelectResults results = new SelectResults();
        try {
            results.success = this.lock.tryLock(timeoutMS, TimeUnit.MILLISECONDS);
            if (results.success) {
                results.selected = select.select();
            }
        }
        catch (InterruptedException e) {
            results.success = false;
        }
        finally {
            this.lock.unlock();
        }
        return results;
    }

    @Nullable
    public <T> T selectNull(SelectObjectNull<T> select) {
        this.lock.lock();
        try {
            T t = select.select();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> SelectResults<T> selectNull(long timeoutMS, SelectObjectNull<T> select) {
        SelectResults results = new SelectResults();
        try {
            results.success = this.lock.tryLock(timeoutMS, TimeUnit.MILLISECONDS);
            if (results.success) {
                T found = select.select();
                if (found == null) {
                    SelectResults<T> selectResults = null;
                    return selectResults;
                }
                results.selected = found;
            }
        }
        catch (InterruptedException e) {
            results.success = false;
        }
        finally {
            this.lock.unlock();
        }
        return results;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }

    @FunctionalInterface
    public static interface SelectObject<T> {
        public T select();
    }

    public static class SelectResults<T> {
        public boolean success = false;
        public T selected;
    }

    @FunctionalInterface
    public static interface SelectObjectNull<T> {
        @Nullable
        public T select();
    }
}

