/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class SimpleNumberSequenceReader {
    char commentChar;
    Reader input;
    List<Double> sequence;
    char[] buffer = new char[1024];

    public SimpleNumberSequenceReader(char commentChar) {
        this.commentChar = commentChar;
    }

    public List<Double> read(Reader input) throws IOException {
        this.input = input;
        this.sequence = new ArrayList<Double>();
        int v = input.read();
        while (v >= 0) {
            if (v == this.commentChar) {
                this.skipLine();
            } else {
                this.parseLine(v);
            }
            v = input.read();
        }
        this.dereferenceInput();
        return this.sequence;
    }

    private void dereferenceInput() {
        this.input = null;
    }

    private void parseLine(int v) throws IOException {
        String s;
        int size = 0;
        while (v >= 0 && v != 10) {
            if (Character.isWhitespace(v)) {
                if (size > 0) {
                    s = new String(this.buffer, 0, size);
                    this.sequence.add(Double.parseDouble(s));
                    size = 0;
                }
            } else {
                this.buffer[size++] = (char)v;
            }
            v = this.input.read();
        }
        if (size > 0) {
            s = new String(this.buffer, 0, size);
            this.sequence.add(Double.parseDouble(s));
        }
    }

    private void skipLine() throws IOException {
        int v = this.input.read();
        while (v >= 0 && v != 10) {
            v = this.input.read();
        }
    }

    public char getCommentChar() {
        return this.commentChar;
    }
}

