/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.gui.BoofSwingUtil;
import boofcv.io.image.UtilImageIO;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JOptionPane;

public class SaveImageOnClick
extends MouseAdapter {
    private static int saveCounter = 0;
    private static boolean hideSaveDialog = false;
    Component parent;

    public SaveImageOnClick(Component parent) {
        this.parent = parent;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        boolean clicked = BoofSwingUtil.isMiddleMouseButton(e);
        if (clicked) {
            String fileName = String.format("saved_image%03d.png", saveCounter++);
            System.out.println("Image saved to " + new File(fileName).getAbsolutePath());
            BufferedImage output = this.getBufferedImage();
            UtilImageIO.saveImage(output, fileName);
            if (hideSaveDialog) {
                return;
            }
            Object[] options = new Object[]{"Hide in Future", "OK"};
            int n = JOptionPane.showOptionDialog(this.parent, "Saved image to " + fileName, "Middle Mouse Click Image Saving", 2, 3, null, options, options[1]);
            if (n == 0) {
                hideSaveDialog = true;
            }
        }
    }

    protected BufferedImage getBufferedImage() {
        BufferedImage output = new BufferedImage(this.parent.getWidth(), this.parent.getHeight(), 4);
        this.parent.paint(output.createGraphics());
        return output;
    }
}

