/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.gui.BoofSwingUtil;
import georegression.geometry.UtilPoint2D_I32;
import georegression.struct.point.Point2D_I32;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class SelectRegionDescriptionPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    double clickTolerance = 10.0;
    BufferedImage background;
    @Nullable
    Point2D_I32 target;
    @Nullable
    Point2D_I32 current;
    double imageScale;
    Listener listener;
    boolean dragMode = false;

    public SelectRegionDescriptionPanel() {
        super(new BorderLayout());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setBackground(BufferedImage image) {
        this.background = image;
        this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
    }

    public void reset() {
        this.target = null;
        this.current = null;
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public Point2D_I32 getTarget() {
        return Objects.requireNonNull(this.target).copy();
    }

    public double getFeatureRadius() {
        double r = UtilPoint2D_I32.distance(this.target, this.current);
        if (r < 1.0) {
            return 1.0;
        }
        return r;
    }

    public double getFeatureOrientation() {
        double dy = this.current.y - this.target.y;
        double dx = this.current.x - this.target.x;
        return Math.atan2(dy, dx);
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.background == null) {
            return;
        }
        this.computeScale();
        Graphics2D g2 = BoofSwingUtil.antialiasing(g);
        int dstWidth = (int)(this.imageScale * (double)this.background.getWidth());
        int dstHeight = (int)(this.imageScale * (double)this.background.getHeight());
        g2.drawImage(this.background, 0, 0, dstWidth, dstHeight, 0, 0, this.background.getWidth(), this.background.getHeight(), null);
        if (this.target != null && this.current != null) {
            int x1 = (int)(this.imageScale * (double)this.target.x);
            int y1 = (int)(this.imageScale * (double)this.target.y);
            int x2 = (int)(this.imageScale * (double)this.current.x);
            int y2 = (int)(this.imageScale * (double)this.current.y);
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.BLUE);
            g2.drawLine(x1, y1, x2, y2);
            int r = (int)(this.imageScale * UtilPoint2D_I32.distance(this.target, this.current));
            g2.setStroke(new BasicStroke(6.0f));
            this.drawOval(g2, x1, y1, r, Color.black);
            g2.setStroke(new BasicStroke(2.0f));
            this.drawOval(g2, x1, y1, r, new Color(180, 180, 255));
            r = 5;
            int w = r * 2 + 1;
            g2.setColor(Color.black);
            g2.fillOval(x1 - r, y1 - r, w, w);
            r = 3;
            w = r * 2 + 1;
            g2.setColor(Color.red);
            g2.fillOval(x1 - r, y1 - r, w, w);
        }
    }

    private void drawOval(Graphics2D g2, int x, int y, int r, Color color) {
        int w = r * 2 + 1;
        g2.setColor(color);
        g2.drawOval(x - r, y - r, w, w);
    }

    private void computeScale() {
        double scaleX = (double)this.getWidth() / (double)this.background.getWidth();
        double scaleY = (double)this.getHeight() / (double)this.background.getHeight();
        this.imageScale = Math.min(scaleX, scaleY);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = (int)((double)e.getX() / this.imageScale);
        int y = (int)((double)e.getY() / this.imageScale);
        if (x < 0 || x >= this.background.getWidth() || y < 0 || y >= this.background.getHeight()) {
            if (this.target != null) {
                this.repaint();
                if (this.listener != null) {
                    this.listener.descriptionChanged(null, 0.0, 0.0);
                }
            }
            this.target = null;
            this.current = null;
        } else {
            boolean adjusted = false;
            if (this.target != null && this.current != null) {
                int targetX = (int)((double)this.target.x * this.imageScale);
                int targetY = (int)((double)this.target.y * this.imageScale);
                double distance = UtilPoint2D_I32.distance(e.getX(), e.getY(), targetX, targetY);
                if (distance < this.clickTolerance) {
                    this.dragMode = true;
                    this.current.x += x - this.target.x;
                    this.current.y += y - this.target.y;
                    this.target.setTo(x, y);
                    adjusted = true;
                } else {
                    double radiusCircle = this.imageScale * UtilPoint2D_I32.distance(this.target, this.current);
                    if ((distance = Math.abs(distance - radiusCircle)) < this.clickTolerance) {
                        this.current.setTo(x, y);
                        adjusted = true;
                    }
                }
            }
            if (adjusted) {
                this.repaint();
                if (this.listener != null) {
                    this.listener.descriptionChanged(this.target, this.getFeatureRadius(), this.getFeatureOrientation());
                }
            } else {
                this.dragMode = false;
                this.target = new Point2D_I32(x, y);
                this.current = this.target.copy();
                this.repaint();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.current == null || this.target == null) {
            return;
        }
        int x = (int)((double)e.getX() / this.imageScale);
        int y = (int)((double)e.getY() / this.imageScale);
        if (this.dragMode) {
            this.current.x += x - this.target.x;
            this.current.y += y - this.target.y;
            this.target.setTo(x, y);
        } else {
            this.current.setTo(x, y);
        }
        this.repaint();
        if (this.listener != null) {
            this.listener.descriptionChanged(this.target, this.getFeatureRadius(), this.getFeatureOrientation());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    @FunctionalInterface
    public static interface Listener {
        public void descriptionChanged(@Nullable Point2D_I32 var1, double var2, double var4);
    }
}

