/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.edge;

import boofcv.io.image.ConvertRaster;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU8;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.Nullable;

public class VisualizeEdgeFeatures {
    public static BufferedImage renderOrientation(GrayU8 direction, @Nullable BufferedImage out) {
        WritableRaster raster;
        if (out == null) {
            out = new BufferedImage(direction.getWidth(), direction.getHeight(), 1);
        }
        if ((raster = out.getRaster()).getDataBuffer().getDataType() == 3) {
            int[] colors = new int[]{Color.RED.getRGB(), Color.GREEN.getRGB(), Color.BLUE.getRGB(), Color.BLACK.getRGB()};
            int[] dataDst = ((DataBufferInt)raster.getDataBuffer()).getData();
            int strideDst = ConvertRaster.stride(raster);
            int offsetDst = ConvertRaster.getOffset(raster);
            int w = direction.getWidth();
            int h = direction.getHeight();
            for (int y = 0; y < h; ++y) {
                int indexDst = offsetDst + y * strideDst;
                int indexSrc = direction.startIndex + y * direction.stride;
                for (int x = 0; x < w; ++x) {
                    dataDst[indexDst++] = colors[direction.data[indexSrc++]];
                }
            }
        } else {
            throw new RuntimeException("Raster not supported yet");
        }
        return out;
    }

    public static BufferedImage renderOrientation4(GrayS8 direction, GrayF32 intensity, float threshold, @Nullable BufferedImage out) {
        WritableRaster raster;
        if (out == null) {
            out = new BufferedImage(direction.getWidth(), direction.getHeight(), 1);
        }
        if ((raster = out.getRaster()).getDataBuffer().getDataType() == 3) {
            int[] colors = new int[]{Color.RED.getRGB(), Color.GREEN.getRGB(), Color.BLUE.getRGB(), Color.BLACK.getRGB()};
            int white = Color.WHITE.getRGB();
            int[] dataDst = ((DataBufferInt)raster.getDataBuffer()).getData();
            int strideDst = ConvertRaster.stride(raster);
            int offsetDst = ConvertRaster.getOffset(raster);
            int w = direction.getWidth();
            int h = direction.getHeight();
            for (int y = 0; y < h; ++y) {
                int indexDst = offsetDst + y * strideDst;
                int indexSrc = direction.startIndex + y * direction.stride;
                int indexInten = intensity.startIndex + y * intensity.stride;
                int x = 0;
                while (x < w) {
                    dataDst[indexDst] = intensity.data[indexInten] >= threshold ? colors[direction.data[indexSrc] + 1] : white;
                    ++x;
                    ++indexInten;
                    ++indexSrc;
                    ++indexDst;
                }
            }
        } else {
            throw new RuntimeException("Raster not supported yet");
        }
        return out;
    }
}

